/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.diagrams.wave.EdgesMetrics;
import ro.amiq.dvt.ui.views.DVTPopupDialog;

public class WaveViewerCountEdgesPopup
extends DVTPopupDialog {
    private String nodeName;
    private EdgesMetrics edgesMetrics;
    private static final int DIALOG_AREA_WIDTH = 325;
    private static final int DIALOG_AREA_HEIGHT = 225;

    protected WaveViewerCountEdgesPopup(Shell parent, String nodeName, EdgesMetrics edgesMetrics) {
        super(parent, 80, true, false, false, false, true, "", "");
        this.edgesMetrics = edgesMetrics;
        this.nodeName = nodeName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Count Edges for '" + this.nodeName + "' ");
    }

    @Override
    protected String getId() {
        return "Count Edges";
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(325, 225).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo(container);
        Table table = new Table(container, 67584);
        GridDataFactory.fillDefaults().grab(true, true).hint(325, 225).applyTo((Control)table);
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo((Composite)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn metric = new TableColumn(table, 0);
        metric.setText("Metric");
        metric.setWidth(150);
        TableColumn value = new TableColumn(table, 0);
        value.setText("Value");
        value.setWidth(100);
        TableItem time = new TableItem(table, 0);
        time.setText(new String[]{"Time: ", String.valueOf(this.edgesMetrics.getCursorsLowTime()) + " - " + this.edgesMetrics.getCursorsHighTime() + " " + this.edgesMetrics.getTimeUnit()});
        TableItem nofEdges = new TableItem(table, 0);
        nofEdges.setText(new String[]{"Edges: ", Long.toString(this.edgesMetrics.getNofEdges())});
        TableItem nofPosedge = new TableItem(table, 0);
        nofPosedge.setText(new String[]{"Posedges: ", this.edgesMetrics.getNofPosedges()});
        TableItem nofNegedge = new TableItem(table, 0);
        nofNegedge.setText(new String[]{"Negedges: ", this.edgesMetrics.getNofNegedges()});
        TableItem timeHigh = new TableItem(table, 0);
        timeHigh.setText(new String[]{"Time High: ", this.edgesMetrics.getTimeHigh()});
        TableItem timeLow = new TableItem(table, 0);
        timeLow.setText(new String[]{"Time Low: ", this.edgesMetrics.getTimeLow()});
        TableItem dutyCycle = new TableItem(table, 0);
        dutyCycle.setText(new String[]{"Duty Cycle: ", this.edgesMetrics.getDutyCycle()});
        return container;
    }
}

