/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;

public class WaveViewerCreateSeparatorDialog
extends DVTPopupDialog {
    protected Composite contentsComposite;
    protected Text separatorNameText;
    protected Button addButton;
    protected WCanvas canvas;
    protected WaveViewerSignalTableView signalsView;
    protected WSignalsTableElement selectedElement;
    protected TreeSet<WSignalsTableElement> selectedElementSiblings;
    protected int idOffset;
    private KeyListener enterKeyListener;

    protected WaveViewerCreateSeparatorDialog(WCanvas canvas, WaveViewerSignalTableView signalsView, WSignalsTableElement selectedElement, TreeSet<WSignalsTableElement> selectedElementSiblings, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(canvas.getShell(), shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        this.canvas = canvas;
        this.signalsView = signalsView;
        this.selectedElement = selectedElement;
        this.selectedElementSiblings = selectedElementSiblings;
        this.enterKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveViewerCreateSeparatorDialog.this.addButtonAction();
                }
            }
        };
    }

    @Override
    protected String getId() {
        return "ro.amiq.dvt.ui.waveviewer.WaveViewerCreateSeparatorDialog";
    }

    protected Control createDialogArea(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().hint(450, -1).grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        this.createSeparatorNameArea();
        this.createSeparatorPositionArea();
        this.createButtonsArea();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        this.getShell().setText("Waveform Viewer Create Separator Dialog");
        return this.contentsComposite;
    }

    protected void createSeparatorNameArea() {
        Composite textAreaComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)textAreaComposite);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(textAreaComposite);
        Group nameGroup = new Group(textAreaComposite, 0);
        nameGroup.setText("Name");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)nameGroup);
        this.separatorNameText = new Text((Composite)nameGroup, 2048);
        this.separatorNameText.setMessage("Choose a name");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.separatorNameText);
        this.separatorNameText.addKeyListener(this.enterKeyListener);
    }

    protected void createSeparatorPositionArea() {
        Composite positionAreaComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).applyTo((Control)positionAreaComposite);
        GridLayoutFactory.fillDefaults().margins(10, 0).applyTo(positionAreaComposite);
        Group positionGroup = new Group(positionAreaComposite, 0);
        positionGroup.setText("Position");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)positionGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).equalWidth(true).applyTo((Composite)positionGroup);
        Button below = new Button((Composite)positionGroup, 16);
        below.setText("Below");
        below.setSelection(true);
        this.idOffset = 1;
        Button above = new Button((Composite)positionGroup, 16);
        above.setText("Above");
        below.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerCreateSeparatorDialog.this.idOffset = 1;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        above.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerCreateSeparatorDialog.this.idOffset = 0;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        below.addKeyListener(this.enterKeyListener);
        above.addKeyListener(this.enterKeyListener);
    }

    protected void createButtonsArea() {
        Composite buttonsComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, true).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonsComposite);
        Button cancelbutton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)cancelbutton);
        cancelbutton.setText("Cancel");
        cancelbutton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerCreateSeparatorDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addButton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addButton);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerCreateSeparatorDialog.this.addButtonAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addButtonAction() {
        int separatorId = this.selectedElement.getId() + this.idOffset;
        String separatorName = this.separatorNameText.getText().trim();
        if (separatorName == null || separatorName.isEmpty()) {
            separatorName = "__dvt_empty_separator";
        }
        DVTVCDUtils.addSignalsTableElement(this.selectedElementSiblings, new WSignalsTableSeparator(separatorId, separatorName, null));
        DVTVCDUtils.refreshWaveViewer(this.signalsView, this.canvas);
        this.close();
    }
}

