/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.diagrams.wave.IDWaveSignalsGroup;
import ro.amiq.dvt.diagrams.wave.WaveViewerGroupSelectionArea;
import ro.amiq.dvt.diagrams.wave.WaveViewerLeftSignalsPanelView;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalScope;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalVar;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class WaveViewerDesignHierarchyView
implements IDWaveSignalsGroup {
    private WaveViewerGroupSelectionArea groupSelectionArea;
    protected WaveViewerLeftSignalsPanelView leftPanelView;
    private MouseAdapter leftPanelMouseListener;
    protected WCanvas canvas;
    protected WaveViewerSignalTableView signalsView;
    private WSignalsTableGroup selectedGroupInTable;
    private boolean isDetached;
    private boolean isClosed;
    private TreePath firstVisibleModule;
    private TreePath selectedModule;
    private ToolItem addButton;
    private ToolItem detachButton;
    private ToolItem groupSelectionButton;
    private Composite controlParent;

    public WaveViewerDesignHierarchyView(final WaveViewerSignalTableView signalsView) {
        this.signalsView = signalsView;
        this.canvas = signalsView.getCanvas();
        this.leftPanelMouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!DVTVCDUtils.getInstance().hasLicense(WaveViewerDesignHierarchyView.this.canvas)) {
                    return;
                }
                LinkedHashSet<String> signalsToAddVCDIds = WaveViewerDesignHierarchyView.this.getAllSignalsInScope();
                if (signalsToAddVCDIds == null || signalsToAddVCDIds.isEmpty()) {
                    return;
                }
                WaveViewerDesignHierarchyView.this.selectedGroupInTable = DVTVCDUtils.addSignalsAction(WaveViewerDesignHierarchyView.this.canvas, WaveViewerDesignHierarchyView.this.selectedGroupInTable, signalsView, signalsToAddVCDIds);
            }
        };
    }

    public void initAndShow(Composite parent) {
        this.controlParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.controlParent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(1).equalWidth(false).margins(0, 0).applyTo(this.controlParent);
        this.createSignalsSelectionArea(this.controlParent);
        this.createButtonsArea(this.controlParent);
        this.setInitialGroupSelection();
        this.updateView(this.selectedModule, this.firstVisibleModule);
    }

    private WaveViewerLeftSignalsPanelView createSignalsSelectionArea(Composite container) {
        SashForm upperSashForm = new SashForm(container, 528);
        upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        upperSashForm.setLayoutData((Object)new GridData(1808));
        this.leftPanelView = new WaveViewerLeftSignalsPanelView(this.signalsView.getWaveEditor());
        this.leftPanelView.createPartControl((Composite)upperSashForm);
        Tree panelTree = this.leftPanelView.getLazyTree().getTree();
        panelTree.addMouseListener((MouseListener)this.leftPanelMouseListener);
        panelTree.setLinesVisible(true);
        panelTree.setHeaderVisible(false);
        TableViewer table = this.leftPanelView.getSignalsView().getTable();
        table.addDoubleClickListener(event -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
                return;
            }
            Set<String> signalsToAddVCDIds = this.getLeafSignals();
            this.selectedGroupInTable = DVTVCDUtils.addSignalsAction(this.canvas, this.selectedGroupInTable, this.signalsView, signalsToAddVCDIds);
        });
        table.addSelectionChangedListener(event -> this.validateAddButton());
        upperSashForm.setWeights(new int[]{700, 300});
        return this.leftPanelView;
    }

    protected void createButtonsArea(Composite dhSashForm) {
        Composite buttonsComposite = new Composite(dhSashForm, 20);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(buttonsComposite);
        ToolBar leftBar = new ToolBar(buttonsComposite, 0x820000);
        leftBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.detachButton = new ToolItem(leftBar, 8);
        this.detachButton.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_WIEW_DETACH_ATTACH));
        this.detachButton.setToolTipText(this.isDetached ? "Reattach" : "Detach");
        this.detachButton.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
                return;
            }
            this.detachAction();
        });
        ToolBar rightBar = new ToolBar(buttonsComposite, 0x820000);
        GridData gdRight = new GridData(131072, 0x1000000, true, false);
        gdRight.heightHint = 40;
        rightBar.setLayoutData((Object)gdRight);
        this.addGroupSelection(rightBar);
        this.addButton = new ToolItem(rightBar, 8);
        this.addButton.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_ADD));
        this.addButton.setToolTipText("Add Signal");
        this.addButton.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
                return;
            }
            Set<String> signalsToAddVCDIds = this.getLeafSignals();
            if (signalsToAddVCDIds == null || signalsToAddVCDIds.isEmpty()) {
                return;
            }
            this.selectedGroupInTable = DVTVCDUtils.addSignalsAction(this.canvas, this.selectedGroupInTable, this.signalsView, signalsToAddVCDIds);
        });
        this.addButton.setEnabled(false);
    }

    private void addGroupSelection(ToolBar tb) {
        Composite comp = new Composite((Composite)tb, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        comp.setLayout((Layout)layout);
        this.groupSelectionButton = new ToolItem(tb, 2);
        Label imgLabel = new Label(comp, 0);
        imgLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        imgLabel.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_SIGNAL_GROUPS));
        this.groupSelectionArea = new WaveViewerGroupSelectionArea(this.canvas, comp){

            @Override
            public void updateOnGroupSelectionChanged() {
                String selectedGroupName = this.getSelectedGroupName();
                if (selectedGroupName == null) {
                    return;
                }
                WViewport viewport = WaveViewerDesignHierarchyView.this.canvas.getViewport();
                TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
                WaveViewerDesignHierarchyView.this.selectedGroupInTable = this.getExistingGroupWrapper(selectedGroupName, signalsTableNodes);
            }
        };
        this.groupSelectionButton.setControl((Control)comp);
        Point size = comp.computeSize(-1, -1);
        this.groupSelectionButton.setWidth(size.x);
        this.groupSelectionButton.setToolTipText("Group");
        this.groupSelectionButton.addListener(13, e -> this.groupSelectionArea.updateOnGroupSelectionChanged());
    }

    private void detachAction() {
        this.isDetached = !this.isDetached;
        this.signalsView.getWaveEditor().showDHSignalsView();
        if (this.isDetached) {
            this.signalsView.getWaveEditor().closeDHSignalsSidePanel();
        } else {
            this.signalsView.getWaveEditor().closeDHSignalsDialog();
        }
        this.detachButton.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_WIEW_DETACH_ATTACH));
        this.detachButton.setToolTipText(this.isDetached ? "Reattach" : "Detach");
    }

    public void updateOnRemove(TreePath removedTreePath) {
        if (this.isClosed) {
            return;
        }
        WSignalsTableElement signalWrapper = DVTVCDUtils.getSignalsTableElement(removedTreePath);
        this.groupSelectionArea.removeGroupComboEntry(signalWrapper.getName());
        WViewport viewport = this.canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes == null) {
            return;
        }
        this.selectedGroupInTable = DVTVCDUtils.getExistingGroup(this.getSelectedGroupName(), signalsTableNodes);
    }

    public void updateOnRename(String oldGroupName, String newGroupName) {
        if (this.isClosed) {
            return;
        }
        this.groupSelectionArea.renameGroupComboEntry(oldGroupName, newGroupName);
    }

    public void updateOnSelectedTreePath(TreePath selectedTreePath) {
        if (this.isClosed) {
            return;
        }
        WSignalsTableElement signalWrapper = DVTVCDUtils.getSignalsTableElement(selectedTreePath);
        if (!(signalWrapper instanceof WSignalsTableGroup)) {
            signalWrapper = DVTVCDUtils.getParentGroup(signalWrapper);
        }
        if (signalWrapper == null || !(signalWrapper instanceof WSignalsTableGroup)) {
            return;
        }
        this.groupSelectionArea.setGroupSelection(signalWrapper.getName());
        this.selectedGroupInTable = (WSignalsTableGroup)signalWrapper;
    }

    public void updateOnCreateNewGroup(TreePath groupTreePath) {
        if (this.isClosed) {
            return;
        }
        this.groupSelectionArea.addGroupComboEntry(groupTreePath.lastSegment());
        this.updateOnSelectedTreePath(groupTreePath);
    }

    public void clear() {
        DVTVCDUtils.refreshWaveViewer(this.signalsView, this.canvas);
        if (this.leftPanelView != null) {
            this.leftPanelView.clean();
        }
        this.leftPanelView = null;
    }

    protected void setInitialGroupSelection() {
        List<TreePath> selections = this.signalsView.getLazyTree().getSelections();
        if (selections == null || selections.isEmpty()) {
            this.groupSelectionArea.setGroupSelection("default");
            return;
        }
        WSignalsTableElement selection = DVTVCDUtils.getSignalsTableElement(selections.get(0));
        if (!(selection instanceof WSignalsTableGroup)) {
            selection = DVTVCDUtils.getParentGroup(selection);
        }
        this.groupSelectionArea.setGroupSelection(selection.getName());
        this.selectedGroupInTable = (WSignalsTableGroup)selection;
    }

    protected void updateView(TreePath selectedNode, TreePath firstNode) {
        this.leftPanelView.updateUsingTreePath(selectedNode, firstNode);
    }

    @Override
    public String getNewGroupName() {
        return null;
    }

    @Override
    public String getSelectedGroupName() {
        return this.groupSelectionArea.getSelectedGroupName();
    }

    @Override
    public WCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public WSignalsTableGroup getGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableNodes) {
        return null;
    }

    public void validateAddButton() {
        IStructuredSelection tableSelection = this.leftPanelView.getSignalsView().getTable().getStructuredSelection();
        if (tableSelection == null) {
            this.addButton.setEnabled(false);
            return;
        }
        Object[] selectedElements = tableSelection.toArray();
        if (selectedElements.length == 0) {
            this.addButton.setEnabled(false);
            return;
        }
        this.addButton.setEnabled(true);
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    private LinkedHashSet<String> getAllSignalsInScope() {
        TreeItem[] treeItemSelection = this.leftPanelView.getLazyTree().getTreeItemSelection();
        if (treeItemSelection.length == 0) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        TreeItem[] treeItemArray = treeItemSelection;
        int n = treeItemSelection.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedHashSet<DVTVCDHierarchicalVar> childSignals;
            Object element;
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof TreePath && (element = ((TreePath)data).getElement()) instanceof DVTVCDHierarchicalScope && (childSignals = ((DVTVCDHierarchicalScope)element).getChildSignals()) != null && !childSignals.isEmpty()) {
                for (DVTVCDHierarchicalVar childSignal : childSignals) {
                    result.add(childSignal.getVcdId());
                }
            }
            ++n2;
        }
        return result;
    }

    private Set<String> getLeafSignals() {
        IStructuredSelection tableSelection = this.leftPanelView.getSignalsView().getTable().getStructuredSelection();
        if (tableSelection == null) {
            return null;
        }
        Object[] selectedElements = tableSelection.toArray();
        if (selectedElements.length == 0) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Object[] objectArray = selectedElements;
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DVTVCDHierarchicalVar) {
                result.add(((DVTVCDHierarchicalVar)element).getVcdId());
            }
            ++n2;
        }
        return result;
    }

    public void setIsClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public Composite testGetControlParent() {
        if (TestHelper.isTestMode()) {
            return this.controlParent;
        }
        return null;
    }

    public WaveViewerLeftSignalsPanelView testGetLeftSignalsPanelView() {
        if (TestHelper.isTestMode()) {
            return this.leftPanelView;
        }
        return null;
    }

    protected void saveTreeState() {
        if (this.leftPanelView == null) {
            return;
        }
        LazyTree lazyTree = this.leftPanelView.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        this.selectedModule = lazyTree.getSelection();
        this.firstVisibleModule = lazyTree.getFirstVisibleElement();
    }

    protected void resetTreeState() {
        this.selectedModule = null;
        this.firstVisibleModule = null;
    }

    public WaveViewerLeftSignalsPanelView getLeftPanelView() {
        return this.leftPanelView;
    }

    public void deepClean() {
        this.groupSelectionArea = null;
        if (this.leftPanelView != null) {
            this.leftPanelView.clean();
        }
        this.signalsView = null;
        this.leftPanelMouseListener = null;
    }
}

