/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorInput;
import ro.amiq.dvt.diagrams.wave.WaveViewerFactoryInputCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public class WaveViewerFactoryInput
extends WaveViewerFactoryInputCommon {
    public WaveViewerFactoryInput(WaveDiagramEditor waveEditor) {
        super(waveEditor);
    }

    public boolean isEnabled() {
        if (this.associatedProject == null || !this.associatedProject.exists()) {
            DVTLogger.INSTANCE.logError("Current wave is not under any project!");
            return false;
        }
        return true;
    }

    @Override
    protected void updateStatusBar(String message) {
        DVTWaveViewIDEFactory.getInstance().updateStatusBar(message, false);
    }

    @Override
    public boolean isButtonChecked() {
        return this.isChecked();
    }

    @Override
    public boolean activateOnFirstOpenedVcd() {
        if (this.isChecked() || !this.isEnabled()) {
            return false;
        }
        if (DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(this.associatedProject)) {
            return false;
        }
        this.setChecked(true);
        this.run();
        return true;
    }

    @Override
    public IProject getAssociatedProject() {
        WaveDiagramEditorInput input = this.waveEditor.getInput();
        if (input == null) {
            return null;
        }
        IFile file = input.getFile();
        if (file == null || !file.exists()) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null || !project.exists()) {
            return null;
        }
        return project;
    }

    @Override
    protected void setToolTip() {
        if (this.isChecked()) {
            String projectName = this.associatedProject == null ? "" : this.associatedProject.getName();
            this.setToolTipText("Unset current waveform viewer" + (projectName.isEmpty() ? "" : " for " + projectName));
            return;
        }
        if (this.associatedProject == null) {
            this.setToolTipText("Set current waveform viewer disabled (VCD not found in workspace)");
            return;
        }
        String projectName = this.associatedProject.getName();
        this.setToolTipText("Set current waveform viewer" + (projectName.isEmpty() ? "" : " for " + projectName));
    }
}

