/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public abstract class WaveViewerFactoryInputCommon
extends Action {
    private static final int INVALID_PATHS_LIMIT = 10;
    protected WaveDiagramEditor waveEditor;
    protected IProject associatedProject;

    protected WaveViewerFactoryInputCommon(WaveDiagramEditor waveEditor) {
        super("Open Design Panel", 2);
        this.setDescription("Set current wave as input for selected project");
        this.setImageDescriptor(DVTImages.WAVE_FILE_PIN);
        this.waveEditor = waveEditor;
        this.associatedProject = this.getAssociatedProject();
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.waveEditor.getCanvas())) {
            return;
        }
        if (this.associatedProject == null || !this.associatedProject.exists()) {
            DVTLogger.INSTANCE.logError("Current wave is not under any project!");
            DVTVCDUtils.getInstance().displayWarning("Waveform Viewer", "Could not set current waveform viewer as input!\nSelected project is null or doesn't exist!");
            return;
        }
        if (this.isButtonChecked()) {
            DVTWaveViewIDEFactory.getInstance().setInputWaveEditor(this.associatedProject, this.waveEditor);
            CheckDHValidityJob compareDHJob = new CheckDHValidityJob("Running DH match check for " + this.waveEditor.getTitle() + " in project " + this.associatedProject.getName() + "...");
            compareDHJob.schedule();
            WCanvas canvas = (WCanvas)this.waveEditor.getCanvas();
            WaveViewerSignalTableView signalsTableView = canvas.getSignalsTableView();
            if (signalsTableView == null) {
                return;
            }
            DVTVCDUtils.refreshWaveViewer(signalsTableView, canvas);
        } else {
            DVTWaveViewIDEFactory.getInstance().clearInput(this.waveEditor);
        }
        this.setToolTip();
    }

    protected abstract IProject getAssociatedProject();

    public abstract boolean isButtonChecked();

    protected abstract void updateStatusBar(String var1);

    public abstract boolean activateOnFirstOpenedVcd();

    protected abstract void setToolTip();

    class CheckDHValidityJob
    extends Job {
        public CheckDHValidityJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Set<ElementPath> invalidPaths = DVTWaveViewIDEFactory.getInstance().computeVCDDHValidInProject(WaveViewerFactoryInputCommon.this.associatedProject, 10);
            String projectName = WaveViewerFactoryInputCommon.this.associatedProject.getName();
            String fileName = WaveViewerFactoryInputCommon.this.waveEditor.getTitle();
            if (invalidPaths == null) {
                String message = MessageFormat.format("Could not verify if the VCD signal paths from {0} can be found in the design hierarchy elaborated by DVT for project {1}.\n\nReason: build is not finished or project not restored.", fileName, projectName);
                DVTVCDUtils.getInstance().displayWarning("Waveform Viewer", message);
            } else if (!invalidPaths.isEmpty()) {
                DVTLogger.INSTANCE.logDebug("VCD Design Hierarchy differ from project Design Hierarchy");
                String paths = invalidPaths.stream().map(elementPath -> elementPath.toString()).collect(Collectors.joining("\n"));
                if (invalidPaths.size() == 10) {
                    paths = String.valueOf(paths) + "\n...";
                }
                String message = MessageFormat.format("The following VCD signal paths from {0} have not been found in the design hierarchy elaborated by DVT for project {1}:\n\n{2}\n\nSome functionalities might not work as intended.", fileName, projectName, paths);
                DVTVCDUtils.getInstance().displayWarning("Design Hierarchy Mismatch", message);
            }
            return Status.OK_STATUS;
        }
    }
}

