/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.TreeSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.WaveViewerNewGroupNameTextArea;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public abstract class WaveViewerGroupSelectionArea {
    private WCanvas canvas;
    private Combo groupSelectionCombo;
    WaveViewerNewGroupNameTextArea newGroupNameTextArea;
    private SelectionListener groupSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            WaveViewerGroupSelectionArea.this.updateOnGroupSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    protected WaveViewerGroupSelectionArea(WCanvas canvas, Composite tb) {
        this.canvas = canvas;
        this.createGroupSelectionArea(tb);
    }

    private void createGroupSelectionArea(Composite tb) {
        this.groupSelectionCombo = new Combo(tb, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.getGroupSelectionCombo());
        this.addGroupSelectionComboEntries();
        this.getGroupSelectionCombo().addSelectionListener(this.groupSelectionListener);
        this.newGroupNameTextArea = new WaveViewerNewGroupNameTextArea(this.canvas, tb);
        this.hideNewGroupTextArea();
    }

    private void addGroupSelectionComboEntries() {
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return;
        }
        this.getGroupSelectionCombo().add("default");
        this.getGroupSelectionCombo().setData("default", (Object)"default");
        TreeSet<WSignalsTableElement> signalsTableElements = viewport.getSignalsTableElements();
        for (WSignalsTableElement signalsTableElement : signalsTableElements) {
            if (!(signalsTableElement instanceof WSignalsTableGroup) || signalsTableElement.getName().equals("default")) continue;
            String groupName = signalsTableElement.getName();
            this.getGroupSelectionCombo().add(groupName);
            this.getGroupSelectionCombo().setData(groupName, (Object)groupName);
        }
    }

    public void addGroupComboEntry(String groupName) {
        if (groupName == null || this.getGroupSelectionCombo().indexOf(groupName) != -1) {
            return;
        }
        this.getGroupSelectionCombo().add(groupName);
        this.getGroupSelectionCombo().setData(groupName, (Object)groupName);
        this.setGroupSelection(groupName);
    }

    public void removeGroupComboEntry(String groupName) {
        if (groupName == null || "default".equals(groupName)) {
            return;
        }
        if (this.getGroupSelectionCombo().isDisposed() || this.getGroupSelectionCombo().indexOf(groupName) == -1) {
            return;
        }
        this.getGroupSelectionCombo().remove(groupName);
        if (this.getGroupSelectionCombo().getText().equals("")) {
            this.setGroupSelection("default");
        }
    }

    public void renameGroupComboEntry(String oldGroupName, String newGroupName) {
        if (oldGroupName == null || this.getGroupSelectionCombo().indexOf(oldGroupName) == -1) {
            return;
        }
        if (!oldGroupName.equals("default")) {
            this.getGroupSelectionCombo().remove(oldGroupName);
        }
        this.addGroupComboEntry(newGroupName);
    }

    public boolean isAddNewGroupSelected() {
        int selectionIndex = this.getGroupSelectionCombo().getSelectionIndex();
        if (selectionIndex == -1) {
            return false;
        }
        String selectedItem = this.getGroupSelectionCombo().getItem(selectionIndex);
        if (selectedItem == null || selectedItem.isEmpty()) {
            return false;
        }
        Object selectedItemData = this.getGroupSelectionCombo().getData(selectedItem);
        return "Add new group".equals(selectedItemData);
    }

    public WSignalsTableGroup getSelectedGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableElements) {
        WSignalsTableGroup group = null;
        group = "Add new group".equals(selectedGroupName) ? this.createNewGroup(signalsTableElements) : this.getExistingGroupWrapper(selectedGroupName, signalsTableElements);
        if (group == null && "default".equals(selectedGroupName)) {
            group = this.createNewDefaultGroup(signalsTableElements);
        }
        return group;
    }

    private WSignalsTableGroup createNewGroup(TreeSet<WSignalsTableElement> signalsTableElements) {
        String newGroupName = this.newGroupNameTextArea.getNewGroupText().getText();
        if (newGroupName == null || newGroupName.isEmpty()) {
            return null;
        }
        return new WSignalsTableGroup(signalsTableElements.size(), newGroupName, null, null);
    }

    public WSignalsTableGroup getExistingGroupWrapper(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableElements) {
        for (WSignalsTableElement signalsTableElement : signalsTableElements) {
            if (!(signalsTableElement instanceof WSignalsTableGroup) || !selectedGroupName.equals(signalsTableElement.getName())) continue;
            return (WSignalsTableGroup)signalsTableElement;
        }
        return null;
    }

    private WSignalsTableGroup createNewDefaultGroup(TreeSet<WSignalsTableElement> signalsTableElements) {
        for (WSignalsTableElement signalsTableElement : signalsTableElements) {
            signalsTableElement.setId(signalsTableElement.getId() + 1);
        }
        return new WSignalsTableGroup(0, "default", null, null);
    }

    public String getSelectedGroupName() {
        if (this.groupSelectionCombo.isDisposed()) {
            return null;
        }
        int selectionIndex = this.groupSelectionCombo.getSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        String selectedItem = this.groupSelectionCombo.getItem(selectionIndex);
        if (selectedItem == null || selectedItem.isEmpty()) {
            return null;
        }
        Object selectedItemData = this.groupSelectionCombo.getData(selectedItem);
        if (!(selectedItemData instanceof String)) {
            return null;
        }
        String selectedItemDataString = (String)selectedItemData;
        if (selectedItemDataString.isEmpty()) {
            return null;
        }
        return selectedItemDataString;
    }

    public void setGroupSelection(String groupName) {
        if ("default".equals(groupName) && this.getGroupSelectionCombo().indexOf(groupName) == -1) {
            this.getGroupSelectionCombo().add(groupName);
            this.getGroupSelectionCombo().setData(groupName, (Object)groupName);
            this.getGroupSelectionCombo().setText(groupName);
            return;
        }
        this.getGroupSelectionCombo().setText(groupName);
        this.updateOnGroupSelectionChanged();
    }

    public abstract void updateOnGroupSelectionChanged();

    public Text getNewGroupText() {
        return this.newGroupNameTextArea.getNewGroupText();
    }

    public void addValidateNewGroupListener(Button okButton) {
        this.newGroupNameTextArea.getNewGroupText().addModifyListener(e -> this.newGroupNameTextArea.validateNewGroupText(okButton));
    }

    protected void showNewGroupTextArea() {
        this.newGroupNameTextArea.show();
    }

    protected void hideNewGroupTextArea() {
        this.newGroupNameTextArea.hide();
    }

    public Combo getGroupSelectionCombo() {
        return this.groupSelectionCombo;
    }
}

