/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import ro.amiq.dvt.diagrams.wave.WaveViewerInstanceSignalsViewLabelProvider;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalScope;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalVar;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class WaveViewerInstanceSignalsViewCommon
extends AbstractFilteredView {
    public static final List<DVTVCDHierarchicalVar> WAVE_NO_MATCHES_FOUND = new ArrayList<DVTVCDHierarchicalVar>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new DVTVCDHierarchicalVar("No matches found.", null, null, null));
        }
    };
    public static final List<DVTVCDHierarchicalVar> WAVE_NO_SIGNALS = new ArrayList<DVTVCDHierarchicalVar>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new DVTVCDHierarchicalVar("No signals.", null, null, null));
        }
    };
    public static final List<DVTVCDHierarchicalVar> INPUT_WAVE_VIEWER_INSTANCE_SIGNALS = new ArrayList<DVTVCDHierarchicalVar>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new DVTVCDHierarchicalVar("Select an element to see its signals.", null, null, null));
        }
    };
    public static final String ID = "ro.amiq.dvt.ui.views.WaveViewerLeftSignalsInstancesPanelView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.NO_INFORMATION);
    protected DVTVCDHierarchicalScope selectedScope;
    protected TableViewer tableViewer;
    protected WaveViewerInstanceSignalsViewLabelProvider labelProvider;

    @Override
    public Objection getTextFilterObjection() {
        return Objection.WAVEFORM_VIEWER_INSTANCE_SIGNALS_TEXT_FILTER;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        String searchedPort = this.getSearchPort(uIJobTextFilterId);
        StringMatcher portToPromote = searchedPort == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(searchedPort, true, false);
        this.showFilteredSignals(portToPromote);
    }

    protected void showFilteredSignals(StringMatcher portToPromote) {
        if (this.tableViewer == null) {
            return;
        }
        if (this.selectedScope == null) {
            this.cleanView();
            return;
        }
        StringMatcher stringMatcher = this.getStringMatcher("default-filter");
        List<DVTVCDHierarchicalVar> elements = new ArrayList<DVTVCDHierarchicalVar>();
        LinkedHashSet<DVTVCDHierarchicalVar> signals = this.selectedScope.getChildSignals();
        ArrayList<DVTVCDHierarchicalVar> signalsCopy = new ArrayList<DVTVCDHierarchicalVar>(signals);
        Collections.sort(signalsCopy, new WaveSignalViewComparator(portToPromote, true));
        for (DVTVCDHierarchicalVar signal : signalsCopy) {
            if (stringMatcher != null && !ViewsUtils.matchCamelCaseOrRegex(stringMatcher, this.labelProvider.getText(signal))) continue;
            elements.add(signal);
        }
        if (this.isFiltered() && elements.isEmpty()) {
            elements = WAVE_NO_MATCHES_FOUND;
        } else if (elements.isEmpty()) {
            elements = WAVE_NO_SIGNALS;
        }
        this.tableViewer.setInput(elements);
        this.tableViewer.setSelection(null);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public abstract void cleanView();

    public WaveViewerInstanceSignalsViewLabelProvider testGetInstanceSignalsViewLabelProvider() {
        if (TestHelper.isTestMode()) {
            return this.labelProvider;
        }
        return null;
    }

    static class WaveSignalViewComparator
    implements Comparator<DVTVCDHierarchicalVar> {
        private StringMatcher portToPromote;
        private boolean alphabeticalSort;

        public WaveSignalViewComparator(StringMatcher portToPromote, boolean alphabeticalSort) {
            this.portToPromote = portToPromote;
            this.alphabeticalSort = alphabeticalSort;
        }

        @Override
        public int compare(DVTVCDHierarchicalVar p1, DVTVCDHierarchicalVar p2) {
            if (p1 == null) {
                return -1;
            }
            String p1Name = p1.getName();
            if (p1Name == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            String p2Name = p2.getName();
            if (p2Name == null) {
                return 1;
            }
            boolean promoteP1 = false;
            boolean promoteP2 = false;
            if (this.portToPromote != null) {
                promoteP1 = ViewsUtils.matchCamelCaseOrRegex(this.portToPromote, p1Name);
                promoteP2 = ViewsUtils.matchCamelCaseOrRegex(this.portToPromote, p2Name);
            }
            boolean firstIsPort = p1 instanceof IRfPortElement;
            boolean secondIsPort = p2 instanceof IRfPortElement;
            if (firstIsPort && secondIsPort || !firstIsPort && !secondIsPort) {
                if (promoteP1 && promoteP2 || !promoteP1 && !promoteP2) {
                    return this.alphabeticalSort ? p1Name.compareToIgnoreCase(p2Name) : 0;
                }
                if (promoteP1) {
                    return -1;
                }
                if (promoteP2) {
                    return 1;
                }
                return this.alphabeticalSort ? p1Name.compareToIgnoreCase(p2Name) : 0;
            }
            return firstIsPort ? -1 : 1;
        }
    }
}

