/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.diagrams.wave.WaveViewerInstanceSignalsView;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalVar;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class WaveViewerInstanceSignalsViewLabelProvider
extends ColumnLabelProvider {
    WaveViewerInstanceSignalsView view;
    private StringMatcher boldMatcher;

    public WaveViewerInstanceSignalsViewLabelProvider(WaveViewerInstanceSignalsView view) {
        this.view = view;
    }

    public Image getImage(Object wrapper) {
        if (!(wrapper instanceof DVTVCDHierarchicalVar)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        DVTVCDHierarchicalVar element = (DVTVCDHierarchicalVar)wrapper;
        if (element.getVcdId() == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        return DVTVCDUtils.getSignalImage(element.getType(), element.getPath());
    }

    public String getText(Object wrapper) {
        if (!(wrapper instanceof DVTVCDHierarchicalVar)) {
            return "";
        }
        DVTVCDHierarchicalVar element = (DVTVCDHierarchicalVar)wrapper;
        return element.getName();
    }

    public String getToolTipText(Object wrapper) {
        if (!(wrapper instanceof DVTVCDHierarchicalVar)) {
            return "";
        }
        DVTVCDHierarchicalVar element = (DVTVCDHierarchicalVar)wrapper;
        if (element.getPath() == null) {
            return "";
        }
        return element.getPath().toString("/");
    }

    public Font getFont(Object element) {
        if (this.boldMatcher == null || !ViewsUtils.matchCamelCaseOrRegex(this.boldMatcher, this.getText(element))) {
            return null;
        }
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        Display current = Display.getCurrent();
        if (fontRegistry != null && current != null) {
            return fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
        }
        return null;
    }

    public void setBoldMatcher(StringMatcher boldMatcher) {
        this.boldMatcher = boldMatcher;
    }
}

