/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import com.google.re2j.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;

public class WaveViewerJumpToTimeDialog
extends DVTPopupDialog {
    private WCanvas canvas;
    private static final Pattern NUMBER_PATTERN = Pattern.compile((String)"\\d*");
    private static int DIALOG_AREA_WIDTH = 300;
    private static int DIALOG_AREA_HEIGHT = 50;

    public WaveViewerJumpToTimeDialog(Shell parent, WCanvas canvas) {
        super(parent, 0x1000050, true, false, true, false, false, "", "");
        this.canvas = canvas;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Jump To Time");
    }

    @Override
    protected String getId() {
        return "Jump To Time";
    }

    private void jumpTo(Text timeInput) {
        String timeString = timeInput.getText();
        try {
            long inputTimeValue = Long.parseLong(timeString);
            WViewport viewPort = this.canvas.getViewport();
            if (viewPort == null) {
                return;
            }
            long timeUnitsOnScreen = viewPort.getHighestVisibleTime() - viewPort.getLowestVisibleTime();
            DVTVCDParser provider = this.canvas.getProvider();
            if (provider == null) {
                return;
            }
            long lastTimeFromVcd = provider.getLastTimeFromVcd();
            if (inputTimeValue + timeUnitsOnScreen > lastTimeFromVcd) {
                inputTimeValue = Math.max(0L, lastTimeFromVcd - timeUnitsOnScreen);
            }
            viewPort.zoomToFitTimes(inputTimeValue, Math.min(inputTimeValue + timeUnitsOnScreen, lastTimeFromVcd + (long)viewPort.getLastTimeOffset()));
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).applyTo(composite);
        GridDataFactory.fillDefaults().hint(DIALOG_AREA_WIDTH, DIALOG_AREA_HEIGHT).applyTo((Control)composite);
        final Text timeInput = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)timeInput);
        timeInput.addVerifyListener(e -> {
            if (!NUMBER_PATTERN.matcher((CharSequence)e.text).matches()) {
                e.doit = false;
            }
        });
        timeInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveViewerJumpToTimeDialog.this.jumpTo(timeInput);
                }
            }
        });
        Button jumpToButton = new Button(composite, 8);
        jumpToButton.setText("Jump");
        GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)jumpToButton);
        jumpToButton.setEnabled(false);
        jumpToButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                WaveViewerJumpToTimeDialog.this.jumpTo(timeInput);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        timeInput.addModifyListener(e -> {
            if (timeInput.getText().isEmpty()) {
                jumpToButton.setEnabled(false);
            } else {
                jumpToButton.setEnabled(true);
            }
        });
        composite.pack();
        return composite;
    }
}

