/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalsPanelModel;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDHierarchicalScope;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveHierarchicalScopeInfo;

public class WaveViewerLeftSignalsPanelModel
extends WaveViewerSignalsPanelModel {
    private static final Comparator<DVTVCDHierarchicalScope> CHILD_SCOPES_COMPARATOR = (scope1, scope2) -> {
        String scopeName2;
        ElementPath path1 = scope1.getPath();
        ElementPath path2 = scope2.getPath();
        String scopeName1 = path1.getSegmentName();
        int result = scopeName1.compareTo(scopeName2 = path2.getSegmentName());
        if (result != 0) {
            return result;
        }
        int[] scopeIndices1 = path1.getSegmentIndices();
        int[] scopeIndices2 = path2.getSegmentIndices();
        return Arrays.compare(scopeIndices1, scopeIndices2);
    };

    public WaveViewerLeftSignalsPanelModel(WaveDiagramEditor diagramEditor) {
        super(diagramEditor);
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (treePath == null) {
            return Collections.emptyList();
        }
        if (this.editor == null) {
            return Collections.emptyList();
        }
        TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> orderedScopeInfos = DVTVCDUtils.getOrderedScopeInfos(this.editor);
        if (orderedScopeInfos.isEmpty()) {
            return Collections.emptyList();
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return this.getTopTreePath(treePath, orderedScopeInfos);
        }
        return this.getChildScopesTreePaths(treePath, orderedScopeInfos, childStartIndex, childEndIndex, monitor);
    }

    private List<TreePath> getTopTreePath(TreePath treePath, TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> orderedScopeInfos) {
        Iterator<ElementPath> scopeInfosIterator = orderedScopeInfos.keySet().iterator();
        if (!scopeInfosIterator.hasNext()) {
            return Collections.emptyList();
        }
        DVTVCDParser parser = this.editor.getParser();
        if (parser == null) {
            return Collections.emptyList();
        }
        DVTVCDModel model = parser.getVcdModel();
        if (model == null) {
            return Collections.emptyList();
        }
        ElementPath topScopePath = scopeInfosIterator.next();
        if (topScopePath == null || topScopePath.isEmpty()) {
            return Collections.emptyList();
        }
        String topScopeName = topScopePath.toString();
        DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType topScopeType = model.getScopeType(topScopePath);
        TreePath topTreePath = TreePath.child(treePath, topScopeName, 0);
        topTreePath.setElement(new DVTVCDHierarchicalScope(topScopeName, topScopePath, topScopeType));
        return Arrays.asList(topTreePath);
    }

    private List<TreePath> getChildScopesTreePaths(TreePath treePath, TreeMap<ElementPath, DVTWaveHierarchicalScopeInfo> orderedScopeInfos, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        Object element = treePath.getElement();
        if (!(element instanceof DVTVCDHierarchicalScope)) {
            return Collections.emptyList();
        }
        ElementPath currentScopePath = ((DVTVCDHierarchicalScope)element).getPath();
        if (currentScopePath == null || currentScopePath.isEmpty()) {
            return Collections.emptyList();
        }
        DVTVCDParser parser = this.editor.getParser();
        if (parser == null) {
            return Collections.emptyList();
        }
        DVTVCDModel model = parser.getVcdModel();
        if (model == null) {
            return Collections.emptyList();
        }
        NavigableMap<ElementPath, DVTWaveHierarchicalScopeInfo> remainingScopes = orderedScopeInfos.tailMap(currentScopePath, false);
        if (remainingScopes == null) {
            return Collections.emptyList();
        }
        int childIdx = 0;
        TreeSet<DVTVCDHierarchicalScope> childScopes = new TreeSet<DVTVCDHierarchicalScope>(CHILD_SCOPES_COMPARATOR);
        for (Map.Entry entry : remainingScopes.entrySet()) {
            String scopeName;
            ElementPath parentScopePath;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (childIdx < childStartIndex) {
                ++childIdx;
                continue;
            }
            if (childIdx >= childEndIndex) break;
            ElementPath scopePath = (ElementPath)entry.getKey();
            if (scopePath == null || (parentScopePath = ELUtils.upperPathOf(scopePath)) == null || parentScopePath.isEmpty() || !currentScopePath.equals(parentScopePath) || (scopeName = scopePath.lastSegment()).isEmpty()) continue;
            DVTWaveHierarchicalScopeInfo.DVTWaveHierarchicalScopeType scopeType = model.getScopeType(scopePath);
            childScopes.add(new DVTVCDHierarchicalScope(scopeName, scopePath, scopeType));
            ++childIdx;
        }
        childIdx = 0;
        ArrayList<TreePath> childScopesTreePaths = new ArrayList<TreePath>();
        for (DVTVCDHierarchicalScope childScope : childScopes) {
            TreePath childScopeTreePath = TreePath.child(treePath, childScope.getName(), childIdx);
            childScopeTreePath.setElement(childScope);
            ++childIdx;
            childScopesTreePaths.add(childScopeTreePath);
        }
        return childScopesTreePaths;
    }
}

