/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.diagrams.wave.IDVTWaveView;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerInstanceSignalsView;
import ro.amiq.dvt.diagrams.wave.WaveViewerLeftSignalsPanelLabelProvider;
import ro.amiq.dvt.diagrams.wave.WaveViewerLeftSignalsPanelModel;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalsPanelView;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.CustomExpandStateInfo;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyViewSliderPosition;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class WaveViewerLeftSignalsPanelView
extends WaveViewerSignalsPanelView
implements IDVTWaveView {
    public static final String TEXT_FILTER_SWTBOT_ID = String.valueOf(WaveViewerLeftSignalsPanelView.class.getCanonicalName()) + ".textFilterSWTBotId";
    private Composite signalsComposite;
    private WaveViewerInstanceSignalsView signalsView;
    private WaveViewerLeftSignalsPanelModel model;
    private WaveViewerLeftSignalsPanelLabelProvider labelProvider = new WaveViewerLeftSignalsPanelLabelProvider();

    public WaveViewerLeftSignalsPanelView(WaveDiagramEditor editor) {
        super(editor);
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        this.sashChildTree = new Composite(parent, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashChildTree);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(this.sashChildTree);
        Composite textFilterBox = new Composite(this.sashChildTree, 4);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).margins(0, 0).applyTo(textFilterBox);
        textFilterBox.setLayoutData((Object)new GridData(768));
        Text filterText = this.createNewTextFilter(textFilterBox);
        if (filterText != null) {
            filterText.setMessage("Filter by: hierarchical name .signal");
            Utils.setWidgetSWTBotId((Widget)filterText, TEXT_FILTER_SWTBOT_ID);
        }
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        ToolBar tb = new ToolBar(textFilterBox, 0x800000);
        ToolItem expand = new ToolItem(tb, 8);
        expand.setImage(DVTImages.imageCache.getImage(DVTImages.EXPAND_ALL_ACTION));
        expand.setToolTipText("Expand All");
        expand.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.diagramEditor.getCanvas())) {
                return;
            }
            this.getLazyTree().doAction(LazyTreeAction.EXPAND_ALL, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_INSTANCE_EXPAND_ALL));
        });
        ToolItem collapse = new ToolItem(tb, 8);
        collapse.setImage(DVTImages.imageCache.getImage(DVTImages.COLLAPSE_ALL_ACTION));
        collapse.setToolTipText("Collapse All");
        collapse.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.diagramEditor.getCanvas())) {
                return;
            }
            this.getLazyTree().doAction(LazyTreeAction.COLLAPSE_ALL, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_INSTANCE_COLLAPSE_ALL));
        });
        LazyTree lazyTree = new LazyTree(this, LazyViewSliderPosition.LEFT);
        lazyTree.setLabelProvider((ILabelProvider)this.labelProvider, false);
        lazyTree.setSearchBar(filter);
        this.setLazyTree(lazyTree);
        lazyTree.install(this.sashChildTree);
        Tree tree = lazyTree.getTree();
        tree.setHeaderVisible(false);
        tree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.signalsComposite = new Composite(parent, 0);
        this.signalsComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.signalsComposite.setFont(parent.getFont());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.signalsComposite);
        this.signalsView = new WaveViewerInstanceSignalsView();
        this.signalsView.initAndShow(this.signalsComposite);
        lazyTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                WaveViewerLeftSignalsPanelView.this.updateSignalsView(WaveViewerLeftSignalsPanelView.this.getTreeSearchPort());
            }
        });
        Label separator = new Label(this.signalsComposite, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        this.signalsComposite.layout();
        this.updateSignalsView(this.getTreeSearchPort());
    }

    public void updateSignalsView(String searchedPort) {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null || this.signalsView == null) {
            return;
        }
        TreePath selection = lazyTree.getSelection();
        if (selection == null) {
            this.signalsView.clean();
            return;
        }
        StringMatcher portToPromote = searchedPort == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(searchedPort, true, false);
        this.signalsView.updateSignalsUsingTreePath(selection, this.diagramEditor, portToPromote);
        this.signalsView.setBoldMatcher(portToPromote);
        ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_INSTANCE_SIGNALS);
    }

    @Override
    public String getTreeSearchPort() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public void updateUsingTreePath(TreePath selectedNode, TreePath firstNode) {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (this.model == null) {
            this.model = new WaveViewerLeftSignalsPanelModel(this.diagramEditor);
        }
        if (firstNode == null || TreePath.isRoot(firstNode) && selectedNode == null) {
            LazyTreeUpdateViewActionArguments actionArg = new LazyTreeUpdateViewActionArguments(this, this.model, ExpandCollapseState.COLLAPSED, new CustomExpandStateInfo(TreePath.TOP_DUMMY_TREE_PATH, 1), false, false, false, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE);
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, actionArg);
        } else {
            lazyTree.doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(selectedNode, firstNode, false, true, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
        }
    }

    @Override
    public void createToolBar() {
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.model;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        if (this.isFiltered()) {
            this.updateSignalsView(this.getTreeSearchPort());
        }
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(false, false, this.model, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
    }

    @Override
    public void selectionChanged() {
        this.updateSignalsView(this.getTreeSearchPort());
    }

    public WaveViewerInstanceSignalsView getSignalsView() {
        return this.signalsView;
    }

    @Override
    public String getMessageText() {
        if (this.model != null && this.isFiltered()) {
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_INSTANCES.getMessage();
    }

    @Override
    public WaveDiagramEditor getVcdDiagramEditor() {
        return this.diagramEditor;
    }

    public void setModel(WaveViewerLeftSignalsPanelModel model) {
        this.model = model;
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        if (manager == null) {
            return;
        }
        manager.removeAll();
    }

    @Override
    public void clean() {
        super.clean();
        this.signalsView = null;
        if (this.model != null) {
            this.model.deepClean();
        }
        this.labelProvider = null;
    }
}

