/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.IDWaveSignalsGroup;
import ro.amiq.dvt.diagrams.wave.WSignalsTableElementsFactory;
import ro.amiq.dvt.diagrams.wave.WaveViewerGroupSelectionArea;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class WaveViewerMoveSelectedSignalsToGroupDialog
extends DVTPopupDialog
implements IDWaveSignalsGroup {
    private static final int DIALOG_AREA_WIDTH = 475;
    private static final int DIALOG_AREA_HEIGHT = 100;
    public static final String ID = "Move Selected Signals to Group";
    private List<WSignalsTableElement> elementsToMove = new ArrayList<WSignalsTableElement>();
    private WCanvas canvas;
    private Composite contentsComposite;
    private WaveViewerGroupSelectionArea groupSelectionArea;
    private Button okButton;
    private KeyListener enterKeyListener;

    public WaveViewerMoveSelectedSignalsToGroupDialog(WCanvas canvas, List<WSignalsTableElement> elementsToAdd, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(canvas.getShell(), shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        for (WSignalsTableElement element : elementsToAdd) {
            WSignalsTableElement copyOfElement = WSignalsTableElementsFactory.INSTANCE.createCopyOf(element);
            if (copyOfElement == null) continue;
            this.elementsToMove.add(copyOfElement);
        }
        this.canvas = canvas;
        this.enterKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveViewerMoveSelectedSignalsToGroupDialog.this.okButtonAction();
                }
            }
        };
    }

    @Override
    protected String getId() {
        return ID;
    }

    protected Control createDialogArea(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(475, 100).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(this.contentsComposite);
        this.groupSelectionArea = new WaveViewerGroupSelectionArea(this.canvas, this.contentsComposite){

            @Override
            public void updateOnGroupSelectionChanged() {
                Text newGroupText = this.getNewGroupText();
                GridData addNewGroupTextLayoutData = (GridData)newGroupText.getLayoutData();
                if (this.isAddNewGroupSelected()) {
                    addNewGroupTextLayoutData.exclude = false;
                    newGroupText.setVisible(true);
                } else {
                    addNewGroupTextLayoutData.exclude = true;
                    newGroupText.setVisible(false);
                }
                Display.getDefault().asyncExec(() -> {
                    Shell shell = WaveViewerMoveSelectedSignalsToGroupDialog.this.getShell();
                    shell.layout(true, true);
                    shell.pack();
                });
                newGroupText.setText("");
                newGroupText.requestLayout();
            }
        };
        this.createButtonsArea();
        this.groupSelectionArea.addValidateNewGroupListener(this.okButton);
        this.groupSelectionArea.setGroupSelection("default");
        Dialog.applyDialogFont((Control)this.contentsComposite);
        this.getShell().setText(ID);
        this.groupSelectionArea.getGroupSelectionCombo().addKeyListener(this.enterKeyListener);
        return this.contentsComposite;
    }

    protected void createButtonsArea() {
        Composite buttonsComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, true).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonsComposite);
        Button cancelbutton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)cancelbutton);
        cancelbutton.setText("Cancel");
        cancelbutton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerMoveSelectedSignalsToGroupDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.okButton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.okButton);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerMoveSelectedSignalsToGroupDialog.this.okButtonAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void okButtonAction() {
        this.moveElementsToDifferentGroup(this.elementsToMove);
        DVTVCDUtils.refreshWaveViewer(this.canvas.getSignalsTableView(), this.canvas);
        this.close();
    }

    @Override
    public String getNewGroupName() {
        return null;
    }

    @Override
    public String getSelectedGroupName() {
        return this.groupSelectionArea.getSelectedGroupName();
    }

    @Override
    public WCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public WSignalsTableGroup getGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableNodes) {
        return this.groupSelectionArea.getSelectedGroup(selectedGroupName, signalsTableNodes);
    }
}

