/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class WaveViewerNewGroupNameTextArea {
    private static final String NEW_GROUP_NAME_TEXT_MESSAGE = "Type in a new group name";
    private static final String GROUP_NAME_ALREADY_EXISTS_ERROR = "Group name already exists!";
    private Text newGroupText;
    private Label groupNameErrorLabel;
    private WCanvas canvas;
    private Set<String> existingGroupNames;

    public WaveViewerNewGroupNameTextArea(WCanvas canvas, Composite parent) {
        this.canvas = canvas;
        this.existingGroupNames = this.getExistingGroupNames();
        this.createTextAndErrorLabel(parent);
    }

    private void createTextAndErrorLabel(Composite parent) {
        this.newGroupText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newGroupText);
        this.newGroupText.setMessage(NEW_GROUP_NAME_TEXT_MESSAGE);
        this.groupNameErrorLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.groupNameErrorLabel);
        this.groupNameErrorLabel.setVisible(false);
    }

    private Set<String> getExistingGroupNames() {
        HashSet<String> existingGroupNames = new HashSet<String>();
        WViewport viewport = this.canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableElements = viewport.getSignalsTableElements();
        for (WSignalsTableElement signalsTableElement : signalsTableElements) {
            if (!(signalsTableElement instanceof WSignalsTableGroup)) continue;
            existingGroupNames.add(signalsTableElement.getName());
        }
        return existingGroupNames;
    }

    public void validateNewGroupText(Button okButton) {
        String newGroupName = this.newGroupText.getText().trim();
        GridData newGroupTextLayoutData = (GridData)this.newGroupText.getLayoutData();
        if (!newGroupTextLayoutData.exclude && (newGroupName == null || newGroupName.isEmpty())) {
            this.showHideErrorLabel(true, "Group name can not be empty!", okButton, false);
        } else if (!newGroupTextLayoutData.exclude && this.existingGroupNames.contains(newGroupName)) {
            this.showHideErrorLabel(true, GROUP_NAME_ALREADY_EXISTS_ERROR, okButton, false);
        } else {
            this.showHideErrorLabel(false, "", okButton, true);
        }
        this.groupNameErrorLabel.requestLayout();
    }

    private void showHideErrorLabel(boolean isShow, String labelText, Button okButton, boolean isOkEnabled) {
        GridData errorLabelLayoutData = (GridData)this.groupNameErrorLabel.getLayoutData();
        this.groupNameErrorLabel.setText(labelText);
        errorLabelLayoutData.exclude = !isShow;
        this.groupNameErrorLabel.setVisible(isShow);
        okButton.setEnabled(isOkEnabled);
    }

    public Text getNewGroupText() {
        return this.newGroupText;
    }

    public Label getGroupNameErrorLabel() {
        return this.groupNameErrorLabel;
    }

    public void show() {
        GridData layoutData = (GridData)this.newGroupText.getLayoutData();
        layoutData.exclude = false;
        this.newGroupText.setVisible(true);
        layoutData = (GridData)this.groupNameErrorLabel.getLayoutData();
        layoutData.exclude = false;
        this.groupNameErrorLabel.setVisible(true);
    }

    public void hide() {
        GridData layoutData = (GridData)this.newGroupText.getLayoutData();
        layoutData.exclude = true;
        this.newGroupText.setVisible(false);
        layoutData = (GridData)this.groupNameErrorLabel.getLayoutData();
        layoutData.exclude = true;
        this.groupNameErrorLabel.setVisible(false);
    }
}

