/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.IDWaveSignalsGroup;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerNewGroupNameTextArea;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionActionArguments;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class WaveViewerRenameGroupDialog
extends DVTPopupDialog
implements IDWaveSignalsGroup {
    private static final int DIALOG_AREA_WIDTH = 475;
    private static final String ID = "Rename Group";
    private WCanvas canvas;
    private Composite contentsComposite;
    private Button okButton;
    private WSignalsTableGroup selectedGroup;
    private WaveViewerNewGroupNameTextArea newGroupNameTextArea;
    private KeyListener enterKeyListener;

    public WaveViewerRenameGroupDialog(WCanvas canvas, WSignalsTableGroup selectedGroup, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(canvas.getShell(), shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        this.canvas = canvas;
        this.selectedGroup = selectedGroup;
        this.enterKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveViewerRenameGroupDialog.this.okButtonAction();
                }
            }
        };
    }

    @Override
    protected String getId() {
        return ID;
    }

    protected Control createDialogArea(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(475, -1).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 20).applyTo(this.contentsComposite);
        this.createRenameGroupArea();
        this.createButtonsArea();
        this.newGroupNameTextArea.getNewGroupText().addModifyListener(e -> this.newGroupNameTextArea.validateNewGroupText(this.okButton));
        Dialog.applyDialogFont((Control)this.contentsComposite);
        this.getShell().setText(ID);
        Text newGroupText = this.newGroupNameTextArea.getNewGroupText();
        newGroupText.setText(this.selectedGroup.getName());
        newGroupText.requestLayout();
        newGroupText.addKeyListener(this.enterKeyListener);
        return this.contentsComposite;
    }

    protected void createRenameGroupArea() {
        Group renameGroupArea = new Group(this.contentsComposite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)renameGroupArea);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(1).applyTo((Composite)renameGroupArea);
        renameGroupArea.setText("Rename Group \"" + this.selectedGroup.getName() + "\"");
        this.newGroupNameTextArea = new WaveViewerNewGroupNameTextArea(this.canvas, (Composite)renameGroupArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newGroupNameTextArea.getNewGroupText());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newGroupNameTextArea.getGroupNameErrorLabel());
    }

    protected void createButtonsArea() {
        Composite buttonsComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, true).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonsComposite);
        Button cancelbutton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)cancelbutton);
        cancelbutton.setText("Cancel");
        cancelbutton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerRenameGroupDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.okButton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.okButton);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerRenameGroupDialog.this.okButtonAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void okButtonAction() {
        String oldGroupName = this.selectedGroup.getName();
        TreeSet<WSignalsTableElement> copyChildSignals = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        copyChildSignals.addAll(this.selectedGroup.getChildElements());
        String newGroupName = this.renameGroupAction(copyChildSignals, this.selectedGroup);
        WaveViewerSignalTableView signalsView = this.canvas.getSignalsTableView();
        WaveViewerDesignHierarchyView dhView = signalsView.getDHView();
        if (dhView != null) {
            dhView.updateOnRename(oldGroupName, newGroupName);
        }
        TreePath groupTreePath = this.selectedGroup.getTreePath();
        MultipleSelectionTreeIterator treeIterator = (MultipleSelectionTreeIterator)signalsView.getLazyTree().getTreeIterator();
        ArrayList<TreePath> selection = new ArrayList<TreePath>();
        selection.add(groupTreePath);
        treeIterator.setSelections(selection);
        treeIterator.setLastSelection(groupTreePath);
        signalsView.getLazyTree().doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(selection, null));
        DVTVCDUtils.refreshWaveViewer(this.canvas.getSignalsTableView(), this.canvas);
        this.close();
    }

    @Override
    public String getNewGroupName() {
        return this.newGroupNameTextArea.getNewGroupText().getText();
    }

    @Override
    public WCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public String getSelectedGroupName() {
        return this.selectedGroup.getName();
    }

    @Override
    public WSignalsTableGroup getGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableNodes) {
        return null;
    }
}

