/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalsPanelModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;

public class WaveViewerRightSignalsPanelModel
extends WaveViewerSignalsPanelModel {
    private TreeSet<WSignalsTableElement> signalsTableElements;
    private static final Comparator<TreePath> CHILDREN_FLAT_COMPARATOR = (o1, o2) -> {
        WSignalsTableElement o1Element = (WSignalsTableElement)o1.getElement();
        WSignalsTableElement o2Element = (WSignalsTableElement)o2.getElement();
        return o1Element.getId() - o2Element.getId();
    };

    public WaveViewerRightSignalsPanelModel(WaveDiagramEditor diagramEditor, TreeSet<WSignalsTableElement> signalsTableElements) {
        super(diagramEditor);
        this.signalsTableElements = signalsTableElements;
    }

    public void setSignalsTableElements(TreeSet<WSignalsTableElement> signalsTableElements) {
        this.signalsTableElements = signalsTableElements;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (treePath == null) {
            return Collections.emptyList();
        }
        if (this.editor == null) {
            return Collections.emptyList();
        }
        if (this.signalsTableElements == null || this.signalsTableElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (treePath != TreePath.TOP_DUMMY_TREE_PATH) {
            return Collections.emptyList();
        }
        return this.getChildrenFlat(treePath, childStartIndex, childEndIndex, monitor);
    }

    private List<TreePath> getChildrenFlat(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        ArrayList<TreePath> children = new ArrayList<TreePath>();
        HashSet<Integer> childrenSignals = new HashSet<Integer>();
        int i = 0;
        int endIndex = Math.min(childEndIndex, this.signalsTableElements.size());
        for (WSignalsTableElement tableSignalWrapper : this.signalsTableElements) {
            if (i < childStartIndex) {
                ++i;
                continue;
            }
            if (i >= endIndex) break;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            TreePath child = TreePath.child(treePath, tableSignalWrapper.getName(), tableSignalWrapper.getId(), CHILDREN_FLAT_COMPARATOR);
            if (!childrenSignals.add(child.hashCode())) {
                child.append("@(" + i + ")@");
            }
            child.setElement(tableSignalWrapper);
            tableSignalWrapper.setTreePath(child);
            children.add(child);
            ++i;
        }
        return children;
    }

    public List<TreePath> getSignalsTreePathsInInterval(int lowIndex, int highIndex) {
        ArrayList<TreePath> signalTreePaths = new ArrayList<TreePath>();
        int i = 0;
        for (WSignalsTableElement tableSignalWrapper : this.signalsTableElements) {
            if (i < lowIndex) {
                ++i;
                continue;
            }
            if (i > highIndex) break;
            signalTreePaths.add(tableSignalWrapper.getTreePath());
            ++i;
        }
        return signalTreePaths;
    }

    public List<TreePath> getSignalsTreePathsInBetween(WSignalsTableElement signal1, WSignalsTableElement signal2) {
        int signalIndex2;
        int signalIndex1 = signal1.getId();
        int lowIndex = signalIndex1 < (signalIndex2 = signal2.getId()) ? signalIndex1 : signalIndex2;
        int highIndex = signalIndex1 > signalIndex2 ? signalIndex1 : signalIndex2;
        return this.getSignalsTreePathsInInterval(lowIndex, highIndex);
    }

    public List<TreePath> getAllSignalsTreePaths() {
        return this.getSignalsTreePathsInInterval(0, Integer.MAX_VALUE);
    }
}

