/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;

public class WaveViewerSignalTableLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    protected final Map<Integer, Integer> fColumnIndexesSizes = new HashMap<Integer, Integer>();

    public void updateColumnSize(Integer columnIndex, int size) {
        this.fColumnIndexesSizes.put(columnIndex, size);
    }

    public Image getColumnImage(Object element, int colNum) {
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (!(element instanceof WSignalsTableElement) || colNum != 0) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        WSignalsTableElement signalsTableElement = (WSignalsTableElement)element;
        if (signalsTableElement instanceof WSignalsTableGroup) {
            return DVTImages.imageCache.getImage(DVTImages.WAVE_SIGNAL_GROUPS);
        }
        if (signalsTableElement instanceof WSignalsTableSeparator) {
            return "__dvt_empty_separator".equals(signalsTableElement.getName()) ? DVTImages.imageCache.getImage(DVTImages.NONE) : DVTImages.imageCache.getImage(DVTImages.WAVE_SEPARATOR);
        }
        if (!(signalsTableElement instanceof WSignalsTableSignal)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        WSignalsTableSignal signal = (WSignalsTableSignal)signalsTableElement;
        return DVTVCDUtils.getSignalImage(signal.getType(), signal.getVcdPath());
    }

    public String getColumnText(Object element, int colNum) {
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (!(element instanceof WSignalsTableElement)) {
            return "";
        }
        WSignalsTableElement signalsTableElement = (WSignalsTableElement)element;
        if (colNum == 0) {
            String elementName = signalsTableElement.getName();
            if ("__dvt_empty_separator".equals(elementName)) {
                return "";
            }
            return elementName;
        }
        if (colNum == 1) {
            if (!(signalsTableElement instanceof WSignalsTableSignal)) {
                return "";
            }
            String signalValueAtCursor = ((WSignalsTableSignal)signalsTableElement).getValueAtCursor();
            if (signalValueAtCursor == null || signalValueAtCursor.isEmpty()) {
                return "";
            }
            return signalValueAtCursor;
        }
        return "";
    }

    public String getToolTipText(Object element) {
        return DVTVCDUtils.getSignalPath(element, false);
    }
}

