/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Canvas;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WaveViewerSignalTableModel
implements IModel {
    private WaveDiagramEditor editor;

    public WaveViewerSignalTableModel(WaveDiagramEditor diagramEditor) {
        this.editor = diagramEditor;
    }

    @Override
    public void clearModelCaches() {
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (treePath == null) {
            return Collections.emptyList();
        }
        if (this.editor == null) {
            return Collections.emptyList();
        }
        Canvas canvas = this.editor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return Collections.emptyList();
        }
        TreeSet<WSignalsTableElement> signalsTableElements = ((WCanvas)canvas).getViewport().getSignalsTableElements();
        if (signalsTableElements == null || signalsTableElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return this.getTopDummyTreePathChildElements(signalsTableElements, treePath, childStartIndex, childEndIndex);
        }
        Object treePathElement = treePath.getElement();
        if (treePathElement instanceof WSignalsTableGroup) {
            return this.getGroupChildElements((WSignalsTableGroup)treePathElement, treePath, childStartIndex, childEndIndex, monitor);
        }
        if (treePathElement instanceof WSignalsTableStructSignal) {
            return this.getStructChildElements((WSignalsTableStructSignal)treePathElement, treePath, childStartIndex, childEndIndex, monitor);
        }
        if (treePathElement instanceof WSignalsTableMultiBitSignal) {
            return this.getMultiBitSignalChildElements((WSignalsTableMultiBitSignal)treePathElement, treePath, childStartIndex, childEndIndex, monitor);
        }
        return Collections.emptyList();
    }

    private List<TreePath> getStructChildElements(WSignalsTableStructSignal struct, TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        ArrayList<TreePath> childSignalsTreePaths = new ArrayList<TreePath>();
        int i = 0;
        TreeSet<WSignalsTableElement> childSignals = struct.getChildElements();
        for (WSignalsTableElement childSignal : childSignals) {
            if (monitor.isCanceled()) {
                return childSignalsTreePaths;
            }
            if (i < childStartIndex) continue;
            if (i >= childEndIndex) break;
            TreePath childSignalTreePath = TreePath.child(treePath, childSignal.getName(), i, DVTVCDUtils.CHILDREN_COMPARATOR);
            childSignalTreePath.setElement(childSignal);
            childSignal.setTreePath(childSignalTreePath);
            childSignalsTreePaths.add(childSignalTreePath);
            ++i;
        }
        return childSignalsTreePaths;
    }

    private List<TreePath> getTopDummyTreePathChildElements(TreeSet<WSignalsTableElement> signalsTableElements, TreePath treePath, int childStartIndex, int childEndIndex) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        int i = 0;
        for (WSignalsTableElement childWrapper : signalsTableElements) {
            if (i < childStartIndex) continue;
            if (i >= childEndIndex) break;
            String text = childWrapper.getName();
            TreePath child = TreePath.child(treePath, text, childWrapper.getId(), DVTVCDUtils.CHILDREN_COMPARATOR);
            child.setElement(childWrapper);
            childWrapper.setTreePath(child);
            if (result.contains(child)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    private List<TreePath> getGroupChildElements(WSignalsTableGroup group, TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        ArrayList<TreePath> groupChildElements = new ArrayList<TreePath>();
        TreeSet<WSignalsTableElement> childElements = group.getChildElements();
        if (childElements == null) {
            return groupChildElements;
        }
        int i = 0;
        for (WSignalsTableElement childElement : childElements) {
            if (i < childStartIndex) continue;
            if (i >= childEndIndex) break;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            String text = childElement.getName();
            TreePath childTreePath = TreePath.child(treePath, text, childElement.getId(), DVTVCDUtils.CHILDREN_COMPARATOR);
            childTreePath.setElement(childElement);
            childElement.setTreePath(childTreePath);
            if (groupChildElements.contains(childTreePath)) {
                childTreePath.append("@(" + i + ")@");
            }
            groupChildElements.add(childTreePath);
            ++i;
        }
        return groupChildElements;
    }

    private List<TreePath> getMultiBitSignalChildElements(WSignalsTableMultiBitSignal multiBitSignal, TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        ArrayList<TreePath> signalBits = new ArrayList<TreePath>();
        int i = 0;
        TreeSet<WSignalsTableElement> allSignalBits = multiBitSignal.getChildElements();
        for (WSignalsTableElement bit : allSignalBits) {
            if (monitor.isCanceled()) {
                return signalBits;
            }
            if (i < childStartIndex) continue;
            if (i >= childEndIndex) break;
            TreePath bitTreePath = TreePath.child(treePath, bit.getName(), i, DVTVCDUtils.CHILDREN_COMPARATOR);
            bitTreePath.setElement(bit);
            bit.setTreePath(bitTreePath);
            signalBits.add(bitTreePath);
            ++i;
        }
        return signalBits;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return treePath;
        }
        currentPath = treePath;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl11
        return currentPath;
lbl-1000:
        // 1 sources

        {
            if (monitor.isCanceled()) {
                return currentPath;
            }
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl11:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl12:
        // 1 sources

        return currentPath;
    }
}

