/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.DVTOpenMode;
import ro.amiq.dvt.diagrams.wave.JumpToEdgeAction;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerAddNewGroupAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerAddNewGroupDialog;
import ro.amiq.dvt.diagrams.wave.WaveViewerAddOpenDeclarationAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerAddSeparatorAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerChangeColorAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerChangeSignalRadixAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerCopySignalPathAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerMoveSelectedElementsToGroupAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerRenameGroupDialog;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableLabelProvider;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableModel;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableTestUtils;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableViewCommon;
import ro.amiq.dvt.diagrams.wave.WaveformViewerOpenSignalConnectionAction;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WSWTRenderer;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.CustomExpandStateInfo;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTMultipleSelectionLazyView;
import ro.amiq.dvt.ui.views.lazy.tree.ITreeIteratorStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyViewSliderPosition;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionEventHandler;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WaveViewerSignalTableView
extends WaveViewerSignalTableViewCommon
implements IDVTLazyTable,
IDVTMultipleSelectionLazyView {
    public static final String TEXT_FILTER_SWTBOT_ID = String.valueOf(WaveViewerSignalTableView.class.getCanonicalName()) + ".textFilterSWTBotId";
    private Composite controlParent;
    private Composite sashChildTree;
    private static final int COLUMN_SIZE = 20;
    private WaveDiagramEditor diagramEditor;
    private WaveViewerSignalTableLabelProvider labelProvider;
    private WaveViewerSignalsTableSlideListener slideListener;
    private WaveViewerDesignHierarchyView dhView;
    private Job countEdgesJob;
    private final WaveViewerSignalTableTestUtils lazyTreeTestUtils = new WaveViewerSignalTableTestUtils(this);

    public WaveViewerSignalTableView(WaveDiagramEditor editor) {
        this.diagramEditor = editor;
        this.labelProvider = new WaveViewerSignalTableLabelProvider();
        this.slideListener = new WaveViewerSignalsTableSlideListener();
    }

    @Override
    public String getId() {
        return "ro.amiq.dvt.ui.views.WaveViewerSignalTableView";
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public void updateLabelsAndDiagram(WCanvas wCanvas) {
        this.updateLabels(null);
        DVTVCDUtils.refreshWaveDiagram(wCanvas);
    }

    public void update() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (this.waveViewerSignalsTableModel == null) {
            this.waveViewerSignalsTableModel = new WaveViewerSignalTableModel(this.diagramEditor);
        }
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.waveViewerSignalsTableModel, ExpandCollapseState.COLLAPSED, new CustomExpandStateInfo(TreePath.TOP_DUMMY_TREE_PATH, 1), false, false, true, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
    }

    public void scroll(int count) {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        lazyTree.doAction(LazyTreeAction.MOUSE_WHEEL, new LazyTreeSlideActionArguments(-count, null));
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this, LazyViewSliderPosition.LEFT);
        this.setLazyTree(lazyTree);
        this.sashChildTree = new Composite(this.controlParent, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        Composite textFilterBox = new Composite(this.sashChildTree, 4);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 3;
        groupGridLayout.marginWidth = 0;
        groupGridLayout.marginHeight = 0;
        groupGridLayout.verticalSpacing = 0;
        groupGridLayout.horizontalSpacing = 0;
        textFilterBox.setLayout((Layout)groupGridLayout);
        textFilterBox.setLayoutData((Object)new GridData(768));
        Text filterText = this.createNewTextFilter(textFilterBox);
        if (filterText != null) {
            Utils.setWidgetSWTBotId((Widget)filterText, TEXT_FILTER_SWTBOT_ID);
            filterText.setMessage("Filter by: name");
        }
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        ++((GridLayout)parent.getLayout()).numColumns;
        ToolBar tb = new ToolBar(textFilterBox, 0x800000);
        ToolItem addGroup = new ToolItem(tb, 8);
        addGroup.setImage(DVTImages.imageCache.getImage(DVTImages.WAVE_NEW_GROUP));
        addGroup.setToolTipText("Add New Group");
        addGroup.addListener(13, e -> {
            WCanvas canvas = this.getCanvas();
            if (canvas == null) {
                return;
            }
            if (!DVTVCDUtils.getInstance().hasLicense(canvas)) {
                return;
            }
            WaveViewerAddNewGroupDialog dialog = new WaveViewerAddNewGroupDialog(canvas, this, 66768, true, false, false, false, false, null, null);
            dialog.open();
        });
        ToolItem expand = new ToolItem(tb, 8);
        expand.setImage(DVTImages.imageCache.getImage(DVTImages.EXPAND_ALL_ACTION));
        expand.setToolTipText("Expand All");
        expand.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.getCanvas())) {
                return;
            }
            this.getLazyTree().doAction(LazyTreeAction.EXPAND_ALL, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_SIGNAL_TABLE_EXPAND_ALL));
        });
        ToolItem collapse = new ToolItem(tb, 8);
        collapse.setImage(DVTImages.imageCache.getImage(DVTImages.COLLAPSE_ALL_ACTION));
        collapse.setToolTipText("Collapse All");
        collapse.addListener(13, e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.getCanvas())) {
                return;
            }
            this.getLazyTree().doAction(LazyTreeAction.COLLAPSE_ALL, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_SIGNAL_TABLE_COLLAPSE_ALL));
        });
        lazyTree.setLabelProvider((ILabelProvider)this.labelProvider, false);
        lazyTree.setSearchBar(filter);
        lazyTree.install(this.sashChildTree);
        Tree tree = lazyTree.getTree();
        tree.setHeaderVisible(true);
        this.addTooltipProvider(tree);
        final WCanvas canvas = (WCanvas)this.diagramEditor.getCanvas();
        canvas.setSelectedTableHeaderHeight(tree.getHeaderHeight());
        Point textFilterPreferredSize = filter.getControl().computeSize(-1, -1);
        canvas.setSignalsTableSearchBarHeight(textFilterPreferredSize.y);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        tree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        MultipleSelectionEventHandler eventHandler = new MultipleSelectionEventHandler(this);
        tree.addKeyListener(eventHandler.createKeySelectionListener());
        lazyTree.addSelectionListener(eventHandler.createSelectionListener());
        lazyTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(() -> {
                    canvas.getRenderer().render();
                    Widget source = selectionEvent.item;
                    if (!(source instanceof TreeItem) || ((TreeItem)source).isDisposed()) {
                        return;
                    }
                    Object data = ((TreeItem)source).getData();
                    if (!(data instanceof TreePath)) {
                        return;
                    }
                    if (WaveViewerSignalTableView.this.dhView != null) {
                        WaveViewerSignalTableView.this.dhView.updateOnSelectedTreePath((TreePath)data);
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void selectionChanged() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        List<TreePath> selections = lazyTree.getSelections();
        if (selections == null || selections.isEmpty()) {
            return;
        }
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        WSWTRenderer renderer = canvas.getRenderer();
        if (renderer == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            renderer.render();
            if (this.dhView != null) {
                this.dhView.updateOnSelectedTreePath((TreePath)selections.get(0));
            }
        });
    }

    private void addTooltipProvider(Tree tree) {
        ToolTip tooltip = new ToolTip(tree.getShell(), 6);
        tooltip.setAutoHide(true);
        Listener hover = e -> {
            Point p = new Point(e.x, e.y);
            TreeItem item = tree.getItem(p);
            if (item == null) {
                tooltip.setVisible(false);
                return;
            }
            int col = -1;
            int i = 0;
            while (i < tree.getColumnCount()) {
                if (item.getBounds(i).contains(p)) {
                    col = i;
                    break;
                }
                ++i;
            }
            if (col != 0) {
                tooltip.setVisible(false);
                return;
            }
            String toolTipText = this.labelProvider.getToolTipText(item.getData());
            tooltip.setMessage(toolTipText);
            Point disp = tree.toDisplay(p.x, p.y);
            tooltip.setLocation(disp);
            tooltip.setVisible(true);
        };
        tree.addListener(32, hover);
        tree.addListener(7, e -> tooltip.setVisible(false));
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        if (manager == null) {
            return;
        }
        manager.removeAll();
        if (this.diagramEditor == null) {
            return;
        }
        Canvas canvas = this.diagramEditor.getCanvas();
        if (!(canvas instanceof WCanvas)) {
            return;
        }
        WCanvas wCanvas = (WCanvas)canvas;
        List<WSignalsTableElement> selectedElements = this.getSelectedElements();
        if (selectedElements == null) {
            return;
        }
        if (DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(this.diagramEditor)) {
            this.addOpenDeclarationAction(selectedElements, manager);
            this.addOpenSignalConnectionAction(selectedElements, manager);
            manager.add((IContributionItem)new Separator());
        }
        this.addAddNewGroupAction(selectedElements, manager);
        this.addRenameGroupAction(selectedElements, manager, wCanvas);
        this.addAddSelectedElementsToGroupAction(selectedElements, manager, wCanvas);
        this.addRemoveElementAction(this.getLazyTree().getSelections(), manager, wCanvas);
        this.addChangeSignalRadixAction(selectedElements, manager, wCanvas);
        this.addChangeElementColorAction(selectedElements, manager, wCanvas);
        this.addJumpToEdgeAction(selectedElements, manager);
        manager.add((IContributionItem)new Separator());
        this.addAddSeparatorAction(selectedElements, manager, wCanvas);
        manager.add((IContributionItem)new Separator());
        this.addCopySignalPathAction(selectedElements, manager);
    }

    private void addCopySignalPathAction(List<WSignalsTableElement> selectedElements, IMenuManager manager) {
        if (selectedElements.size() != 1 || !(selectedElements.get(0) instanceof WSignalsTableSignal)) {
            return;
        }
        manager.add((IAction)new WaveViewerCopySignalPathAction(this));
    }

    private void addOpenDeclarationAction(List<WSignalsTableElement> selectedElements, IMenuManager manager) {
        if (selectedElements.size() != 1 || !(selectedElements.get(0) instanceof WSignalsTableSignal)) {
            return;
        }
        manager.add((IAction)new WaveViewerAddOpenDeclarationAction(this));
    }

    private void addOpenSignalConnectionAction(List<WSignalsTableElement> selectedElements, IMenuManager manager) {
        if (selectedElements.size() != 1 || !(selectedElements.get(0) instanceof WSignalsTableSignal)) {
            return;
        }
        manager.add((IAction)new WaveformViewerOpenSignalConnectionAction(this));
    }

    private void addAddNewGroupAction(List<WSignalsTableElement> selectionWrappers, IMenuManager manager) {
        if (selectionWrappers.size() != 1) {
            return;
        }
        manager.add((IAction)new WaveViewerAddNewGroupAction(this));
    }

    private void addRenameGroupAction(List<WSignalsTableElement> selectedElements, IMenuManager manager, final WCanvas wCanvas) {
        if (selectedElements.size() != 1) {
            return;
        }
        final WSignalsTableElement selectedElement = selectedElements.get(0);
        if (!(selectedElement instanceof WSignalsTableGroup)) {
            return;
        }
        manager.add((IAction)new Action("Rename Group"){

            public void run() {
                if (!DVTVCDUtils.getInstance().hasLicense(wCanvas)) {
                    return;
                }
                WaveViewerRenameGroupDialog dialog = new WaveViewerRenameGroupDialog(wCanvas, (WSignalsTableGroup)selectedElement, 66768, true, false, false, false, false, null, null);
                dialog.open();
            }
        });
    }

    private void addRemoveElementAction(final List<TreePath> selections, IMenuManager manager, final WCanvas wCanvas) {
        manager.add((IAction)new Action("Remove"){

            public void run() {
                if (!DVTVCDUtils.getInstance().hasLicense(wCanvas)) {
                    return;
                }
                WViewport viewport = wCanvas.getViewport();
                for (TreePath selection : selections) {
                    viewport.removeSignalsTableElement(selection);
                    if (WaveViewerSignalTableView.this.dhView == null) continue;
                    WaveViewerSignalTableView.this.dhView.updateOnRemove(selection);
                }
                MultipleSelectionTreeIterator treeIterator = (MultipleSelectionTreeIterator)WaveViewerSignalTableView.this.getLazyTree().getTreeIterator();
                treeIterator.clearLastSelections();
                treeIterator.clearSelections();
                WaveViewerSignalTableView.this.update();
                DVTVCDUtils.refreshWaveDiagram(wCanvas);
            }
        });
    }

    private void addChangeSignalRadixAction(List<WSignalsTableElement> selectedElements, IMenuManager manager, WCanvas wCanvas) {
        block27: {
            showEnumItemAction = true;
            if (selectedElements.size() == 1) {
                WSignalsTableElement selectedElement = selectedElements.get(0);
                if (!(selectedElement instanceof WSignalsTableMultiBitSignal)) {
                    return;
                }
                if ("real".equals(((WSignalsTableMultiBitSignal)selectedElement).getType())) {
                    return;
                }
            }
            for (WSignalsTableElement selectedElement : selectedElements) {
                if (selectedElement instanceof WSignalsTableStructSignal var7_7 && struct.isEnum()) continue;
                showEnumItemAction = false;
                break;
            }
            base2Action = new WaveViewerChangeSignalRadixAction(this, wCanvas, "Base 2", "2", selectedElements);
            base8Action = new WaveViewerChangeSignalRadixAction(this, wCanvas, "Base 8", "8", selectedElements);
            base10Action = new WaveViewerChangeSignalRadixAction(this, wCanvas, "Base 10", "10", selectedElements);
            base16Action = new WaveViewerChangeSignalRadixAction(this, wCanvas, "Base 16", "16", selectedElements);
            asciiAction = new WaveViewerChangeSignalRadixAction(this, wCanvas, "ASCII", "ASCII", selectedElements);
            enumItemAction = new WaveViewerChangeSignalRadixAction(this, wCanvas, "Enum Item", "ENUM", selectedElements);
            if (selectedElements.size() != 1) break block27;
            WSignalsTableMultiBitSignal multiBitSignal = (WSignalsTableMultiBitSignal)selectedElements.get(0);
            switch (signalBase = multiBitSignal.getBase()) {
                case "2": {
                    base2Action.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
                case "8": {
                    base8Action.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
                case "10": {
                    base10Action.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
                case "16": {
                    base16Action.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
                case "ASCII": {
                    asciiAction.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
                case "ENUM": {
                    enumItemAction.setImageDescriptor(DVTImages.CHECK);
                    break;
                }
            }
        }
        MenuManager changeSignalRadixMenu = new MenuManager("Change Signal Radix");
        changeSignalRadixMenu.add((IAction)base2Action);
        changeSignalRadixMenu.add((IAction)base8Action);
        changeSignalRadixMenu.add((IAction)base10Action);
        changeSignalRadixMenu.add((IAction)base16Action);
        changeSignalRadixMenu.add((IAction)asciiAction);
        if (showEnumItemAction) {
            changeSignalRadixMenu.add((IAction)enumItemAction);
        }
        manager.add((IContributionItem)changeSignalRadixMenu);
    }

    private void addChangeElementColorAction(List<WSignalsTableElement> selectedElements, IMenuManager manager, WCanvas wCanvas) {
        Shell activeShell = Display.getDefault().getActiveShell();
        MenuManager changeColorMenu = new MenuManager("Change Color");
        boolean addChangeTextColor = false;
        boolean addChangeWavesColor = false;
        for (WSignalsTableElement selectedElement : selectedElements) {
            if (selectedElement instanceof WSignalsTableMultiBitSignal || selectedElement instanceof WSignalsTableGroup) {
                addChangeTextColor = true;
                addChangeWavesColor = true;
                break;
            }
            if (selectedElement instanceof WSignalsTableSeparator || addChangeWavesColor) continue;
            addChangeWavesColor = true;
        }
        if (addChangeTextColor) {
            WaveViewerChangeColorAction changeTextColorAction = new WaveViewerChangeColorAction(wCanvas, "Text Color", selectedElements, activeShell);
            changeColorMenu.add((IAction)changeTextColorAction);
        }
        if (addChangeWavesColor) {
            WaveViewerChangeColorAction changeWavesColorAction = new WaveViewerChangeColorAction(wCanvas, "Waves Color", selectedElements, activeShell);
            changeColorMenu.add((IAction)changeWavesColorAction);
        }
        WaveViewerChangeColorAction changeBackgroundColorAction = new WaveViewerChangeColorAction(wCanvas, "Background Color", selectedElements, activeShell);
        changeColorMenu.add((IAction)changeBackgroundColorAction);
        manager.add((IContributionItem)changeColorMenu);
    }

    private void addJumpToEdgeAction(List<WSignalsTableElement> selectedElements, IMenuManager manager) {
        if (selectedElements.size() != 1) {
            return;
        }
        WSignalsTableElement selectedElement = selectedElements.get(0);
        if (selectedElement instanceof WSignalsTableGroup || selectedElement instanceof WSignalsTableSeparator) {
            return;
        }
        MenuManager jumpToEdgeManager = new MenuManager("Jump To Change");
        JumpToEdgeAction jumpToNextEdgeAction = new JumpToEdgeAction(this, "Next Change");
        jumpToEdgeManager.add((IAction)jumpToNextEdgeAction);
        JumpToEdgeAction jumpToPrevEdgeAction = new JumpToEdgeAction(this, "Prev Change");
        jumpToEdgeManager.add((IAction)jumpToPrevEdgeAction);
        manager.add((IContributionItem)jumpToEdgeManager);
    }

    private void addAddSeparatorAction(List<WSignalsTableElement> selectedElements, IMenuManager manager, WCanvas wCanvas) {
        if (selectedElements.size() != 1) {
            return;
        }
        WSignalsTableElement element = selectedElements.get(0);
        if (element instanceof WSignalsTableSingleBitChildSignal || element instanceof WSignalsTableMultiBitChildSignal) {
            return;
        }
        manager.add((IAction)new WaveViewerAddSeparatorAction(wCanvas, "Add Separator", selectedElements, this));
    }

    private void addAddSelectedElementsToGroupAction(List<WSignalsTableElement> selectedElements, IMenuManager manager, WCanvas wCanvas) {
        if (DVTVCDUtils.selectionContainsGroups(selectedElements) || DVTVCDUtils.selectionContainsOnlyChildSignals(selectedElements)) {
            return;
        }
        manager.add((IAction)new WaveViewerMoveSelectedElementsToGroupAction(wCanvas, selectedElements));
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        int n = tree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        TableColumn selectedSignalsColumn = new TableColumn(topTable, 16384);
        selectedSignalsColumn.setText("Signals");
        selectedSignalsColumn.setWidth(n * 20 / 100);
        TreeColumn treeSelectedSignalsColumn = new TreeColumn(tree, 16384);
        treeSelectedSignalsColumn.setWidth(selectedSignalsColumn.getWidth());
        this.labelProvider.updateColumnSize(0, selectedSignalsColumn.getWidth());
        TableColumn signalsValueColumn = new TableColumn(topTable, 16384);
        signalsValueColumn.setText("Value");
        signalsValueColumn.setWidth(n * 20 / 100);
        TreeColumn treeSignalsValueColumn = new TreeColumn(tree, 16384);
        treeSignalsValueColumn.setWidth(signalsValueColumn.getWidth());
        this.labelProvider.updateColumnSize(1, signalsValueColumn.getWidth());
        selectedSignalsColumn.addListener(11, event -> {
            int n1 = selectedSignalsColumn.getWidth() + signalsValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeSelectedSignalsColumn.setWidth(selectedSignalsColumn.getWidth());
            this.labelProvider.updateColumnSize(0, selectedSignalsColumn.getWidth());
        });
        signalsValueColumn.addListener(11, event -> {
            int n1 = selectedSignalsColumn.getWidth() + signalsValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeSignalsValueColumn.setWidth(signalsValueColumn.getWidth());
            this.labelProvider.updateColumnSize(1, signalsValueColumn.getWidth());
        });
        topTable.setLinesVisible(true);
        tree.setLinesVisible(true);
        topTable.setHeaderVisible(true);
    }

    public int getItemHeight() {
        return LazyTreeUtils.treeItemHeight;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.waveViewerSignalsTableModel;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
        treeIterator.addStateListener(this.slideListener);
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.waveViewerSignalsTableModel, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
    }

    @Override
    public void swapToMessageComposite() {
    }

    @Override
    public void update(BuildEvents updateEvent) {
    }

    @Override
    public void clean() {
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
        }
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public IProject getProject() {
        return DVTPlugin.getSelectionManager().getLastSelectedProject();
    }

    public WCanvas getCanvas() {
        return (WCanvas)this.diagramEditor.getCanvas();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    public void setToolBarActionEnabled(Class<? extends IAction> actionClass, boolean enabled) {
        ToolBarManager toolBarManager = this.diagramEditor.getTopMgr();
        if (toolBarManager == null || actionClass == null) {
            return;
        }
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && actionClass.isInstance(action = ((ActionContributionItem)item).getAction())) {
                action.setEnabled(enabled);
                break;
            }
            ++n2;
        }
        Display.getDefault().asyncExec(() -> toolBarManager.update(true));
    }

    public void setToolBarActionTooltip(Class<? extends IAction> actionClass, String labelText) {
        ToolBarManager toolBarManager = this.diagramEditor.getTopMgr();
        if (toolBarManager == null || actionClass == null) {
            return;
        }
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && actionClass.isInstance(action = ((ActionContributionItem)item).getAction())) {
                action.setToolTipText(labelText);
                break;
            }
            ++n2;
        }
        Display.getDefault().asyncExec(() -> toolBarManager.update(true));
    }

    @Override
    public void createToolBar() {
    }

    public IWorkbenchPartSite getSite() {
        return this.diagramEditor.getSite();
    }

    public void cleanSoft() {
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
        }
    }

    public WaveDiagramEditor getWaveEditor() {
        return this.diagramEditor;
    }

    @Override
    public List<TreePath> getSignalsTableTreePathsInBetween(WSignalsTableElement element1, WSignalsTableElement element2) {
        WViewport viewport = ((WCanvas)this.diagramEditor.getCanvas()).getViewport();
        if (viewport == null) {
            return Collections.emptyList();
        }
        return viewport.getSignalsTableTreePathsInBetween(element1, element2);
    }

    @Override
    public List<TreePath> getAllSignalsTableTreePaths() {
        WViewport viewport = ((WCanvas)this.diagramEditor.getCanvas()).getViewport();
        if (viewport == null) {
            return Collections.emptyList();
        }
        return viewport.getAllSignalsTableTreePaths();
    }

    public List<WSignalsTableElement> getSelectedElements() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return null;
        }
        List<TreePath> selections = lazyTree.getSelections();
        if (selections == null || selections.isEmpty()) {
            return null;
        }
        ArrayList<WSignalsTableElement> selectedElements = new ArrayList<WSignalsTableElement>();
        for (TreePath selectionTreePath : selections) {
            WSignalsTableElement selectedElement = DVTVCDUtils.getSignalsTableElement(selectionTreePath);
            if (selectedElement == null) continue;
            selectedElements.add(selectedElement);
        }
        return selectedElements;
    }

    @Override
    public RGB getSelectionColor(RGB bgColor, RGB fgColor) {
        Color backgroundColor = null;
        float factor = 0.0f;
        if (DVTVCDUtils.BLACK.equals((Object)bgColor)) {
            backgroundColor = DVTColorUtil.INSTANCE.getSystemColor(26);
            factor = 0.6f;
        } else {
            backgroundColor = ColorFactory.getInstance().getColor(bgColor);
            factor = 0.4f;
        }
        Color foregroundColor = ColorFactory.getInstance().getColor(fgColor);
        return DVTColorUtil.INSTANCE.blend(backgroundColor, foregroundColor, factor).getRGB();
    }

    public void setDhView(WaveViewerDesignHierarchyView dhView) {
        this.dhView = dhView;
    }

    public WaveViewerDesignHierarchyView getDHView() {
        return this.dhView;
    }

    public WViewport getViewport() {
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return null;
        }
        return canvas.getViewport();
    }

    public Composite testGetControlParent() {
        if (TestHelper.isTestMode()) {
            return this.controlParent;
        }
        return null;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        if (!DVTVCDUtils.getInstance().hasLicense(this.getCanvas())) {
            return;
        }
        DVTVCDUtils.openSelectedElement(this.getProject(), this.getSelectedElements(), DVTOpenMode.DECLARATION);
    }

    public void revealInDVTWaveView(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (this.waveViewerSignalsTableModel == null) {
            this.waveViewerSignalsTableModel = new WaveViewerSignalTableModel(this.diagramEditor);
        }
        this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(treePath, false, Objection.WAVEFORM_VIEWER_SIGNAL_TABLE));
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        try {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            page.bringToTop((IWorkbenchPart)this.diagramEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Job getCountEdgesJob() {
        return this.countEdgesJob;
    }

    public void addTreeKeyListener(KeyListener listener) {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        Tree tree = lazyTree.getTree();
        if (tree == null) {
            return;
        }
        tree.addKeyListener(listener);
    }

    @Override
    public WaveViewerSignalTableTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public void dispose() {
        this.dhView = null;
        this.diagramEditor = null;
        super.dispose();
    }

    class WaveViewerSignalsTableSlideListener
    implements ITreeIteratorStateListener {
        WaveViewerSignalsTableSlideListener() {
        }

        @Override
        public void stateChanged(TreeIteratorEvent event) {
            Display.getDefault().asyncExec(() -> ((WCanvas)WaveViewerSignalTableView.this.diagramEditor.getCanvas()).getRenderer().render());
        }
    }
}

