/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import com.google.re2j.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.WaveformViewerJumpToTimeDialogCommon;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class WaveformViewerJumpToTimeDialog
extends WaveformViewerJumpToTimeDialogCommon {
    private WCanvas canvas;
    private Composite timeValueErrorComposite;
    private Label timeValueErrorText;
    private Label timeValueErrorIcon;
    private Button jumpToButton;
    private static final Pattern NUMBER_PATTERN = Pattern.compile((String)"\\d*");
    private static int DIALOG_AREA_WIDTH = 300;
    private static int DIALOG_AREA_HEIGHT = 50;

    public WaveformViewerJumpToTimeDialog(Shell parent, WCanvas canvas) {
        super(parent, 0x1000050, true, false, true, false, false, "", "");
        this.canvas = canvas;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Jump To Time");
    }

    @Override
    protected String getId() {
        return "Jump To Time";
    }

    private void jumpTo(Text timeInput) {
        String timeString = timeInput.getText();
        try {
            long inputTimeValue = Long.parseLong(timeString);
            this.jumpToTime(inputTimeValue, this.canvas);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).applyTo(composite);
        this.getShell().setMinimumSize(DIALOG_AREA_WIDTH, DIALOG_AREA_HEIGHT);
        final Text timeInput = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)timeInput);
        timeInput.addVerifyListener(e -> {
            if (!NUMBER_PATTERN.matcher((CharSequence)e.text).matches()) {
                e.doit = false;
            }
        });
        timeInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveformViewerJumpToTimeDialog.this.jumpTo(timeInput);
                }
            }
        });
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd();
        this.jumpToButton = new Button(composite, 8);
        this.jumpToButton.setText("Jump");
        GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)this.jumpToButton);
        this.jumpToButton.setEnabled(false);
        this.jumpToButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                WaveformViewerJumpToTimeDialog.this.jumpTo(timeInput);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.timeValueErrorComposite = new Composite(composite, 0);
        this.timeValueErrorComposite.setLayout((Layout)new GridLayout(2, false));
        this.timeValueErrorIcon = new Label(this.timeValueErrorComposite, 1024);
        this.timeValueErrorIcon.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_ERROR_TASK));
        this.timeValueErrorText = new Label(this.timeValueErrorComposite, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.timeValueErrorText);
        timeInput.addModifyListener(e -> this.validateNewTimeValue(this.jumpToButton, timeInput.getText(), firstTimeFromVcd, lastTimeFromVcd));
        composite.pack();
        return composite;
    }

    public int open() {
        try {
            int n = super.open();
            return n;
        }
        finally {
            this.showHideErrorLabel(false, "", this.jumpToButton, true);
        }
    }

    public void validateNewTimeValue(Button jumpToButton, String timeValue, long firstTimeFromVcd, long lastTimeFromVcd) {
        if (timeValue.isEmpty()) {
            this.showHideErrorLabel(true, "Time value should not be empty!", jumpToButton, false);
        } else if ((long)Integer.parseInt(timeValue) > lastTimeFromVcd) {
            this.showHideErrorLabel(true, "Time value should be equal or less than " + lastTimeFromVcd + "!", jumpToButton, false);
        } else if ((long)Integer.parseInt(timeValue) < firstTimeFromVcd) {
            this.showHideErrorLabel(true, "Time value should be equal or greater than " + firstTimeFromVcd + "!", jumpToButton, false);
        } else {
            this.showHideErrorLabel(false, "", jumpToButton, true);
        }
    }

    private void showHideErrorLabel(boolean isShow, String labelText, Button okButton, boolean isOkEnabled) {
        GridData errorCompositeLayoutData = (GridData)this.timeValueErrorComposite.getLayoutData();
        this.timeValueErrorText.setText(labelText);
        errorCompositeLayoutData.exclude = !isShow;
        this.timeValueErrorComposite.setVisible(isShow);
        okButton.setEnabled(isOkEnabled);
        this.timeValueErrorComposite.getParent().requestLayout();
        this.timeValueErrorComposite.getShell().pack(true);
    }
}

