/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;

public abstract class WaveformViewerJumpToTimeDialogCommon
extends DVTPopupDialog {
    protected WaveformViewerJumpToTimeDialogCommon(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
    }

    protected void jumpToTime(long time, WCanvas canvas) {
        WViewport viewPort = canvas.getViewport();
        if (viewPort == null) {
            return;
        }
        long timeUnitsOnScreen = viewPort.getHighestVisibleTime() - viewPort.getLowestVisibleTime();
        DVTVCDParser provider = canvas.getProvider();
        if (provider == null) {
            return;
        }
        long lastTimeFromVcd = provider.getLastTimeFromVcd();
        long lastVisibleTime = lastTimeFromVcd + (long)viewPort.getLastTimeOffset();
        if (time > lastTimeFromVcd) {
            return;
        }
        long leftTimeStamp = Math.max(provider.getFirstTimeFromVcd(), time - timeUnitsOnScreen / 2L);
        long rightTimeStamp = Math.min(leftTimeStamp + timeUnitsOnScreen, lastVisibleTime);
        if (rightTimeStamp == lastVisibleTime) {
            leftTimeStamp = lastVisibleTime - timeUnitsOnScreen;
        }
        viewPort.zoomToFitTimes(leftTimeStamp, rightTimeStamp);
        viewPort.getPrimaryCursor().setFixedTime(time, viewPort);
        viewPort.updateTableValues();
    }
}

