/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.logviewer.ILogViewerContributor;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WaveformViewerLogViewerAction
extends Action {
    private WCanvas canvas;

    protected WaveformViewerLogViewerAction(WCanvas canvas) {
        super("Jump To Time in Log Viewer", 1);
        this.setImageDescriptor(DVTImages.WAVE_JUMP_TO_TIME_LOGVIEWER);
        this.canvas = canvas;
    }

    public void run() {
        if (this.canvas == null) {
            return;
        }
        if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
            return;
        }
        ILogViewerContributor logViewerContributor = LogViewerContributorUtils.get();
        if (logViewerContributor == null) {
            return;
        }
        if (!DVTVCDUtils.getInstance().isCursorPlaced(this.canvas)) {
            return;
        }
        String queryFromCursors = DVTVCDUtils.getInstance().getLogViewerQueryFromCursors(this.canvas);
        if (queryFromCursors == null) {
            return;
        }
        IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
        logViewerContributor.openLogViewerWithQuery(lastSelectedProject, queryFromCursors);
    }
}

