/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WHorizontalCanvasSlider;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WCtrlClickZoomHandler;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WCursorsHandler;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WMarkersHandler;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WMouseWheelHandler;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WPanHandler;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WResizeHandler;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WSWTDebug;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WSWTRenderer;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;

public class WCanvas
extends Canvas {
    private final DDebug debug;
    private final WViewport viewport;
    private final WSWTRenderer renderer;
    private final WCursorsHandler cursorsHandler;
    private final WMarkersHandler markersHandler;
    private final WPanHandler panHandler;
    private final WMouseWheelHandler zoomHandler;
    private final WResizeHandler resizeHandler;
    private final WCtrlClickZoomHandler ctrlClickZoomHandler;
    private DVTVCDParser canvasProvider;
    private int selectedSignalsTableHeight;
    private int signalsTableSearchBarHeight;
    private WaveViewerSignalTableView signalsTableView;
    private WHorizontalCanvasSlider horizontalSlider;

    public WCanvas(Composite parent, DVTVCDParser canvasProvider, WHorizontalCanvasSlider horizontalSlider) {
        super(parent, 0x140000);
        this.canvasProvider = canvasProvider;
        this.horizontalSlider = horizontalSlider;
        this.viewport = new WViewport(this, horizontalSlider, canvasProvider);
        canvasProvider.setViewport(this.viewport);
        this.renderer = new WSWTRenderer(this);
        this.cursorsHandler = new WCursorsHandler(this);
        this.markersHandler = new WMarkersHandler(this);
        this.panHandler = new WPanHandler(this);
        this.zoomHandler = new WMouseWheelHandler(this);
        this.resizeHandler = new WResizeHandler(this);
        this.ctrlClickZoomHandler = new WCtrlClickZoomHandler(this);
        this.debug = WSWTDebug.getInstance(this);
    }

    public DDebug getDebug() {
        return this.debug;
    }

    public WViewport getViewport() {
        return this.viewport;
    }

    public WSWTRenderer getRenderer() {
        return this.renderer;
    }

    public DVTVCDParser getProvider() {
        return this.canvasProvider;
    }

    public void setProvider(DVTVCDParser canvasProvider) {
        this.canvasProvider = canvasProvider;
    }

    public void setSelectedTableHeaderHeight(int headerHeight) {
        this.selectedSignalsTableHeight = headerHeight;
    }

    public int getSelectedSignalsTableHeight() {
        return this.selectedSignalsTableHeight;
    }

    public void setSignalsTableSearchBarHeight(int signalsTableSearchBarHeight) {
        this.signalsTableSearchBarHeight = signalsTableSearchBarHeight;
    }

    public int getSignalsTableSearchBarHeight() {
        return this.signalsTableSearchBarHeight;
    }

    public WaveViewerSignalTableView getSignalsTableView() {
        return this.signalsTableView;
    }

    public void setSignalsTableView(WaveViewerSignalTableView signalsTableView) {
        this.signalsTableView = signalsTableView;
    }

    public long getZoomMouseDownTime() {
        return this.ctrlClickZoomHandler.getMouseDownTime();
    }

    public long getZoomMouseCurrentTime() {
        return this.ctrlClickZoomHandler.getCurrentMouseTime();
    }

    public int getHorizontalSliderHeight() {
        if (this.horizontalSlider == null) {
            return 0;
        }
        Point horizontalSliderPoint = this.horizontalSlider.getSliderComposite().computeSize(-1, -1);
        return horizontalSliderPoint.y;
    }
}

