/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw;

import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;

public class WCursor {
    private String name;
    private String label;
    private long time;
    private int labelOutlineWidth;
    private int labelHitOffset;
    private boolean flipped;

    public WCursor(String name, long time) {
        this.name = name;
        this.time = time;
    }

    public WCursor(WCursor cursor) {
        this.name = cursor.name;
        this.time = cursor.time;
    }

    public long getTime() {
        return this.time;
    }

    public void setFixedTime(long time, WViewport viewport) {
        this.time = time;
        this.updateLabel(viewport);
    }

    public void setTime(int mouseX, int mouseY, WViewport viewport) {
        int relativeX = mouseX - viewport.getTimesTextXOffset() - this.labelHitOffset;
        List<TreePath> treePaths = viewport.getCanvas().getSignalsTableView().getLazyTree().getViewContent();
        WSignalsTableSignal currentSignal = null;
        for (TreePath treePath : treePaths) {
            WSignalsTableSignal signal;
            Object element = treePath.getElement();
            if (!(element instanceof WSignalsTableSignal) || (signal = (WSignalsTableSignal)element).getWaveY() > mouseY || mouseY > signal.getWaveY() + signal.getWaveHeight()) continue;
            currentSignal = signal;
            break;
        }
        this.time = DVTVCDUtils.computeTime(relativeX, currentSignal, viewport, true);
        this.updateLabel(viewport);
    }

    public void updateLabel(WViewport viewport) {
        this.label = String.valueOf(this.name) + " T=" + this.time + viewport.getTimescale().getName();
        this.labelOutlineWidth = this.label.length() * 7;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLabelOutlineWidth() {
        return this.labelOutlineWidth;
    }

    public boolean isHit(MouseEvent e, WViewport viewport) {
        boolean hitLabelY;
        int clickedRelativeX = e.x - viewport.getTimesTextXOffset();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        long cursorTimeRelativeX = (long)((double)(this.time - viewport.getLowestVisibleTime()) * timeUnitSizeOnScreen);
        boolean hitLabelX = false;
        hitLabelX = !this.flipped ? (long)clickedRelativeX >= cursorTimeRelativeX && (long)clickedRelativeX <= cursorTimeRelativeX + (long)this.labelOutlineWidth : (long)clickedRelativeX <= cursorTimeRelativeX && (long)clickedRelativeX >= cursorTimeRelativeX - (long)this.labelOutlineWidth;
        boolean bl = hitLabelY = e.y >= 1 && e.y <= 15;
        if (hitLabelX && hitLabelY) {
            this.labelHitOffset = (int)((long)clickedRelativeX - cursorTimeRelativeX);
            return true;
        }
        this.labelHitOffset = 0;
        return false;
    }

    public boolean isInCanvas(WCanvas canvas) {
        DVTVCDParser provider = canvas.getProvider();
        if (provider == null) {
            return false;
        }
        long firstTimeFromVcd = provider.getFirstTimeFromVcd();
        long lastTimeFromVcd = provider.getLastTimeFromVcd();
        return this.time >= firstTimeFromVcd && this.time <= lastTimeFromVcd;
    }

    public void removeCursor() {
        this.time = -100L;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }
}

