/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCanvasAction;
import ro.amiq.dvt.diagrams.wave.draw.WHorizontalCanvasSliderCommon;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeSliderSeparatorSide;
import ro.amiq.dvt.ui.views.lazy.tree.LazyViewSlider;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WHorizontalCanvasSlider
extends WHorizontalCanvasSliderCommon {
    private static final int TIME_INTERVAL_LABEL_COL_SPAN = 4;
    protected WScrollJob wScrollJob = new WScrollJob("WScroll...");
    Label timeIntervalLabel;

    public WHorizontalCanvasSlider(Composite parent, LazyTreeSliderSeparatorSide separatorSide) {
        super(parent, separatorSide);
        this.goToStartButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.START);
        this.prevPageButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.PAGE_LEFT);
        this.prevStepButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.LEFT);
        this.makeTimeIntervalLabel();
        this.nextStepButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.RIGHT);
        this.nextPageButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.PAGE_RIGHT);
        this.goToEndButton = this.makeCanvas(this.sliderComposite, LazyViewSlider.Arrow.END);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.sliderComposite);
        GridLayoutFactory.fillDefaults().numColumns(10).equalWidth(true).applyTo(this.sliderComposite);
    }

    protected void makeTimeIntervalLabel() {
        this.timeIntervalLabel = new Label(this.sliderComposite, 0x1000000);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(4, -1).align(0x1000000, 0x1000000).applyTo((Control)this.timeIntervalLabel);
        DVTColorUtil.INSTANCE.setBackground((Control)this.timeIntervalLabel, this.COLOR_TREE_BG);
    }

    @Override
    protected Canvas makeCanvas(Composite parent, LazyViewSlider.Arrow arrow) {
        Canvas c = new Canvas(parent, 0);
        c.setToolTipText(arrow.getTooltip());
        c.addPaintListener((PaintListener)new LazyViewSlider.CanvasPaintListener(this, arrow));
        c.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("hover", null);
                ((Canvas)e.widget).redraw();
            }

            public void mouseEnter(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("hover", (Object)true);
                ((Canvas)e.widget).redraw();
            }
        });
        c.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("clicked", null);
                ((Canvas)e.widget).redraw();
                WHorizontalCanvasSlider.this.wScrollJob.cancel();
            }

            public void mouseDown(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("clicked", (Object)true);
                ((Canvas)e.widget).redraw();
                if (WHorizontalCanvasSlider.this.wScrollJob.getState() == 0) {
                    if (WHorizontalCanvasSlider.this.canvas == null || WHorizontalCanvasSlider.this.canvas.isDisposed()) {
                        return;
                    }
                    WHorizontalCanvasSlider.this.wScrollJob.setEvent(e);
                    WHorizontalCanvasSlider.this.wScrollJob.schedule();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).hint(24, 24).applyTo((Control)c);
        return c;
    }

    @Override
    public void updateTimeIntervalLabelText() {
        this.timeIntervalLabel.setText("");
        this.timeIntervalLabel.setToolTipText("");
        this.timeIntervalLabel.requestLayout();
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd();
        String timescale = this.canvas.getViewport().getTimescale().getName();
        this.goToStartButton.setToolTipText(String.valueOf(LazyViewSlider.Arrow.START.getTooltip()) + " : " + firstTimeFromVcd + " " + timescale);
        this.goToEndButton.setToolTipText(String.valueOf(LazyViewSlider.Arrow.END.getTooltip()) + " : " + lastTimeFromVcd + " " + timescale);
    }

    public void setCanvas(WCanvas canvas) {
        this.canvas = canvas;
    }

    class WScrollJob
    extends Job {
        private MouseEvent event;

        public WScrollJob(String name) {
            super(name);
        }

        public void setEvent(MouseEvent event) {
            this.event = event;
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                if (!DVTVCDUtils.getInstance().hasLicense(WHorizontalCanvasSlider.this.canvas)) {
                    return Status.CANCEL_STATUS;
                }
                if (WHorizontalCanvasSlider.this.canvas == null) {
                    return Status.OK_STATUS;
                }
                WViewport viewport = WHorizontalCanvasSlider.this.canvas.getViewport();
                Widget widget = this.event.widget;
                if (widget == WHorizontalCanvasSlider.this.goToStartButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.GO_TO_START_OF_TIMELINE);
                        viewport.updateProviderModel();
                    });
                    break;
                }
                if (widget == WHorizontalCanvasSlider.this.prevPageButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.PREV_PAGE);
                        viewport.updateProviderModel();
                    });
                } else if (widget == WHorizontalCanvasSlider.this.prevStepButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.PREV_STEP);
                        viewport.updateProviderModel();
                    });
                } else if (widget == WHorizontalCanvasSlider.this.nextStepButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.NEXT_STEP);
                        viewport.updateProviderModel();
                    });
                } else if (widget == WHorizontalCanvasSlider.this.nextPageButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.NEXT_PAGE);
                        viewport.updateProviderModel();
                    });
                } else if (widget == WHorizontalCanvasSlider.this.goToEndButton) {
                    Display.getDefault().asyncExec(() -> {
                        viewport.horizontalScroll(WCanvasAction.GO_TO_END_OF_TIMELINE);
                        viewport.updateProviderModel();
                    });
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

