/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WMarker {
    private String label;
    private long time;
    private int labelOutlineWidth;

    public WMarker(String label, long time) {
        this.label = label;
        this.time = time;
        Point stringExtent = FontFactory.getInstance().stringExtent(label, DVTVCDUtils.getFontData());
        this.labelOutlineWidth = stringExtent.x + 6;
    }

    public WMarker(WMarker marker) {
        this.label = marker.label;
        this.time = marker.time;
    }

    public String getLabel() {
        return this.label;
    }

    public long getTime() {
        return this.time;
    }

    public int getLabelOutlineWidth() {
        return this.labelOutlineWidth;
    }

    public boolean isHit(MouseEvent e, WViewport viewport) {
        boolean hitLabelY;
        int labelXOffset;
        long markerX = (long)((double)(this.time - viewport.getLowestVisibleTime()) * viewport.getTimeUnitSizeOnScreen()) + (long)viewport.getTimesTextXOffset();
        boolean hitLabelX = (long)e.x >= markerX - (long)(labelXOffset = this.labelOutlineWidth / 2) && (long)e.x <= markerX + (long)labelXOffset;
        boolean bl = hitLabelY = e.y >= 1 && e.y <= 15;
        return hitLabelX && hitLabelY;
    }
}

