/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.wave.RefreshAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCanvasAction;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WHorizontalCanvasSlider;
import ro.amiq.dvt.diagrams.wave.draw.WMarker;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableHierarchialElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WViewport {
    private static final double MIN_NOF_VISIBLE_TIME_UNITS_TO_DECREASE_TIME_SCALE = 1.5;
    private static final double SCALE_RESOLUTION = 10.0;
    private final WCanvas canvas;
    private TreeSet<WSignalsTableElement> signalsTableElements;
    private WCursor primaryCursor;
    private WCursor secondaryCursor;
    private DVTVCDUtilsCommon.Cursors cursorOnTop;
    private List<WMarker> markers;
    private long panX;
    private long panY;
    private boolean allowPan;
    private long lowestVisibleTime;
    private long highestVisibleTime;
    private long timeLabelInterval;
    private int scale;
    private double timeUnitSizeOnScreen;
    private DVTVCDUtilsCommon.TimeScales vcdFileTimescale;
    private DVTVCDUtilsCommon.TimeScales currentTimescale;
    private Job updateProviderModelJob;
    private Job updateSignalsTableValuesJob;
    private Rectangle canvasSize = new Rectangle(0, 0, 1, 1);
    private WHorizontalCanvasSlider horizontalCanvasSlider;
    private boolean isInitialResize;

    public WViewport(final WCanvas canvas, WHorizontalCanvasSlider horizontalCanvasSlider, DVTVCDParser canvasProvider) {
        this.canvas = canvas;
        this.horizontalCanvasSlider = horizontalCanvasSlider;
        this.signalsTableElements = new TreeSet((o1, o2) -> o1.getId() - o2.getId());
        this.scale = 80;
        this.currentTimescale = this.vcdFileTimescale = canvasProvider.getVcdFileTimeUnit() == null ? DVTVCDUtilsCommon.TimeScales.PICO_SECOND : canvasProvider.getVcdFileTimeUnit();
        this.timeLabelInterval = 1L;
        this.timeUnitSizeOnScreen = this.getExpScale();
        this.primaryCursor = new WCursor("C1", -100L);
        this.secondaryCursor = new WCursor("C2", -100L);
        this.cursorOnTop = DVTVCDUtilsCommon.Cursors.PRIMARY;
        this.allowPan = true;
        this.lowestVisibleTime = canvasProvider.getFirstTimeFromVcd();
        this.isInitialResize = true;
        this.markers = new ArrayList<WMarker>();
        this.updateProviderModelJob = new Job("Update Waveform Viewer Model"){

            protected IStatus run(IProgressMonitor monitor) {
                DVTVCDParser vcdParser = canvas.getProvider();
                if (vcdParser == null) {
                    return Status.CANCEL_STATUS;
                }
                if (!(vcdParser instanceof FSTReader) && DVTVCDUtils.DVT_DISABLE_DST_CONVERSION) {
                    WViewport.this.setToolBarActionEnabled(RefreshAction.class, false);
                }
                vcdParser.setDiagramTimeLimits(WViewport.this.lowestVisibleTime, WViewport.this.highestVisibleTime);
                vcdParser.updateModel();
                Display.getDefault().asyncExec(() -> canvas.getRenderer().render());
                if (!(vcdParser instanceof FSTReader) && DVTVCDUtils.DVT_DISABLE_DST_CONVERSION) {
                    WViewport.this.setToolBarActionEnabled(RefreshAction.class, true);
                }
                return Status.OK_STATUS;
            }
        };
        this.updateSignalsTableValuesJob = new Job("Update Signals Table Job"){

            protected IStatus run(IProgressMonitor monitor) {
                WViewport.this.updateSignalsTableValues(monitor);
                return Status.OK_STATUS;
            }
        };
    }

    public void setCanvasSize(Rectangle size) {
        this.canvasSize = size;
        this.canvas.setBounds(size);
        DVTVCDParser provider = this.canvas.getProvider();
        if (this.isInitialResize) {
            this.isInitialResize = false;
            this.lowestVisibleTime = provider.getDiagramLowerTimeLimit();
            this.highestVisibleTime = provider.getDiagramUpperTimeLimit();
            this.timeUnitSizeOnScreen = (double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / (double)(this.highestVisibleTime - this.lowestVisibleTime);
            this.scale = this.expScaleToScale(this.timeUnitSizeOnScreen);
        } else {
            this.highestVisibleTime = this.lowestVisibleTime + (long)((double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / this.getTimeUnitSizeOnScreen());
            long lastTimeFromVcd = provider.getLastTimeFromVcd() + (long)this.getLastTimeOffset();
            if (this.highestVisibleTime > lastTimeFromVcd) {
                this.lowestVisibleTime -= this.highestVisibleTime - lastTimeFromVcd;
                this.highestVisibleTime = lastTimeFromVcd;
                if (this.lowestVisibleTime < provider.getFirstTimeFromVcd()) {
                    this.lowestVisibleTime = provider.getFirstTimeFromVcd();
                    this.timeUnitSizeOnScreen = (double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / (double)lastTimeFromVcd;
                    this.scale = this.expScaleToScale(this.timeUnitSizeOnScreen);
                    this.panX = 0L;
                }
            }
        }
        this.updateTimeLabelInterval(this.highestVisibleTime - this.lowestVisibleTime);
        this.canvas.getRenderer().render();
        this.checkBoundariesAndUpdateSlider();
        this.logDebugInfo();
    }

    public Rectangle getCanvasSize() {
        return this.canvasSize;
    }

    public DVTVCDUtilsCommon.Cursors getCursorOnTop() {
        return this.cursorOnTop;
    }

    public void setCursorOnTop(DVTVCDUtilsCommon.Cursors cursor) {
        this.cursorOnTop = cursor;
    }

    public void zoomIncrementedScaleAboutPoint(int amount, double x) {
        this.zoomFixedScaleAboutPoint(this.scale + amount, x);
    }

    public void zoomFixedScaleAboutPoint(int scale, double x) {
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd() + (long)this.getLastTimeOffset();
        if (lastTimeFromVcd == 0L) {
            return;
        }
        int maxXToDrawAt = this.getMaxXToDrawAt();
        int timeTextXOffset = this.getTimesTextXOffset();
        double minTimeUnitsSizeOnScreen = (float)(maxXToDrawAt - timeTextXOffset) / (float)(lastTimeFromVcd - firstTimeFromVcd);
        int nofVisibleTimeUnits = (int)Math.floor((double)(maxXToDrawAt - timeTextXOffset) / this.timeUnitSizeOnScreen);
        if ((double)nofVisibleTimeUnits < 1.5 && scale > this.scale && this.currentTimescale == this.vcdFileTimescale) {
            return;
        }
        int dx = (int)Math.floor(x - (double)timeTextXOffset > 0.0 ? x - (double)timeTextXOffset : 0.0);
        int timeToZoomOn = (int)Math.floor((double)(this.panX + (long)dx) / this.timeUnitSizeOnScreen);
        this.scale = scale;
        double potentialTimeUnitsSizeOnScreen = this.getExpScale();
        if (potentialTimeUnitsSizeOnScreen < minTimeUnitsSizeOnScreen) {
            potentialTimeUnitsSizeOnScreen = minTimeUnitsSizeOnScreen;
            this.scale = this.expScaleToScale(potentialTimeUnitsSizeOnScreen);
        }
        this.timeUnitSizeOnScreen = potentialTimeUnitsSizeOnScreen;
        double nofTimeUnitsBeforeDx = Math.floor((double)dx / this.timeUnitSizeOnScreen);
        long potentialLowestVisibleTime = (long)((double)timeToZoomOn - nofTimeUnitsBeforeDx);
        long potentialHighestVisibleTime = potentialLowestVisibleTime + (long)((double)(maxXToDrawAt - timeTextXOffset) / this.getTimeUnitSizeOnScreen());
        if (potentialHighestVisibleTime > lastTimeFromVcd) {
            potentialLowestVisibleTime -= potentialHighestVisibleTime - lastTimeFromVcd;
        }
        this.lowestVisibleTime = potentialLowestVisibleTime > firstTimeFromVcd ? potentialLowestVisibleTime : firstTimeFromVcd;
        this.highestVisibleTime = this.lowestVisibleTime + (long)((double)(maxXToDrawAt - timeTextXOffset) / this.getTimeUnitSizeOnScreen());
        this.panX = (long)(this.timeUnitSizeOnScreen * (double)this.lowestVisibleTime);
        this.updateTimeLabelInterval(this.highestVisibleTime - this.lowestVisibleTime);
        this.canvas.getRenderer().render();
        this.checkBoundariesAndUpdateSlider();
        this.logDebugInfo();
    }

    public void zoomToFitCursors() {
        long secondaryCTime;
        long primaryCTime = this.primaryCursor.getTime();
        if (primaryCTime == (secondaryCTime = this.secondaryCursor.getTime())) {
            return;
        }
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        if (primaryCTime < firstTimeFromVcd || secondaryCTime < firstTimeFromVcd) {
            return;
        }
        long lowerTime = primaryCTime < secondaryCTime ? primaryCTime : secondaryCTime;
        long higherTime = primaryCTime < secondaryCTime ? secondaryCTime : primaryCTime;
        this.zoomToFitTimes(lowerTime, higherTime);
    }

    public void zoomToFitCanvas() {
        DVTVCDParser parser = this.canvas.getProvider();
        if (parser == null) {
            return;
        }
        long firstTimeFromVcd = parser.getFirstTimeFromVcd();
        long lastTimeFromVcd = parser.getLastTimeFromVcd() + (long)this.getLastTimeOffset();
        this.zoomToFitTimes(firstTimeFromVcd, lastTimeFromVcd);
    }

    public void zoomToFitTimes(long lowerTime, long higherTime) {
        if (lowerTime == higherTime) {
            return;
        }
        long nofVisibleTimeUnits = higherTime - lowerTime;
        this.timeUnitSizeOnScreen = (double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / (double)nofVisibleTimeUnits;
        this.scale = this.expScaleToScale(this.timeUnitSizeOnScreen);
        this.updateTimeLabelInterval(nofVisibleTimeUnits);
        this.lowestVisibleTime = lowerTime;
        this.highestVisibleTime = this.lowestVisibleTime + Math.round((double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / this.timeUnitSizeOnScreen);
        this.panX = (long)((double)this.lowestVisibleTime * this.timeUnitSizeOnScreen);
        this.updateProviderModel();
        this.checkBoundariesAndUpdateSlider();
        this.logDebugInfo();
    }

    public void horizontalScroll(WCanvasAction action) {
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd() + (long)this.getLastTimeOffset();
        long dt = 0L;
        long nofVisibleTimeUnits = this.highestVisibleTime - this.lowestVisibleTime;
        switch (action) {
            case NEXT_STEP: {
                dt = (long)Math.max((double)nofVisibleTimeUnits * 0.1, 1.0);
                break;
            }
            case PREV_STEP: {
                dt = (long)Math.min(-((double)nofVisibleTimeUnits * 0.1), -1.0);
                break;
            }
            case NEXT_PAGE: {
                dt = nofVisibleTimeUnits;
                break;
            }
            case PREV_PAGE: {
                dt = -nofVisibleTimeUnits;
                break;
            }
            case GO_TO_END_OF_TIMELINE: {
                dt = lastTimeFromVcd - this.highestVisibleTime;
                break;
            }
            case GO_TO_START_OF_TIMELINE: {
                dt = firstTimeFromVcd - this.lowestVisibleTime;
                break;
            }
        }
        long potentialLowestVisibleTime = this.lowestVisibleTime + dt < firstTimeFromVcd ? firstTimeFromVcd : this.lowestVisibleTime + dt;
        long potentialHighestVisibleTime = potentialLowestVisibleTime + (long)((double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / this.timeUnitSizeOnScreen);
        if (potentialHighestVisibleTime > lastTimeFromVcd) {
            potentialLowestVisibleTime -= potentialHighestVisibleTime - lastTimeFromVcd;
        }
        this.lowestVisibleTime = potentialLowestVisibleTime;
        this.highestVisibleTime = this.lowestVisibleTime + (long)((double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / this.timeUnitSizeOnScreen);
        this.panX = (long)((double)this.lowestVisibleTime * this.timeUnitSizeOnScreen);
        this.canvas.getRenderer().render();
        this.checkBoundariesAndUpdateSlider();
    }

    private void updateTimeLabelInterval(long nofVisibleTimeUnits) {
        this.timeLabelInterval = (long)Math.pow(10.0, (int)Math.log10(nofVisibleTimeUnits));
    }

    public int getTimesTextXOffset() {
        DVTVCDParser provider = this.canvas.getProvider();
        if (provider == null) {
            return 0;
        }
        DVTVCDModel vcdModel = provider.getVcdModel();
        if (vcdModel == null) {
            return 0;
        }
        return 10;
    }

    public WCanvas getCanvas() {
        return this.canvas;
    }

    public void pan(long dx) {
        double maxPanX;
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd() + (long)this.getLastTimeOffset();
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        if (!this.allowPan) {
            return;
        }
        double minPanX = (double)firstTimeFromVcd * this.getTimeUnitSizeOnScreen();
        this.panX = (double)(this.panX + dx) <= minPanX ? (long)minPanX : ((double)(this.panX + dx) <= (maxPanX = (double)lastTimeFromVcd * this.getTimeUnitSizeOnScreen() - (double)this.getMaxXToDrawAt() + (double)this.getTimesTextXOffset()) ? (this.panX += dx) : (long)maxPanX);
        this.lowestVisibleTime = (long)((double)this.panX / this.timeUnitSizeOnScreen);
        if (this.lowestVisibleTime < firstTimeFromVcd) {
            this.lowestVisibleTime = firstTimeFromVcd;
        }
        this.highestVisibleTime = this.lowestVisibleTime + (long)((double)(this.getMaxXToDrawAt() - this.getTimesTextXOffset()) / this.getTimeUnitSizeOnScreen());
        this.canvas.getRenderer().render();
        this.checkBoundariesAndUpdateSlider();
        this.logDebugInfo();
    }

    protected int expScaleToScale(double expScale) {
        return (int)Math.floor(Math.log(expScale) / Math.log(2.0) * 10.0);
    }

    public double getExpScale() {
        return Math.pow(2.0, (double)this.scale / 10.0);
    }

    public long getPanX() {
        return this.panX;
    }

    public long getPanY() {
        return this.panY;
    }

    public DVTVCDUtilsCommon.TimeScales getTimescale() {
        return this.currentTimescale;
    }

    public int getCurrentTimescaleInVcdTimescale() {
        return (int)Math.pow(10.0, (double)this.currentTimescale.getExponentOf10() - (double)this.vcdFileTimescale.getExponentOf10());
    }

    public long getLowestVisibleTime() {
        return this.lowestVisibleTime;
    }

    public long getHighestVisibleTime() {
        return this.highestVisibleTime;
    }

    public double getTimeUnitSizeOnScreen() {
        return this.timeUnitSizeOnScreen;
    }

    public long getTimeLabelInterval() {
        return this.timeLabelInterval;
    }

    public int getMaxXToDrawAt() {
        Point canvasSize = this.canvas.getSize();
        if (canvasSize == null) {
            return this.getTimesTextXOffset();
        }
        return canvasSize.x;
    }

    public int getLastTimeOffset() {
        DVTVCDParser provider = this.canvas.getProvider();
        if (provider == null) {
            return 0;
        }
        DVTVCDModel vcdModel = provider.getVcdModel();
        if (vcdModel == null) {
            return 0;
        }
        if ((double)(this.getMaxXToDrawAt() + this.getTimesTextXOffset()) / this.timeUnitSizeOnScreen <= 2.0) {
            return 1;
        }
        return 2;
    }

    public TreeSet<WSignalsTableElement> getSignalsTableElements() {
        return this.signalsTableElements;
    }

    public Set<String> getSignalsTableIds() {
        HashSet<String> signalsIds = new HashSet<String>();
        for (WSignalsTableElement signalTableElement : this.signalsTableElements) {
            if (!(signalTableElement instanceof WSignalsTableGroup var4_4)) continue;
            for (WSignalsTableElement childElement : signalsGroup.getChildElements()) {
                if (!(childElement instanceof WSignalsTableSignal var8_8)) continue;
                signalsIds.add(signalElement.getVcdId());
            }
        }
        return signalsIds;
    }

    public void addSignalsTableNode(WSignalsTableElement element) {
        this.signalsTableElements.add(element);
    }

    public void removeSignalsTableElement(TreePath selection) {
        WSignalsTableElement element = DVTVCDUtils.getSignalsTableElement(selection);
        if (element == null) {
            return;
        }
        if (element instanceof ISignalsTableHierarchialElement && ((ISignalsTableHierarchialElement)((Object)element)).isChildElement()) {
            ((ISignalsTableHierarchialElement)((Object)element)).removeFromParent();
            return;
        }
        int elementId = element.getId();
        WSignalsTableGroup parentGroup = DVTVCDUtils.getParentGroup(element);
        if (parentGroup == null) {
            DVTVCDUtils.removeSignalsTableElement(this.signalsTableElements, elementId);
            return;
        }
        TreeSet<WSignalsTableElement> elementSiblings = parentGroup.getChildElements();
        if (elementSiblings == null || elementSiblings.isEmpty()) {
            return;
        }
        DVTVCDUtils.removeSignalsTableElement(elementSiblings, elementId);
    }

    public void importMarkers(List<WMarker> importedMarkers) {
        if (!this.markers.isEmpty()) {
            this.markers.clear();
        }
        this.markers.addAll(importedMarkers);
    }

    public void importSignalsTableElements(TreeSet<WSignalsTableElement> importedSignalsTableElements) {
        if (!this.signalsTableElements.isEmpty()) {
            this.signalsTableElements.clear();
        }
        this.signalsTableElements.addAll(importedSignalsTableElements);
    }

    /*
     * Unable to fully structure code
     */
    public int comparePositionInSignalsTable(WSignalsTableElement element1, WSignalsTableElement element2) {
        elementParents1 = TreePath.parentsList(element1.getTreePath(), false);
        elementParents2 = TreePath.parentsList(element2.getTreePath(), false);
        if (elementParents1.contains(element2.getTreePath())) {
            return 1;
        }
        if (!elementParents2.contains(element1.getTreePath())) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            parent1 = elementParents1.remove(elementParents1.size() - 1);
            if (parent1.equals(parent2 = elementParents2.remove(elementParents2.size() - 1))) continue;
            parentElement1 = (WSignalsTableElement)parent1.getElement();
            parentElement2 = (WSignalsTableElement)parent2.getElement();
            return parentElement1.getId() - parentElement2.getId();
lbl12:
            // 2 sources

            ** while (!elementParents1.isEmpty() && !elementParents2.isEmpty())
        }
lbl13:
        // 1 sources

        if (!elementParents1.isEmpty()) {
            element1 = (WSignalsTableElement)elementParents1.remove(elementParents1.size() - 1).getElement();
        }
        if (!elementParents2.isEmpty()) {
            element2 = (WSignalsTableElement)elementParents2.remove(elementParents2.size() - 1).getElement();
        }
        return element1.getId() - element2.getId();
    }

    public List<TreePath> getAllSignalsTableTreePaths() {
        if (this.signalsTableElements == null || this.signalsTableElements.isEmpty()) {
            return null;
        }
        ArrayList<TreePath> allTreePaths = new ArrayList<TreePath>();
        for (WSignalsTableElement element : this.signalsTableElements) {
            if (element.getTreePath() != null) {
                allTreePaths.add(element.getTreePath());
            }
            if (!(element instanceof ISignalsTableExpandableElement)) continue;
            List<WSignalsTableElement> childElements = ((ISignalsTableExpandableElement)((Object)element)).getAllChildElementsInDepth();
            for (WSignalsTableElement childElement : childElements) {
                if (childElement.getTreePath() == null) continue;
                allTreePaths.add(childElement.getTreePath());
            }
        }
        return allTreePaths;
    }

    public List<TreePath> getSignalsTableTreePathsInBetween(WSignalsTableElement element1, WSignalsTableElement element2) {
        if (element1 == null || element2 == null) {
            return null;
        }
        int compareResult = this.comparePositionInSignalsTable(element1, element2);
        WSignalsTableElement lowIdElement = compareResult < 0 ? element1 : element2;
        WSignalsTableElement highIdElement = compareResult > 0 ? element1 : element2;
        boolean isHighFound = false;
        ArrayList<TreePath> treePathsInBetween = new ArrayList<TreePath>();
        WSignalsTableElement currentElement = lowIdElement;
        while (!isHighFound && currentElement != null) {
            treePathsInBetween.add(currentElement.getTreePath());
            if (currentElement.equals(highIdElement)) {
                isHighFound = true;
            }
            if (currentElement instanceof ISignalsTableExpandableElement) {
                List<WSignalsTableElement> childElements = ((ISignalsTableExpandableElement)((Object)currentElement)).getAllChildElementsInDepth();
                for (WSignalsTableElement childElement : childElements) {
                    if (childElement.getTreePath() == null) continue;
                    treePathsInBetween.add(childElement.getTreePath());
                    if (!childElement.equals(highIdElement)) continue;
                    isHighFound = true;
                }
                if (isHighFound) break;
            }
            currentElement = DVTVCDUtils.nextInTable(this.signalsTableElements, currentElement);
        }
        return treePathsInBetween;
    }

    public int getSignalsTableSize() {
        return this.signalsTableElements.size();
    }

    public void updateProviderModel() {
        this.updateProviderModelJob.cancel();
        this.updateProviderModelJob.schedule(200L);
    }

    public void updateTableValues() {
        this.updateSignalsTableValuesJob.cancel();
        this.updateSignalsTableValuesJob.schedule(200L);
    }

    public void renderAndUpdateTableValues() {
        this.canvas.getRenderer().render();
        this.updateTableValues();
        this.logDebugInfo();
    }

    public void updatePrimaryCursorAtFixedTime(long time) {
        this.primaryCursor.setFixedTime(time, this);
        this.renderAndUpdateTableValues();
        DVTVCDUtils.getInstance().updateLogViewerActionButton(this.canvas);
    }

    public void updatePrimaryCursor(int mouseX, int mouseY) {
        this.primaryCursor.setTime(mouseX, mouseY, this);
        this.renderAndUpdateTableValues();
        DVTVCDUtils.getInstance().updateLogViewerActionButton(this.canvas);
    }

    public WCursor getPrimaryCursor() {
        return this.primaryCursor;
    }

    public void updateSecondaryCursor(int mouseX, int mouseY) {
        this.secondaryCursor.setTime(mouseX, mouseY, this);
        this.canvas.getRenderer().render();
        DVTVCDUtils.getInstance().updateLogViewerActionButton(this.canvas);
        this.logDebugInfo();
    }

    public WCursor getSecondaryCursor() {
        return this.secondaryCursor;
    }

    public void removePrimaryCursor() {
        this.primaryCursor.removeCursor();
        this.canvas.getRenderer().render();
        DVTVCDUtils.getInstance().updateLogViewerActionButton(this.canvas);
        this.logDebugInfo();
    }

    public void removeSecondaryCursor() {
        this.secondaryCursor.removeCursor();
        this.canvas.getRenderer().render();
        DVTVCDUtils.getInstance().updateLogViewerActionButton(this.canvas);
        this.logDebugInfo();
    }

    public void setAllowPan(boolean allowPan) {
        this.allowPan = allowPan;
    }

    public boolean getAllowPan() {
        return this.allowPan;
    }

    public void updateSignalsTableValues(IProgressMonitor monitor) {
        long time = this.primaryCursor.getTime();
        if (time < 0L) {
            return;
        }
        DVTVCDParser canvasProvider = this.canvas.getProvider();
        if (canvasProvider == null) {
            return;
        }
        DVTVCDModel vcdModel = canvasProvider.getVcdModel();
        if (vcdModel == null) {
            return;
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = vcdModel.getSignalsByModelId();
        for (WSignalsTableElement signalsTableElement : this.signalsTableElements) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!(signalsTableElement instanceof WSignalsTableGroup)) continue;
            this.updateSignalsTableGroupValues((WSignalsTableGroup)signalsTableElement, variablesByID, time);
        }
        WaveViewerSignalTableView signalsTableView = this.canvas.getSignalsTableView();
        if (signalsTableView == null) {
            return;
        }
        signalsTableView.updateLabels(null);
    }

    private void updateSignalsTableGroupValues(WSignalsTableGroup signalsTableGroup, LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID, long time) {
        TreeSet<WSignalsTableElement> childElements = signalsTableGroup.getChildElements();
        for (WSignalsTableElement childElement : childElements) {
            if (!(childElement instanceof WSignalsTableSignal)) continue;
            this.updateSignalsTableSignalValue((WSignalsTableSignal)childElement, variablesByID, time);
        }
    }

    private void updateSignalsTableSignalValue(WSignalsTableSignal signalsTableSignal, LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID, long time) {
        DVTVCDSignalWrapper signalWrapper = variablesByID.get(signalsTableSignal.getVcdId());
        if (signalsTableSignal instanceof WSignalsTableSingleBitChildSignal && !signalWrapper.isChildOfNetArray()) {
            signalsTableSignal.setValueAtCursor(DVTVCDUtils.getValueAtIndex(((WSignalsTableSingleBitChildSignal)signalsTableSignal).getIndex(), DVTVCDUtils.getSignalValueAtTime(signalWrapper, time), Integer.parseInt(signalWrapper.getBitWidth()), signalWrapper.isBigEndian()));
        } else if (signalsTableSignal instanceof WSignalsTableMultiBitChildSignal) {
            signalsTableSignal.setValueAtCursor(DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableMultiBitChildSignal)signalsTableSignal).getStartIndex(), ((WSignalsTableMultiBitChildSignal)signalsTableSignal).getEndIndex(), DVTVCDUtils.getSignalValueAtTime(signalWrapper, time), Integer.parseInt(signalWrapper.getBitWidth())));
        } else if (signalsTableSignal instanceof WSignalsTableStructSignal) {
            signalsTableSignal.setValueAtCursor(DVTVCDUtils.getMultibitValueAtIndex(((WSignalsTableStructSignal)signalsTableSignal).getStartIndex(), ((WSignalsTableStructSignal)signalsTableSignal).getEndIndex(), DVTVCDUtils.getSignalValueAtTime(signalWrapper, time), Integer.parseInt(signalWrapper.getBitWidth())));
        } else {
            signalsTableSignal.setValueAtCursor(DVTVCDUtils.getSignalValueAtTime(signalWrapper, time));
        }
        if (signalsTableSignal instanceof ISignalsTableExpandableElement) {
            for (WSignalsTableElement childSignal : ((ISignalsTableExpandableElement)((Object)signalsTableSignal)).getChildElements()) {
                if (!(childSignal instanceof WSignalsTableSignal)) continue;
                this.updateSignalsTableSignalValue((WSignalsTableSignal)childSignal, variablesByID, time);
            }
        }
    }

    public List<WMarker> getMarkers() {
        return this.markers;
    }

    public void addMarker(long markerTime) {
        for (WMarker marker : this.markers) {
            if (marker.getTime() != markerTime) continue;
            return;
        }
        this.markers.add(new WMarker("T=" + markerTime + this.currentTimescale.getName(), markerTime));
        this.canvas.getRenderer().render();
    }

    public boolean isHitMarker(MouseEvent e) {
        int i = this.markers.size() - 1;
        while (i >= 0) {
            WMarker marker = this.markers.get(i);
            if (marker.isHit(e, this)) {
                this.markers.remove(i);
                this.canvas.getRenderer().render();
                return true;
            }
            --i;
        }
        return false;
    }

    public void panToTime(long time) {
        long centerTime = (this.getHighestVisibleTime() + this.getLowestVisibleTime()) / 2L;
        double dx = (double)(time - centerTime) * this.getTimeUnitSizeOnScreen();
        this.pan((long)dx);
        this.updateProviderModel();
    }

    public void logDebugInfo() {
        if (!DConstants.DEBUG) {
            return;
        }
        DDebug debug = this.canvas.getDebug();
        if (debug == null) {
            return;
        }
        debug.log("viewport/action/pan/pan_x", this.panX);
        debug.log("viewport/action/pan/pan_y", this.panY);
        debug.log("viewport/action/resize/canvas_width", this.canvasSize.width);
        debug.log("viewport/action/resize/canvas_height", this.canvasSize.height);
        debug.log("viewport/action/zoom/scale", this.scale);
        debug.log("viewport/action/zoom/time_unit_size_on_screen", this.timeUnitSizeOnScreen);
        debug.log("viewport/cursors/primary_cursor/name", this.primaryCursor.getName());
        debug.log("viewport/cursors/primary_cursor/time", this.primaryCursor.getTime());
        debug.log("viewport/cursors/secondary_cursor/name", this.secondaryCursor.getName());
        debug.log("viewport/cursors/secondary_cursor/time", this.secondaryCursor.getTime());
    }

    private void checkBoundariesAndUpdateSlider() {
        long lastTimeFromVcd = this.canvas.getProvider().getLastTimeFromVcd() + (long)this.getLastTimeOffset();
        long firstTimeFromVcd = this.canvas.getProvider().getFirstTimeFromVcd();
        if (this.lowestVisibleTime <= firstTimeFromVcd) {
            this.horizontalCanvasSlider.setEnableArrowButtons(false, false);
        } else {
            this.horizontalCanvasSlider.setEnableArrowButtons(false, true);
        }
        if (this.highestVisibleTime >= lastTimeFromVcd) {
            this.horizontalCanvasSlider.setEnableArrowButtons(true, false);
        } else {
            this.horizontalCanvasSlider.setEnableArrowButtons(true, true);
        }
        this.horizontalCanvasSlider.updateTimeIntervalLabelText();
    }

    public void setToolBarActionEnabled(Class<? extends IAction> actionClass, boolean enabled) {
        if (this.canvas == null || this.canvas.getSignalsTableView() == null) {
            return;
        }
        this.canvas.getSignalsTableView().setToolBarActionEnabled(actionClass, enabled);
    }

    public void setToolBarActionTooltip(Class<? extends IAction> actionClass, String tooltipText) {
        if (this.canvas == null || this.canvas.getSignalsTableView() == null) {
            return;
        }
        this.canvas.getSignalsTableView().setToolBarActionTooltip(actionClass, tooltipText);
    }

    public void testUpdateSecondaryCursorAtFixedTime(long time) {
        if (TestHelper.isTestMode()) {
            this.secondaryCursor.setFixedTime(time, this);
            this.canvas.getRenderer().render();
            this.logDebugInfo();
        }
    }

    public Job testGetUpdateProviderModelJob() {
        if (TestHelper.isTestMode()) {
            return this.updateProviderModelJob;
        }
        return null;
    }
}

