/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;

public abstract class WClickHandlerCommon {
    protected Map<Integer, MouseEvent> downEventsByMouseButton;
    protected boolean isMovingPrimaryCursor;
    protected boolean isMovingSecondaryCursor;
    protected boolean shouldRemovePrimaryCursor;
    protected boolean shouldRemoveSecondaryCursor;
    protected WCanvas canvas;

    protected WClickHandlerCommon(WCanvas canvas) {
        this.canvas = canvas;
        this.downEventsByMouseButton = new HashMap<Integer, MouseEvent>();
    }

    public void mouseDownAction(MouseEvent e) {
        this.downEventsByMouseButton.put(e.button, e);
        WViewport viewport = this.canvas.getViewport();
        this.shouldRemovePrimaryCursor = e.button == 3 && viewport.getPrimaryCursor().isHit(e, viewport);
        this.shouldRemoveSecondaryCursor = e.button == 3 && viewport.getSecondaryCursor().isHit(e, viewport);
        this.isMovingPrimaryCursor = e.button == 1 && viewport.getPrimaryCursor().isHit(e, viewport);
        boolean bl = this.isMovingSecondaryCursor = e.button == 1 && viewport.getSecondaryCursor().isHit(e, viewport);
        if (this.shouldRemovePrimaryCursor && this.shouldRemoveSecondaryCursor) {
            if (viewport.getCursorOnTop() == DVTVCDUtilsCommon.Cursors.PRIMARY) {
                this.shouldRemoveSecondaryCursor = false;
            } else {
                this.shouldRemovePrimaryCursor = false;
            }
        }
        if (this.isMovingPrimaryCursor && this.isMovingSecondaryCursor) {
            if (viewport.getCursorOnTop() == DVTVCDUtilsCommon.Cursors.PRIMARY) {
                this.isMovingSecondaryCursor = false;
            } else {
                this.isMovingPrimaryCursor = false;
            }
        }
        if (this.isMovingSecondaryCursor) {
            viewport.setCursorOnTop(DVTVCDUtilsCommon.Cursors.SECONDARY);
        } else {
            viewport.setCursorOnTop(DVTVCDUtilsCommon.Cursors.PRIMARY);
        }
        if (this.isMovingPrimaryCursor || this.isMovingSecondaryCursor) {
            viewport.setAllowPan(false);
        }
    }

    public void mouseUpAction(MouseEvent e) {
        if (e == null) {
            return;
        }
        WViewport viewport = this.canvas.getViewport();
        viewport.setAllowPan(true);
        if (this.isMovingPrimaryCursor) {
            this.isMovingPrimaryCursor = false;
            this.downEventsByMouseButton.remove(e.button);
            viewport.updatePrimaryCursor(e.x, e.y);
            return;
        }
        if (this.isMovingSecondaryCursor) {
            this.isMovingSecondaryCursor = false;
            this.downEventsByMouseButton.remove(e.button);
            viewport.updateSecondaryCursor(e.x, e.y);
            return;
        }
        if (this.isPanning(e)) {
            return;
        }
        this.downEventsByMouseButton.remove(e.button);
        if (e.button == 1) {
            viewport.updatePrimaryCursor(e.x, e.y);
            return;
        }
        if (e.button != 3) {
            return;
        }
        if (!this.shouldRemovePrimaryCursor && !this.shouldRemoveSecondaryCursor) {
            viewport.updateSecondaryCursor(e.x, e.y);
            return;
        }
        if (this.shouldRemovePrimaryCursor) {
            viewport.removePrimaryCursor();
            this.shouldRemovePrimaryCursor = false;
            this.shouldRemoveSecondaryCursor = false;
        }
        if (this.shouldRemoveSecondaryCursor) {
            viewport.removeSecondaryCursor();
            this.shouldRemoveSecondaryCursor = false;
        }
    }

    public void mouseMoveAction(MouseEvent e) {
        WViewport viewport = this.canvas.getViewport();
        if (this.isMovingPrimaryCursor) {
            viewport.updatePrimaryCursor(e.x, e.y);
        } else if (this.isMovingSecondaryCursor) {
            viewport.updateSecondaryCursor(e.x, e.y);
        }
    }

    public void mouseUpMarkerAction(MouseEvent e) {
        MouseEvent prevDownEvent = this.downEventsByMouseButton.get(e.button);
        this.downEventsByMouseButton.remove(e.button);
        if (this.isPanning(e)) {
            return;
        }
        WViewport viewport = this.canvas.getViewport();
        if (e.button != 2) {
            return;
        }
        if (viewport.isHitMarker(prevDownEvent)) {
            return;
        }
        int relativeTime = (int)((double)(e.x - viewport.getTimesTextXOffset()) / viewport.getTimeUnitSizeOnScreen());
        long clickedTime = viewport.getLowestVisibleTime() + (long)relativeTime;
        viewport.addMarker(clickedTime);
    }

    public void mouseDownMarkerAction(MouseEvent e) {
        this.downEventsByMouseButton.put(e.button, e);
    }

    protected abstract boolean isPanning(MouseEvent var1);
}

