/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WCtrlClickZoomHandler {
    private WCanvas canvas;
    private WViewport viewport;
    private long mouseDownTime;
    private long mouseCurrentTime;
    private boolean isZoomInProgress;
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
            try {
                if (!DVTVCDUtils.getInstance().hasLicense(WCtrlClickZoomHandler.this.canvas)) {
                    return;
                }
                if (!WCtrlClickZoomHandler.this.isZoomInProgress) {
                    return;
                }
                long mouseUpTime = DVTVCDUtils.computeTime(e.x - WCtrlClickZoomHandler.this.viewport.getTimesTextXOffset(), null, WCtrlClickZoomHandler.this.viewport, true);
                if (WCtrlClickZoomHandler.this.mouseDownTime == mouseUpTime) {
                    return;
                }
                long lowerTime = WCtrlClickZoomHandler.this.mouseDownTime < mouseUpTime ? WCtrlClickZoomHandler.this.mouseDownTime : mouseUpTime;
                long higherTime = WCtrlClickZoomHandler.this.mouseDownTime < mouseUpTime ? mouseUpTime : WCtrlClickZoomHandler.this.mouseDownTime;
                WCtrlClickZoomHandler.this.viewport.zoomToFitTimes(lowerTime, higherTime);
            }
            finally {
                WCtrlClickZoomHandler.this.reset();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WCtrlClickZoomHandler.this.canvas)) {
                return;
            }
            if ((e.stateMask & 0x40000) == 0) {
                return;
            }
            WCtrlClickZoomHandler.this.mouseDownTime = DVTVCDUtils.computeTime(e.x - WCtrlClickZoomHandler.this.viewport.getTimesTextXOffset(), null, WCtrlClickZoomHandler.this.viewport, true);
            WCtrlClickZoomHandler.this.isZoomInProgress = true;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private MouseMoveListener mouseMoveListener;
    private DisposeListener disposeListener;

    public WCtrlClickZoomHandler(WCanvas canvas) {
        this.canvas = canvas;
        this.viewport = canvas.getViewport();
        this.reset();
        this.mouseMoveListener = e -> {
            if (!this.isZoomInProgress) {
                return;
            }
            this.mouseCurrentTime = DVTVCDUtils.computeTime(e.x - this.viewport.getTimesTextXOffset(), null, this.viewport, true);
            canvas.getRenderer().render();
        };
        this.disposeListener = e -> {
            this.canvas.removeMouseListener(this.mouseListener);
            this.canvas.removeMouseMoveListener(this.mouseMoveListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addMouseListener(this.mouseListener);
        this.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }

    private void reset() {
        this.mouseDownTime = -1L;
        this.mouseCurrentTime = -1L;
        this.isZoomInProgress = false;
    }

    public long getMouseDownTime() {
        return this.mouseDownTime;
    }

    public long getCurrentMouseTime() {
        return this.mouseCurrentTime;
    }

    public boolean isZoomInProgress() {
        return this.isZoomInProgress;
    }
}

