/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WClickHandlerCommon;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WCursorsHandler
extends WClickHandlerCommon {
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WCursorsHandler.this.canvas)) {
                return;
            }
            WCursorsHandler.this.mouseUpAction(e);
        }

        public void mouseDown(MouseEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WCursorsHandler.this.canvas)) {
                return;
            }
            WCursorsHandler.this.mouseDownAction(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private final MouseMoveListener mouseMoveListener = e -> this.mouseMoveAction(e);
    private DisposeListener disposeListener = e -> {
        this.canvas.removeMouseListener(this.mouseListener);
        this.canvas.removeMouseMoveListener(this.mouseMoveListener);
        this.canvas.removeDisposeListener(this.disposeListener);
    };

    public WCursorsHandler(WCanvas canvas) {
        super(canvas);
        this.canvas.addMouseListener(this.mouseListener);
        this.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }

    @Override
    protected boolean isPanning(MouseEvent e) {
        if (e.button != 1) {
            return false;
        }
        MouseEvent leftClickDownEvent = (MouseEvent)this.downEventsByMouseButton.get(e.button);
        if (leftClickDownEvent == null) {
            return false;
        }
        return Math.abs(e.x - leftClickDownEvent.x) >= 10 || Math.abs(e.y - leftClickDownEvent.y) >= 10;
    }
}

