/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import java.util.Set;
import org.eclipse.swt.events.MouseEvent;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WClickEvent;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WClickListener;
import ro.amiq.dvt.draw.debug.DDebug;

public class WMouseEventProcessor
implements Runnable {
    private final MouseEvent mouseEvent;
    private final Set<WClickListener> listeners;
    private final DDebug debug;

    public WMouseEventProcessor(MouseEvent mouseEvent, Set<WClickListener> listeners, DDebug debug) {
        this.mouseEvent = mouseEvent;
        this.listeners = listeners;
        this.debug = debug;
    }

    @Override
    public void run() {
        if (DConstants.DEBUG) {
            this.debug.startTimer("mouse/hit/time/detection");
        }
        this.detectHit();
        if (DConstants.DEBUG) {
            this.debug.endTimer("mouse/hit/time/detection");
        }
        WClickEvent event = new WClickEvent(this.mouseEvent);
        if (DConstants.DEBUG) {
            this.debug.startTimer("mouse/hit/time/listeners");
        }
        for (WClickListener listener : this.listeners) {
            listener.handleEvent(event);
        }
        if (DConstants.DEBUG) {
            this.debug.endTimer("mouse/hit/time/listeners");
        }
    }

    protected boolean detectHit() {
        return true;
    }
}

