/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseWheelListener;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WMouseWheelHandler {
    private final WCanvas canvas;
    private final MouseWheelListener mouseWheelListener;
    private DisposeListener disposeListener;

    public WMouseWheelHandler(WCanvas canvas) {
        this.canvas = canvas;
        this.mouseWheelListener = e -> {
            if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
                return;
            }
            WViewport viewport = this.canvas.getViewport();
            if ((e.stateMask & 0x40000) == 0) {
                WaveViewerSignalTableView signalsTableView = canvas.getSignalsTableView();
                signalsTableView.scroll(e.count);
            } else {
                viewport.zoomIncrementedScaleAboutPoint(Integer.signum(e.count), e.x);
                viewport.updateProviderModel();
            }
        };
        this.disposeListener = e -> {
            this.canvas.removeMouseWheelListener(this.mouseWheelListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addMouseWheelListener(this.mouseWheelListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }
}

