/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import ro.amiq.dvt.diagrams.preferences.DiagramPreferenceAdapter;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WPanHandler {
    private final WCanvas canvas;
    private final Cursor[] cursors;
    private boolean inProgress;
    private int prevX;
    private final MouseListener mouseListener = new MouseListener(){
        private long lowestVisibleTime;
        private long highestVisibleTime;

        public void mouseDown(MouseEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WPanHandler.this.canvas)) {
                return;
            }
            if ((e.stateMask & 0x40000) != 0) {
                return;
            }
            if (e.button == 1) {
                WPanHandler.this.inProgress = true;
                WPanHandler.this.prevX = e.x;
                WViewport viewport = WPanHandler.this.canvas.getViewport();
                this.lowestVisibleTime = viewport.getLowestVisibleTime();
                this.highestVisibleTime = viewport.getHighestVisibleTime();
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WPanHandler.this.canvas)) {
                return;
            }
            if (e.button == 1) {
                WPanHandler.this.setHandCursor(false);
                WPanHandler.this.inProgress = false;
                WViewport viewport = WPanHandler.this.canvas.getViewport();
                long currentLowestVisibleTime = viewport.getLowestVisibleTime();
                long currentHighestVisibleTime = viewport.getHighestVisibleTime();
                if (currentLowestVisibleTime == this.lowestVisibleTime && currentHighestVisibleTime == this.highestVisibleTime) {
                    return;
                }
                WPanHandler.this.canvas.getViewport().updateProviderModel();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private final KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WPanHandler.this.canvas)) {
                return;
            }
            if (e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
                return;
            }
            boolean reverse = DiagramPreferenceAdapter.getInstance().getDiagramReverseArrows();
            WViewport viewport = WPanHandler.this.canvas.getViewport();
            if (e.keyCode == (reverse ? 0x1000004 : 0x1000003)) {
                viewport.pan(-50L);
            }
            if (e.keyCode == (reverse ? 0x1000003 : 0x1000004)) {
                viewport.pan(50L);
            }
            viewport.updateProviderModel();
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private final MouseMoveListener mouseMoveListener;
    private DisposeListener disposeListener;

    public WPanHandler(WCanvas canvas) {
        this.canvas = canvas;
        this.cursors = new Cursor[]{new Cursor((Device)this.canvas.getDisplay(), 0), new Cursor((Device)this.canvas.getDisplay(), 21)};
        this.mouseMoveListener = e -> {
            if (this.inProgress) {
                this.setHandCursor(true);
                WViewport viewport = this.canvas.getViewport();
                viewport.pan((long)this.prevX - (long)e.x);
                this.prevX = e.x;
            }
        };
        this.disposeListener = e -> {
            Cursor[] cursorArray = this.cursors;
            int n = this.cursors.length;
            int n2 = 0;
            while (n2 < n) {
                Cursor cursor = cursorArray[n2];
                if (cursor != null && !cursor.isDisposed()) {
                    cursor.dispose();
                }
                ++n2;
            }
            this.canvas.removeMouseListener(this.mouseListener);
            this.canvas.removeMouseMoveListener(this.mouseMoveListener);
            this.canvas.removeKeyListener(this.keyListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addMouseListener(this.mouseListener);
        this.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.canvas.addKeyListener(this.keyListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }

    private void setHandCursor(boolean enabled) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setCursor(enabled ? this.cursors[1] : this.cursors[0]);
        }
    }
}

