/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.handlers;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WResizeHandler {
    private final WCanvas canvas;
    private final ControlListener controlListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            if (!DVTVCDUtils.getInstance().hasLicense(WResizeHandler.this.canvas)) {
                return;
            }
            WViewport viewport = WResizeHandler.this.canvas.getViewport();
            Rectangle prevCanvasSize = viewport.getCanvasSize();
            viewport.setCanvasSize(WResizeHandler.this.canvas.getClientArea());
            if (prevCanvasSize.width != WResizeHandler.this.canvas.getClientArea().width) {
                viewport.updateProviderModel();
            }
        }

        public void controlMoved(ControlEvent e) {
        }
    };
    private DisposeListener disposeListener;

    public WResizeHandler(WCanvas canvas) {
        this.canvas = canvas;
        this.disposeListener = e -> {
            this.canvas.removeControlListener(this.controlListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addControlListener(this.controlListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }
}

