/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import org.eclipse.swt.graphics.FontData;
import ro.amiq.dvt.draw.obj.primitive.DHeadOpenArrow;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WDCursorsDeltaTime {
    private DLine horizontalLine;
    private DHeadOpenArrow lowerCursorArrow;
    private DHeadOpenArrow higherCursorArrow;
    private DText lowerCursorText;
    private DText higherCursorText;
    private DText deltaTimeText;

    public WDCursorsDeltaTime(int lowerTimeX, int higherTimeX, int hLineY, int minX, int maxX, String lowerCursorName, String higherCursorName, String deltaTimeString) {
        int deltaTimeStringWidth;
        this.horizontalLine = new DLine(new int[]{lowerTimeX, hLineY, higherTimeX, hLineY});
        this.horizontalLine.setLineColor(DVTVCDUtils.WHITE);
        if (lowerTimeX + 8 >= higherTimeX - 8) {
            return;
        }
        this.lowerCursorArrow = new DHeadOpenArrow(8, lowerTimeX, hLineY, lowerTimeX + 1, hLineY);
        this.lowerCursorArrow.setLineColor(DVTVCDUtils.WHITE);
        this.higherCursorArrow = new DHeadOpenArrow(8, higherTimeX, hLineY, higherTimeX, hLineY);
        this.higherCursorArrow.setLineColor(DVTVCDUtils.WHITE);
        FontData fontData = DVTVCDUtils.getFontData();
        if (lowerTimeX == minX) {
            this.lowerCursorText = new DText(lowerCursorName, minX + 4, hLineY - 15, fontData);
            this.lowerCursorText.setTextColor(DVTVCDUtils.WHITE);
        }
        if (higherTimeX == maxX) {
            this.higherCursorText = new DText(higherCursorName, maxX - 16, hLineY - 15, fontData);
            this.higherCursorText.setTextColor(DVTVCDUtils.WHITE);
        }
        if ((deltaTimeStringWidth = deltaTimeString.length() * 7) + 4 > higherTimeX - lowerTimeX) {
            return;
        }
        int deltaTimeTextX = (lowerTimeX + higherTimeX + 4 - deltaTimeStringWidth) / 2;
        int deltaTimeTextY = hLineY - 12;
        this.deltaTimeText = new DText(deltaTimeString, deltaTimeTextX, deltaTimeTextY, fontData);
        this.deltaTimeText.setTextColor(DVTVCDUtils.WHITE);
    }

    public void paint(DContext dc) {
        this.horizontalLine.paint(dc);
        if (this.lowerCursorArrow != null) {
            this.lowerCursorArrow.paint(dc);
        }
        if (this.higherCursorArrow != null) {
            this.higherCursorArrow.paint(dc);
        }
        if (this.lowerCursorText != null) {
            this.lowerCursorText.paint(dc);
        }
        if (this.higherCursorText != null) {
            this.higherCursorText.paint(dc);
        }
        if (this.deltaTimeText != null) {
            this.deltaTimeText.paint(dc);
        }
    }
}

