/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModel;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WaveViewerGenerationError;

public class WDGenerationErrorModel
implements IWDModel {
    private static final String DIAGRAM_GENERATION_FAILED = "Waveform Viewer could not be opened!";
    private DRectangle canvasBackground;
    private List<DText> errorTextList;

    public WDGenerationErrorModel(WCanvas canvas, Set<WaveViewerGenerationError> generationErrors) {
        this.canvasBackground = this.computeCanvasBackground(canvas);
        this.errorTextList = this.computeErrorTextList(generationErrors, canvas);
    }

    private DRectangle computeCanvasBackground(WCanvas canvas) {
        Point canvasSize = canvas.getSize();
        DRectangle canvasBackground = new DRectangle(0, 0, canvasSize.x, canvasSize.y);
        canvasBackground.setFillColor(DVTVCDUtils.BLACK);
        return canvasBackground;
    }

    private List<DText> computeErrorTextList(Set<WaveViewerGenerationError> generationErrors, WCanvas canvas) {
        ArrayList<DText> errTextList = new ArrayList<DText>();
        Point canvasSize = canvas.getSize();
        if (generationErrors.contains((Object)WaveViewerGenerationError.LICENSE_NOT_AVAILABLE)) {
            String errorMessage = WaveViewerGenerationError.LICENSE_NOT_AVAILABLE.getErrorMessage();
            String[] messageParts = errorMessage.split(System.lineSeparator());
            int i = 0;
            while (i < messageParts.length) {
                errTextList.add(this.computeErrorText(messageParts[i], canvasSize.x, i + 1));
                ++i;
            }
            return errTextList;
        }
        int idx = 1;
        errTextList.add(this.computeErrorText(DIAGRAM_GENERATION_FAILED, canvasSize.x, idx));
        for (WaveViewerGenerationError generationError : generationErrors) {
            errTextList.add(this.computeErrorText(generationError.getErrorMessage(), canvasSize.x, ++idx));
        }
        return errTextList;
    }

    private DText computeErrorText(String errorMessage, int canvasWidth, int idx) {
        FontData fontData = FontFactory.getInstance().getFontData("Sans", 20, 0);
        Point errorTextExtent = FontFactory.getInstance().stringExtent(errorMessage, fontData);
        DText errorText = new DText(errorMessage, (canvasWidth - errorTextExtent.x) / 2, idx * errorTextExtent.y, fontData);
        errorText.setTextColor(DVTVCDUtils.WHITE);
        return errorText;
    }

    @Override
    public void paint(DContext dc) {
        this.canvasBackground.paint(dc);
        for (DText errorText : this.errorTextList) {
            errorText.paint(dc);
        }
    }

    @Override
    public DRectangle getCanvasBackground() {
        return this.canvasBackground;
    }
}

