/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDModelCommon;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDWave;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.LatestTaskOnlyScheduler;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WDModel
extends WDModelCommon {
    public WDModel(WCanvas canvas, Set<String> visibleSignals, LatestTaskOnlyScheduler latestOnlyScheduler) {
        super(canvas, visibleSignals, latestOnlyScheduler);
    }

    @Override
    protected List<WDWave> computeWaves() {
        WaveViewerSignalTableView signalsTableView = this.canvas.getSignalsTableView();
        if (signalsTableView == null) {
            return Collections.emptyList();
        }
        LazyTree lazyTree = signalsTableView.getLazyTree();
        if (lazyTree == null) {
            return Collections.emptyList();
        }
        List<TreePath> viewContent = lazyTree.getViewContent();
        if (viewContent == null || viewContent.isEmpty()) {
            return Collections.emptyList();
        }
        DVTVCDParser provider = this.canvas.getProvider();
        if (provider == null) {
            return Collections.emptyList();
        }
        DVTVCDModel vcdModel = provider.getVcdModel();
        if (vcdModel == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> signalsByID = vcdModel.getSignalsByModelId();
        if (signalsByID == null || signalsByID.isEmpty()) {
            return Collections.emptyList();
        }
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return Collections.emptyList();
        }
        ArrayList<WDWave> waves = new ArrayList<WDWave>();
        int wavesStartX = viewport.getTimesTextXOffset();
        int wavesEndX = viewport.getMaxXToDrawAt();
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        long highestVisibleTime = viewport.getHighestVisibleTime();
        double timeUnitsSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        int wavesLength = wavesEndX - wavesStartX;
        int wavesStartY = this.canvas.getSelectedSignalsTableHeight() + this.canvas.getSignalsTableSearchBarHeight() - this.canvas.getHorizontalSliderHeight();
        int wavesEndY = this.canvas.getSize().y;
        int waveY = wavesStartY;
        String firstVisibleId = null;
        String lastVisibleId = null;
        HashSet<String> currentSignals = new HashSet<String>();
        for (TreePath nodeTreePath : viewContent) {
            Iterator<TreePath> nodeElement;
            if (waveY > wavesEndY) break;
            if (nodeTreePath == null || !((nodeElement = nodeTreePath.getElement()) instanceof WSignalsTableElement)) continue;
            WSignalsTableElement signalsTableElement = (WSignalsTableElement)((Object)nodeElement);
            int waveHeight = DVTVCDUtils.getInstance().getTreeItemHeight(lazyTree);
            if (signalsTableElement instanceof WSignalsTableGroup || signalsTableElement instanceof WSignalsTableSeparator) {
                waveY += waveHeight;
                continue;
            }
            if (!(signalsTableElement instanceof WSignalsTableSignal)) continue;
            WSignalsTableSignal signalsTableSignal = (WSignalsTableSignal)signalsTableElement;
            if (firstVisibleId == null) {
                firstVisibleId = signalsTableSignal.getVcdId();
            }
            lastVisibleId = signalsTableSignal.getVcdId();
            if (signalsTableSignal instanceof WSignalsTableSingleBitChildSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableSingleBitChildSignal)signalsTableSignal).getIndex());
            } else if (signalsTableSignal instanceof WSignalsTableMultiBitChildSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableMultiBitChildSignal)signalsTableSignal).getStartIndex() + " " + ((WSignalsTableMultiBitChildSignal)signalsTableSignal).getEndIndex());
            } else if (signalsTableSignal instanceof WSignalsTableStructSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableStructSignal)signalsTableSignal).getStartIndex() + " " + ((WSignalsTableStructSignal)signalsTableSignal).getEndIndex());
            }
            currentSignals.add(lastVisibleId);
            waveY += waveHeight;
        }
        Map signalValuesByTime = currentSignals.parallelStream().collect(Collectors.toConcurrentMap(signalId -> signalId, signalId -> {
            String[] signalIdAndIndex = signalId.trim().split(" ");
            String actualSignalId = signalIdAndIndex[0];
            DVTVCDSignalWrapper signalWrapper = (DVTVCDSignalWrapper)signalsByID.get(actualSignalId);
            if (signalWrapper.getBitWidth().equals("1")) {
                return this.computeSingleBitSignalValuesByTime(signalWrapper, lowestVisibleTime, highestVisibleTime, timeUnitsSizeOnScreen);
            }
            if (signalIdAndIndex.length > 1) {
                if (signalIdAndIndex.length > 2) {
                    return this.computeMultiBitChildSignal(signalWrapper, lowestVisibleTime, highestVisibleTime, timeUnitsSizeOnScreen, Integer.parseInt(signalIdAndIndex[1]), Integer.parseInt(signalIdAndIndex[2]));
                }
                return this.computeSingleBitChildSignal(signalWrapper, lowestVisibleTime, highestVisibleTime, timeUnitsSizeOnScreen, Integer.parseInt(signalIdAndIndex[1]));
            }
            return this.computeMultiBitSignalValuesByTime(signalWrapper, lowestVisibleTime, highestVisibleTime, timeUnitsSizeOnScreen);
        }));
        waveY = wavesStartY;
        for (TreePath nodeTreePath : viewContent) {
            Object nodeElement;
            if (waveY > wavesEndY) break;
            if (nodeTreePath == null || !((nodeElement = nodeTreePath.getElement()) instanceof WSignalsTableElement)) continue;
            WSignalsTableElement signalsTableElement = (WSignalsTableElement)nodeElement;
            int waveHeight = DVTVCDUtils.getInstance().getTreeItemHeight(lazyTree);
            if (signalsTableElement instanceof WSignalsTableGroup || signalsTableElement instanceof WSignalsTableSeparator) {
                waves.add(this.computeWDWave(wavesStartX, waveY, wavesLength, waveHeight, signalsTableElement));
                waveY += waveHeight;
                continue;
            }
            if (!(signalsTableElement instanceof WSignalsTableSignal)) continue;
            WSignalsTableSignal signalsTableSignal = (WSignalsTableSignal)signalsTableElement;
            signalsTableSignal.setWaveHeight(waveHeight);
            signalsTableSignal.setWaveY(waveY);
            if (firstVisibleId == null) {
                firstVisibleId = signalsTableSignal.getVcdId();
            }
            lastVisibleId = signalsTableSignal.getVcdId();
            if (signalsTableSignal instanceof WSignalsTableSingleBitChildSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableSingleBitChildSignal)signalsTableSignal).getIndex());
            } else if (signalsTableSignal instanceof WSignalsTableMultiBitChildSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableMultiBitChildSignal)signalsTableSignal).getStartIndex() + " " + ((WSignalsTableMultiBitChildSignal)signalsTableSignal).getEndIndex());
            } else if (signalsTableSignal instanceof WSignalsTableStructSignal) {
                lastVisibleId = lastVisibleId.concat(" " + ((WSignalsTableStructSignal)signalsTableSignal).getStartIndex() + " " + ((WSignalsTableStructSignal)signalsTableSignal).getEndIndex());
            }
            if (signalsTableSignal instanceof WSignalsTableSingleBitSignal) {
                waves.add(this.computeSingleBitWave(wavesStartX, waveY, wavesLength, waveHeight, (WSignalsTableSingleBitSignal)signalsTableSignal, viewport, (TreeMap)signalValuesByTime.get(lastVisibleId)));
            } else if (signalsTableSignal instanceof WSignalsTableStructSignal) {
                waves.add(this.computeMultiBitWave(wavesStartX, waveY, wavesLength, waveHeight, (WSignalsTableMultiBitSignal)signalsTableSignal, viewport, (TreeMap)signalValuesByTime.get(lastVisibleId)));
            } else if (signalsTableSignal instanceof WSignalsTableMultiBitSignal) {
                waves.add(this.computeMultiBitWave(wavesStartX, waveY, wavesLength, waveHeight, (WSignalsTableMultiBitSignal)signalsTableSignal, viewport, (TreeMap)signalValuesByTime.get(lastVisibleId)));
            }
            waveY += waveHeight;
        }
        if (provider instanceof FSTReader) {
            FSTReader fstReader = (FSTReader)this.canvas.getProvider();
            if (!fstReader.needsRefresh()) {
                if (this.visibleSignals.containsAll(currentSignals)) {
                    return waves;
                }
            } else {
                fstReader.setRefresh(false);
            }
            this.visibleSignals = currentSignals;
            String startId = firstVisibleId;
            if (lastVisibleId == null) {
                return waves;
            }
            String endId = lastVisibleId.trim().split(" ")[0];
            Runnable task = () -> {
                DVTVCDParser dVTVCDParser2 = provider;
                synchronized (dVTVCDParser2) {
                    fstReader.setBounds(startId, endId, signalsTableView.getAllSignalsTableTreePaths());
                    viewport.getCanvas().getRenderer().renderOnFstRead();
                }
            };
            this.latestOnlyScheduler.submit(task);
        }
        return waves;
    }
}

