/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WMarker;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModel;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDCursor;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDCursorsDeltaTime;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDMarker;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDMultiBitWave;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDSignalWave;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDSingleBitWave;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDTimeAxis;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDWave;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.LatestTaskOnlyScheduler;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public abstract class WDModelCommon
implements IWDModel {
    protected WCanvas canvas;
    private DRectangle canvasBackground;
    private DRectangle zoomSelectionHighlight;
    private WDTimeAxis timeAxis;
    private List<WDWave> waves;
    private List<WDMarker> markers;
    private List<WDCursor> cursors;
    private WDCursorsDeltaTime cursorsDeltaTime;
    protected Set<String> visibleSignals;
    protected LatestTaskOnlyScheduler latestOnlyScheduler;

    protected WDModelCommon(WCanvas canvas, Set<String> visibleSignals, LatestTaskOnlyScheduler latestOnlyScheduler) {
        this.canvas = canvas;
        this.visibleSignals = visibleSignals;
        this.latestOnlyScheduler = latestOnlyScheduler;
        this.canvasBackground = this.computeCanvasBackground();
        this.zoomSelectionHighlight = this.computeZoomSelectionHighlight();
        this.timeAxis = this.computeTimeAxis();
        this.waves = this.computeWaves();
        this.markers = this.computeMarkers();
        this.cursors = this.computeCursors();
        this.cursorsDeltaTime = this.computeCursorsDeltaTime();
    }

    private DRectangle computeCanvasBackground() {
        Point canvasSize = this.canvas.getSize();
        DRectangle canvasBackground = new DRectangle(0, 0, canvasSize.x, canvasSize.y);
        canvasBackground.setFillColor(DVTVCDUtils.BLACK);
        return canvasBackground;
    }

    private WDTimeAxis computeTimeAxis() {
        long lowestVisibleTime;
        int xOffest;
        WViewport viewport = this.canvas.getViewport();
        int x = xOffest = viewport.getTimesTextXOffset();
        int y = this.canvas.getSelectedSignalsTableHeight() / 2;
        int maxX = viewport.getMaxXToDrawAt();
        WDTimeAxis timeAxis = new WDTimeAxis(x, y, maxX, y);
        DVTVCDUtilsCommon.TimeScales timescale = viewport.getTimescale();
        long time = lowestVisibleTime = viewport.getLowestVisibleTime();
        Point canvasSize = this.canvas.getSize();
        DText startTimeAxisLabel = timeAxis.addTimeAxisLabel(x, y, canvasSize.y, time, timescale).getLabel();
        DText endTimeAxisLabel = timeAxis.addEndTimeAxisLabel(maxX, y, viewport.getHighestVisibleTime() + 1L, timescale).getLabel();
        long timeAxisLabelInterval = viewport.getTimeLabelInterval();
        long timeAxisMarkingInterval = timeAxisLabelInterval / 10L;
        long timeUntilNextMarking = 1L;
        if (timeAxisMarkingInterval != 0L) {
            timeUntilNextMarking = timeAxisMarkingInterval - time % timeAxisMarkingInterval;
        }
        time += timeUntilNextMarking;
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        if (timeUnitSizeOnScreen > 2.147483647E9) {
            return timeAxis;
        }
        int prevX = x = this.computeTimeRelativeX(time, lowestVisibleTime, timeUnitSizeOnScreen, xOffest);
        while (x < maxX && x > 0 && time >= 0L) {
            if (timeAxisMarkingInterval > 0L && time % timeAxisLabelInterval != 0L) {
                timeAxis.addTimeAxisMarking(x, y, y / 2);
            } else if (x <= startTimeAxisLabel.computeBounds().width + xOffest) {
                timeAxis.addTimeAxisMarking(x, y, canvasSize.y);
            } else if (x + DVTVCDUtils.getLabelWidth(time, timescale) >= endTimeAxisLabel.computeBounds().x) {
                timeAxis.addTimeAxisMarking(x, y, canvasSize.y);
            } else {
                timeAxis.addTimeAxisLabel(x, y, canvasSize.y, time, timescale);
            }
            x = this.computeTimeRelativeX(time += timeAxisMarkingInterval > 0L ? timeAxisMarkingInterval : 1L, lowestVisibleTime, timeUnitSizeOnScreen, xOffest);
            if (prevX != x) continue;
            return timeAxis;
        }
        return timeAxis;
    }

    @Override
    public Set<String> getVisibleSignals() {
        return this.visibleSignals;
    }

    protected WDWave computeWDWave(int waveX, int waveY, int waveMaxLength, int waveHeight, WSignalsTableElement signalsTableElement) {
        String waveName = signalsTableElement.getName();
        DRectangle waveBackground = this.computeWaveBackground(waveX, waveY, waveMaxLength, waveHeight, signalsTableElement);
        return new WDWave(waveName, waveBackground);
    }

    protected abstract List<WDWave> computeWaves();

    protected WDSingleBitWave computeSingleBitWave(int waveX, int waveY, int waveMaxLength, int waveHeight, WSignalsTableSingleBitSignal signalsTableSingleBitSignal, WViewport viewport, TreeMap<Long, String> signalValuesByTime) {
        int y1;
        int x1;
        String waveName = signalsTableSingleBitSignal.getName();
        DLine waveGridLine = this.computeWaveGridLine(waveX, waveY, waveHeight, waveMaxLength);
        DRectangle waveBackground = this.computeWaveBackground(waveX, waveY, waveMaxLength, waveHeight, signalsTableSingleBitSignal);
        WDSingleBitWave wave = new WDSingleBitWave(waveName, waveGridLine, waveBackground);
        if (signalValuesByTime.isEmpty()) {
            return wave;
        }
        int waveHighY = waveY + 5;
        int waveLowY = waveY + waveHeight - 2;
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        Set<Long> timeStamps = signalValuesByTime.keySet();
        Iterator<Long> iterator = timeStamps.iterator();
        Long firstTimeStamp = iterator.next();
        String firstSignalValue = signalValuesByTime.get(firstTimeStamp);
        RGB waveColor = signalsTableSingleBitSignal.getWaveColor();
        RGB line1Color = DVTVCDUtils.RED;
        RGB line2Color = DVTVCDUtils.RED;
        int optimizedElementX = -100;
        RGB optimizedElementColor = DVTVCDUtils.RED;
        int optimizedElementHeight = waveLowY - waveHighY;
        Long prevTimeStamp = firstTimeStamp;
        String prevSignalValue = firstSignalValue;
        if (prevSignalValue.equals("DVT_WAVE_OPTIM_START")) {
            optimizedElementX = waveX;
            optimizedElementColor = waveColor;
        }
        while (iterator.hasNext()) {
            Long currentTimeStamp = iterator.next();
            String currentSignalValue = signalValuesByTime.get(currentTimeStamp);
            x1 = this.computeTimeRelativeX(prevTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
            y1 = this.computeSingleBitWavePointY(prevSignalValue, waveLowY, waveHighY);
            line1Color = this.computeWaveElementColor(prevSignalValue, waveColor);
            int x2 = this.computeTimeRelativeX(currentTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
            int y2 = this.computeSingleBitWavePointY(currentSignalValue, waveLowY, waveHighY);
            line2Color = this.computeWaveElementColor(currentSignalValue, waveColor);
            if (currentSignalValue.equals("DVT_WAVE_OPTIM_START")) {
                if (x2 - x1 >= 3 || line1Color != line2Color) {
                    optimizedElementX = x2;
                }
                optimizedElementColor = line2Color;
                if (prevSignalValue.equals("DVT_WAVE_OPTIM_START")) continue;
                prevTimeStamp = currentTimeStamp;
                prevSignalValue = currentSignalValue;
                wave.addLineElement(x1, y1, x2, y1, line1Color);
                continue;
            }
            if (currentSignalValue.startsWith("DVT_WAVE_OPTIM_END")) {
                optimizedElementX = -100;
                wave.addOptimizedElement(x1, waveHighY, x2 - x1, optimizedElementHeight, optimizedElementColor);
                prevTimeStamp = currentTimeStamp;
                prevSignalValue = currentSignalValue;
                continue;
            }
            wave.addLineElement(x1, y1, x2, y1, line1Color);
            wave.addLineElement(x2, y1, x2, y2, line2Color);
            prevTimeStamp = currentTimeStamp;
            prevSignalValue = currentSignalValue;
        }
        x1 = this.computeTimeRelativeX(prevTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
        y1 = this.computeSingleBitWavePointY(prevSignalValue, waveLowY, waveHighY);
        line1Color = this.computeWaveElementColor(prevSignalValue, waveColor);
        if (optimizedElementX != -100) {
            wave.addOptimizedElement(optimizedElementX, waveHighY, x1 - optimizedElementX, optimizedElementHeight, optimizedElementColor);
        }
        int highestParsedTimeX = this.computeTimeRelativeX(viewport.getHighestVisibleTime(), lowestVisibleTime, timeUnitSizeOnScreen, waveX);
        wave.addLineElement(x1, y1, highestParsedTimeX, y1, line1Color);
        int waveMaxX = viewport.getMaxXToDrawAt();
        if (highestParsedTimeX < waveMaxX) {
            wave.addLineElement(highestParsedTimeX, y1, waveMaxX, y1, line1Color);
        }
        return wave;
    }

    public TreeMap<Long, String> computeSingleBitSignalValuesByTime(DVTVCDSignalWrapper vcdSignalWrapper, long lowestVisibleTime, long highestVisibleTime, double timeUnitSizeOnScreen) {
        Iterator<DVTVCDVarModificationByTime> signalModifsIterator;
        TreeMap<Long, Object> compressedSignalValuesByTime = new TreeMap<Long, Object>();
        String valueAtTimeZero = vcdSignalWrapper.getValueAtTimeZero();
        if (valueAtTimeZero != null && !valueAtTimeZero.isEmpty()) {
            compressedSignalValuesByTime.put(0L, valueAtTimeZero);
        }
        TreeMap<Long, String> signalValuesByTime = new TreeMap<Long, String>();
        if (this.canvas.getProvider() instanceof FSTReader) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = vcdSignalWrapper.getVarModifsFromFST();
            if (varModifsFromFST == null) {
                return signalValuesByTime;
            }
            varModifsFromFST.setStartTime((int)lowestVisibleTime);
            signalModifsIterator = varModifsFromFST.iterator();
        } else {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> signalModificationByTime = vcdSignalWrapper.getVarModificationByTime();
            signalModifsIterator = signalModificationByTime.iterator();
        }
        while (signalModifsIterator.hasNext()) {
            DVTVCDVarModificationByTime signalModif = signalModifsIterator.next();
            long signalModifTime = signalModif.getTime();
            if (signalModifTime > highestVisibleTime) break;
            String signalModifValue = signalModif.getValue();
            compressedSignalValuesByTime.put(signalModifTime, signalModifValue);
        }
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = vcdSignalWrapper.getClockInfoByStartTimes();
        compressedSignalValuesByTime.putAll(clockInfoByStartTimes);
        Set timeStamps = compressedSignalValuesByTime.keySet();
        Iterator timeStampsIterator = timeStamps.iterator();
        if (!timeStampsIterator.hasNext()) {
            return signalValuesByTime;
        }
        Long lastTimeStamp = (Long)timeStampsIterator.next();
        Object lastValue = compressedSignalValuesByTime.get(lastTimeStamp);
        while (timeStampsIterator.hasNext()) {
            timeStampsIterator.remove();
            Long currentTimeStamp = (Long)timeStampsIterator.next();
            if (currentTimeStamp >= lowestVisibleTime) break;
            lastTimeStamp = currentTimeStamp;
            lastValue = compressedSignalValuesByTime.get(currentTimeStamp);
        }
        if (lastTimeStamp != null && lastValue != null) {
            compressedSignalValuesByTime.put(lastTimeStamp, lastValue);
        }
        Long prevTimeStamp = -1000000L;
        String prevValue = null;
        boolean isOptimizing = false;
        for (Map.Entry entry : compressedSignalValuesByTime.entrySet()) {
            Long timeStamp = (Long)entry.getKey();
            Object signalValue = entry.getValue();
            if (timeStamp > highestVisibleTime) {
                if (!isOptimizing) break;
                signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + (String)prevValue);
                break;
            }
            if (signalValue instanceof DVTVCDVarClockInfo) {
                long valueAtTime;
                long startTime;
                DVTVCDVarClockInfo clockInfo = (DVTVCDVarClockInfo)signalValue;
                long clockStartTime = clockInfo.getStartTime();
                long clockEndTime = clockInfo.getEndTime();
                long l = startTime = clockStartTime < lowestVisibleTime ? lowestVisibleTime : clockStartTime;
                if ((double)(timeStamp - prevTimeStamp) * timeUnitSizeOnScreen >= 3.0) {
                    if (isOptimizing) {
                        isOptimizing = false;
                        signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + (String)prevValue);
                    }
                } else if (!isOptimizing && this.shouldOptimize(timeUnitSizeOnScreen, prevTimeStamp, prevValue, timeStamp, signalValue)) {
                    isOptimizing = true;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_START");
                }
                if ((double)clockInfo.getChangeInterval() * timeUnitSizeOnScreen < 3.0) {
                    if (!isOptimizing) {
                        isOptimizing = true;
                        signalValuesByTime.put(startTime, "DVT_WAVE_OPTIM_START");
                    }
                    prevTimeStamp = clockEndTime;
                    prevValue = Long.toString(clockInfo.getValueAtTime(clockEndTime));
                    continue;
                }
                if (startTime > clockEndTime) {
                    valueAtTime = clockInfo.getValueAtTime(clockEndTime);
                    signalValuesByTime.put(startTime, String.valueOf(valueAtTime));
                    continue;
                }
                valueAtTime = clockInfo.getValueAtTime(startTime);
                signalValuesByTime.put(startTime, String.valueOf(valueAtTime));
                long clockChangeInterval = clockInfo.getChangeInterval();
                long clockStartTimeDelta = (startTime - clockInfo.getStartTime()) % clockChangeInterval;
                long currentTime = startTime + clockChangeInterval - clockStartTimeDelta;
                while (currentTime <= highestVisibleTime && currentTime <= clockEndTime) {
                    valueAtTime = clockInfo.getValueAtTime(currentTime);
                    signalValuesByTime.put(currentTime, String.valueOf(valueAtTime));
                    currentTime += clockChangeInterval;
                }
            } else if (this.shouldOptimize(timeUnitSizeOnScreen, prevTimeStamp, prevValue, timeStamp, signalValue)) {
                if (!isOptimizing) {
                    isOptimizing = true;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_START");
                }
            } else {
                if (isOptimizing) {
                    isOptimizing = false;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + (String)prevValue);
                }
                signalValuesByTime.put(timeStamp, (String)signalValue);
            }
            prevValue = (String)signalValue;
            prevTimeStamp = timeStamp;
        }
        if (prevTimeStamp > 0L && signalValuesByTime.lastEntry() != null && signalValuesByTime.lastEntry().getValue().equals("DVT_WAVE_OPTIM_START")) {
            signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + (String)prevValue);
        }
        if (signalValuesByTime.isEmpty()) {
            return signalValuesByTime;
        }
        Long firstTime = signalValuesByTime.firstKey();
        if (firstTime < lowestVisibleTime) {
            String firstValue = signalValuesByTime.remove(firstTime);
            if (!signalValuesByTime.containsKey(lowestVisibleTime)) {
                signalValuesByTime.put(lowestVisibleTime, firstValue);
            }
        }
        return signalValuesByTime;
    }

    private boolean isUnknownOrHighImpedance(Object signalValue) {
        if (signalValue instanceof DVTVCDVarClockInfo) {
            return false;
        }
        String signalValueString = (String)signalValue;
        return signalValueString == null || signalValueString.contains("x") || signalValueString.contains("X") || signalValueString.contains("z") || signalValueString.contains("Z");
    }

    protected WDWave computeMultiBitWave(int waveX, int waveY, int waveMaxLength, int waveHeight, WSignalsTableMultiBitSignal signalsTableMultibitSignal, WViewport viewport, TreeMap<Long, String> signalValuesByTime) {
        String waveName = signalsTableMultibitSignal.getName();
        DLine waveGridLine = this.computeWaveGridLine(waveX, waveY, waveHeight, waveMaxLength);
        DRectangle waveBackground = this.computeWaveBackground(waveX, waveY, waveMaxLength, waveHeight, signalsTableMultibitSignal);
        boolean isEnum = false;
        if (signalsTableMultibitSignal instanceof WSignalsTableStructSignal var12_13) {
            isEnum = structSignal.isEnum();
        }
        WDMultiBitWave wave = new WDMultiBitWave(waveName, waveGridLine, waveBackground);
        if (signalValuesByTime.isEmpty()) {
            return wave;
        }
        int waveUpperLineY = waveY + 5;
        int waveLowerLineY = waveY + waveHeight - 2;
        int signalValueChangeYOffset = (waveLowerLineY - waveUpperLineY) / 2;
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        int highestParsedX = this.computeTimeRelativeX(viewport.getHighestVisibleTime(), lowestVisibleTime, timeUnitSizeOnScreen, waveX);
        int x1 = waveX;
        int x2 = waveX;
        Set<Long> timeStamps = signalValuesByTime.keySet();
        Iterator<Long> timeStampsIterator = timeStamps.iterator();
        long firstTimeStamp = signalValuesByTime.firstKey();
        String signalBase = signalsTableMultibitSignal.getBase();
        String signalBitwidth = String.valueOf(signalsTableMultibitSignal.getBitWidth());
        String signalType = signalsTableMultibitSignal.getType();
        RGB waveBackgroundColor = signalsTableMultibitSignal.getBackgroundColor();
        RGB waveTextColor = signalsTableMultibitSignal.getTextColor();
        if (waveTextColor == null && waveBackgroundColor == null) {
            waveTextColor = DVTVCDUtils.WHITE;
        } else if (waveTextColor == null && waveBackgroundColor != null) {
            waveTextColor = ColorFactory.getInstance().invertRGB(waveBackgroundColor);
        }
        RGB waveColor = signalsTableMultibitSignal.getWaveColor();
        RGB waveLinesColor = DVTVCDUtils.RED;
        int optimizedElementX = -100;
        RGB optimizedElementColor = DVTVCDUtils.RED;
        int optimizedElementHeight = waveLowerLineY - waveUpperLineY;
        long prevTimeStamp = firstTimeStamp;
        String prevSignalValue = signalValuesByTime.get(firstTimeStamp);
        if (prevSignalValue.equals("DVT_WAVE_OPTIM_START")) {
            optimizedElementX = waveX;
            optimizedElementColor = waveColor;
        }
        while (timeStampsIterator.hasNext()) {
            long currentTimeStamp = timeStampsIterator.next();
            String currentSignalValue = signalValuesByTime.get(currentTimeStamp);
            x1 = this.computeTimeRelativeX(prevTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
            x2 = this.computeTimeRelativeX(currentTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
            if (currentSignalValue.startsWith("DVT_WAVE_OPTIM_END")) {
                waveLinesColor = this.computeWaveElementColor(currentSignalValue, waveColor);
                optimizedElementX = -100;
                wave.addOptimizedElement(x1, waveUpperLineY, x2 - x1, optimizedElementHeight, waveLinesColor);
                prevTimeStamp = currentTimeStamp;
                prevSignalValue = currentSignalValue;
                continue;
            }
            if (currentSignalValue.equals("DVT_WAVE_OPTIM_START")) {
                if (x2 - x1 >= 3) {
                    optimizedElementX = x2;
                }
                optimizedElementColor = waveLinesColor;
            }
            if (x1 != x2 && x2 - 2 >= waveX) {
                waveLinesColor = this.computeWaveElementColor(prevSignalValue, waveColor);
                if (x1 + 2 < x2 - 2) {
                    wave.addUpperWaveLine(x1 + 2, waveUpperLineY, x2 - 2, waveUpperLineY, waveLinesColor);
                    wave.addLowerWaveLine(x1 + 2, waveLowerLineY, x2 - 2, waveLowerLineY, waveLinesColor);
                }
                wave.addUpperWaveLine(x2 - 2, waveUpperLineY, x2, waveUpperLineY + signalValueChangeYOffset, waveLinesColor);
                wave.addLowerWaveLine(x2 - 2, waveLowerLineY, x2, waveLowerLineY - signalValueChangeYOffset, waveLinesColor);
                wave.addUpperWaveLine(x1, waveUpperLineY + signalValueChangeYOffset, x1 + 2, waveUpperLineY, waveLinesColor);
                wave.addLowerWaveLine(x1, waveUpperLineY + signalValueChangeYOffset, x1 + 2, waveLowerLineY, waveLinesColor);
                String convertedSignalValue = isEnum && "ENUM".equals(signalBase) ? DVTVCDUtils.getEnumItem(prevSignalValue, signalsTableMultibitSignal) : DVTVCDUtils.getConvertedSignalValue(prevSignalValue, signalBitwidth, signalType, signalBase);
                if (convertedSignalValue.length() * 7 <= x2 - x1 - 6) {
                    int waveValueY = waveUpperLineY + (waveLowerLineY - waveUpperLineY - 7) / 2 - 1;
                    wave.addWaveValue(convertedSignalValue, x1 + 4, waveValueY, waveTextColor);
                }
            }
            prevTimeStamp = currentTimeStamp;
            prevSignalValue = currentSignalValue;
        }
        x1 = this.computeTimeRelativeX(prevTimeStamp, lowestVisibleTime, timeUnitSizeOnScreen, waveX);
        waveLinesColor = this.computeWaveElementColor(prevSignalValue, waveColor);
        if (optimizedElementX != -100) {
            wave.addOptimizedElement(optimizedElementX, waveUpperLineY, x1 - 2 - optimizedElementX, optimizedElementHeight, optimizedElementColor);
        }
        if ((convertedSignalValue = isEnum && "ENUM".equals(signalBase) ? DVTVCDUtils.getEnumItem(prevSignalValue, signalsTableMultibitSignal) : DVTVCDUtils.getConvertedSignalValue(prevSignalValue, signalBitwidth, signalType, signalBase)).length() * 7 <= highestParsedX - x1 - 6) {
            int waveValueY = waveUpperLineY + (waveLowerLineY - waveUpperLineY - 7) / 2 - 1;
            wave.addWaveValue(convertedSignalValue, x1 + 4, waveValueY, waveTextColor);
        }
        int waveMaxX = viewport.getMaxXToDrawAt();
        wave.addUpperWaveLine(x2, waveUpperLineY + signalValueChangeYOffset, x2 + 2, waveUpperLineY, waveLinesColor);
        wave.addLowerWaveLine(x2, waveUpperLineY + signalValueChangeYOffset, x2 + 2, waveLowerLineY, waveLinesColor);
        wave.addUpperWaveLine(x2 + 2, waveUpperLineY, waveMaxX, waveUpperLineY, waveLinesColor);
        wave.addLowerWaveLine(x2 + 2, waveLowerLineY, waveMaxX, waveLowerLineY, waveLinesColor);
        return wave;
    }

    public TreeMap<Long, String> computeMultiBitSignalValuesByTime(DVTVCDSignalWrapper vcdSignalWrapper, long lowestVisibleTime, long highestVisibleTime, double timeUnitSizeOnScreen) {
        Iterator<DVTVCDVarModificationByTime> iterator;
        TreeMap<Long, String> signalValuesByTime = new TreeMap<Long, String>();
        if (this.canvas.getProvider() instanceof FSTReader) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = vcdSignalWrapper.getVarModifsFromFST();
            if (varModifsFromFST == null) {
                return signalValuesByTime;
            }
            varModifsFromFST.setStartTime((int)lowestVisibleTime);
            iterator = varModifsFromFST.iterator();
        } else {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> signalModifsByTime = vcdSignalWrapper.getVarModificationByTime();
            iterator = signalModifsByTime.iterator();
        }
        Long prevTimeStamp = -1000000L;
        String prevValue = null;
        boolean isOptimizing = false;
        while (iterator.hasNext()) {
            DVTVCDVarModificationByTime signalModif = iterator.next();
            long signalModifTime = signalModif.getTime();
            if (signalModifTime > highestVisibleTime) {
                if (!isOptimizing) break;
                signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + prevValue);
                break;
            }
            String signalModifValue = signalModif.getValue();
            if (signalModifTime <= lowestVisibleTime) {
                signalValuesByTime.put(lowestVisibleTime, signalModifValue);
                prevValue = signalModifValue;
                prevTimeStamp = lowestVisibleTime;
                continue;
            }
            if (this.shouldOptimize(timeUnitSizeOnScreen, prevTimeStamp, prevValue, signalModifTime, signalModifValue)) {
                if (!isOptimizing) {
                    isOptimizing = true;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_START");
                }
            } else {
                if (isOptimizing) {
                    isOptimizing = false;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + prevValue);
                }
                signalValuesByTime.put(signalModifTime, signalModifValue);
            }
            prevValue = signalModifValue;
            prevTimeStamp = signalModifTime;
        }
        if (prevTimeStamp > 0L && signalValuesByTime.lastEntry() != null && signalValuesByTime.lastEntry().getValue().equals("DVT_WAVE_OPTIM_START")) {
            signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + prevValue);
        }
        String valueAtTimeZero = vcdSignalWrapper.getValueAtTimeZero();
        if ((signalValuesByTime.isEmpty() || signalValuesByTime.firstKey() > lowestVisibleTime) && valueAtTimeZero != null) {
            signalValuesByTime.put(lowestVisibleTime, valueAtTimeZero);
        }
        return signalValuesByTime;
    }

    private boolean shouldOptimize(double timeUnitSizeOnScreen, Long prevTime, Object prevValue, long currentTime, Object currentValue) {
        if (timeUnitSizeOnScreen == -1.0) {
            return false;
        }
        if (prevTime < 0L) {
            return false;
        }
        if (prevValue == null || prevValue.equals(currentValue)) {
            return false;
        }
        if (this.isUnknownOrHighImpedance(currentValue) && this.isUnknownOrHighImpedance(prevValue)) {
            return false;
        }
        if (prevTime == currentTime) {
            return false;
        }
        return (double)(currentTime - prevTime) * timeUnitSizeOnScreen < 3.0;
    }

    public TreeMap<Long, String> computeSingleBitChildSignal(DVTVCDSignalWrapper vcdSignalWrapper, long lowestVisibleTime, long highestVisibleTime, double timeUnitSizeOnScreen, int index) {
        Iterator<DVTVCDVarModificationByTime> iterator;
        TreeMap<Long, String> signalValuesByTime = new TreeMap<Long, String>();
        if (this.canvas.getProvider() instanceof FSTReader) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = vcdSignalWrapper.getVarModifsFromFST();
            if (varModifsFromFST == null) {
                return signalValuesByTime;
            }
            varModifsFromFST.setStartTime((int)lowestVisibleTime);
            iterator = varModifsFromFST.iterator();
        } else {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> signalModifsByTime = vcdSignalWrapper.getVarModificationByTime();
            iterator = signalModifsByTime.iterator();
        }
        boolean isBigEndian = vcdSignalWrapper.isBigEndian();
        int bitWidth = Integer.parseInt(vcdSignalWrapper.getBitWidth());
        Long prevTimeStamp = -1000000L;
        String prevValue = null;
        boolean isOptimizing = false;
        while (iterator.hasNext()) {
            String prevSignalIndexValue;
            DVTVCDVarModificationByTime signalModif = iterator.next();
            long signalModifTime = signalModif.getTime();
            if (signalModifTime > highestVisibleTime) {
                if (!isOptimizing || prevValue == null) break;
                signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getValueAtIndex(index, prevValue, bitWidth, isBigEndian));
                break;
            }
            String signalModifValue = signalModif.getValue();
            String signalIndexValue = DVTVCDUtils.getValueAtIndex(index, signalModifValue, bitWidth, isBigEndian);
            if (prevValue != null && (prevSignalIndexValue = DVTVCDUtils.getValueAtIndex(index, prevValue, bitWidth, isBigEndian)).equals(signalIndexValue)) continue;
            if (signalModifTime <= lowestVisibleTime) {
                signalValuesByTime.put(lowestVisibleTime, DVTVCDUtils.getValueAtIndex(index, signalModifValue, bitWidth, isBigEndian));
                prevValue = signalModifValue;
                prevTimeStamp = lowestVisibleTime;
                continue;
            }
            if (this.shouldOptimize(timeUnitSizeOnScreen, prevTimeStamp, signalModifValue, signalModifTime, prevValue)) {
                if (!isOptimizing) {
                    isOptimizing = true;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_START");
                }
            } else {
                if (isOptimizing && prevValue != null) {
                    isOptimizing = false;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getValueAtIndex(index, prevValue, bitWidth, isBigEndian));
                }
                signalValuesByTime.put(signalModifTime, DVTVCDUtils.getValueAtIndex(index, signalModifValue, bitWidth, isBigEndian));
            }
            prevValue = signalModifValue;
            prevTimeStamp = signalModifTime;
        }
        if (prevValue != null && prevTimeStamp > 0L && signalValuesByTime.lastEntry() != null && signalValuesByTime.lastEntry().getValue().equals("DVT_WAVE_OPTIM_START")) {
            signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getValueAtIndex(index, prevValue, bitWidth, isBigEndian));
        }
        String valueAtTimeZero = vcdSignalWrapper.getValueAtTimeZero();
        if ((signalValuesByTime.isEmpty() || signalValuesByTime.firstKey() > lowestVisibleTime) && valueAtTimeZero != null) {
            signalValuesByTime.put(lowestVisibleTime, DVTVCDUtils.getValueAtIndex(index, valueAtTimeZero, bitWidth, isBigEndian));
        }
        return signalValuesByTime;
    }

    public TreeMap<Long, String> computeMultiBitChildSignal(DVTVCDSignalWrapper vcdSignalWrapper, long lowestVisibleTime, long highestVisibleTime, double timeUnitSizeOnScreen, int startIndex, int endIndex) {
        Iterator<DVTVCDVarModificationByTime> iterator;
        TreeMap<Long, String> signalValuesByTime = new TreeMap<Long, String>();
        if (this.canvas.getProvider() instanceof FSTReader) {
            DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = vcdSignalWrapper.getVarModifsFromFST();
            if (varModifsFromFST == null) {
                return signalValuesByTime;
            }
            varModifsFromFST.setStartTime((int)lowestVisibleTime);
            iterator = varModifsFromFST.iterator();
        } else {
            ConcurrentLinkedDeque<DVTVCDVarModificationByTime> signalModifsByTime = vcdSignalWrapper.getVarModificationByTime();
            iterator = signalModifsByTime.iterator();
        }
        int bitWidth = Integer.parseInt(vcdSignalWrapper.getBitWidth());
        Long prevTimeStamp = -1000000L;
        String prevValue = null;
        boolean isOptimizing = false;
        while (iterator.hasNext()) {
            DVTVCDVarModificationByTime signalModif = iterator.next();
            long signalModifTime = signalModif.getTime();
            if (signalModifTime > highestVisibleTime) {
                if (!isOptimizing) break;
                signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, prevValue, bitWidth));
                break;
            }
            String signalModifValue = signalModif.getValue();
            if (signalModifTime <= lowestVisibleTime) {
                signalValuesByTime.put(lowestVisibleTime, DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, signalModifValue, bitWidth));
                prevValue = signalModifValue;
                prevTimeStamp = lowestVisibleTime;
                continue;
            }
            if (this.shouldOptimize(timeUnitSizeOnScreen, prevTimeStamp, prevValue, signalModifTime, signalModifValue)) {
                if (!isOptimizing) {
                    isOptimizing = true;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_START");
                }
            } else {
                if (isOptimizing) {
                    isOptimizing = false;
                    signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, prevValue, bitWidth));
                }
                signalValuesByTime.put(signalModifTime, DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, signalModifValue, bitWidth));
            }
            prevValue = signalModifValue;
            prevTimeStamp = signalModifTime;
        }
        if (prevTimeStamp > 0L && signalValuesByTime.lastEntry() != null && signalValuesByTime.lastEntry().getValue().equals("DVT_WAVE_OPTIM_START")) {
            signalValuesByTime.put(prevTimeStamp, "DVT_WAVE_OPTIM_END" + DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, prevValue, bitWidth));
        }
        String valueAtTimeZero = vcdSignalWrapper.getValueAtTimeZero();
        if ((signalValuesByTime.isEmpty() || signalValuesByTime.firstKey() > lowestVisibleTime) && valueAtTimeZero != null) {
            signalValuesByTime.put(lowestVisibleTime, DVTVCDUtils.getMultibitValueAtIndex(startIndex, endIndex, valueAtTimeZero, bitWidth));
        }
        return signalValuesByTime;
    }

    private int computeTimeRelativeX(long time, long lowestVisibleTime, double timeUnitSizeOnScreen, int xOffest) {
        return (int)((double)(time - lowestVisibleTime > 0L ? time - lowestVisibleTime : 0L) * timeUnitSizeOnScreen) + xOffest;
    }

    private int computeSingleBitWavePointY(String signalValue, int waveLowY, int waveHighY) {
        if (signalValue.contains("X") || signalValue.contains("x")) {
            return waveHighY;
        }
        if (signalValue.contains("Z") || signalValue.contains("z")) {
            return waveLowY - (waveLowY - waveHighY) / 2;
        }
        if (signalValue.equals("DVT_WAVE_OPTIM_START")) {
            return waveLowY;
        }
        if (signalValue.startsWith("DVT_WAVE_OPTIM_END")) {
            return Integer.valueOf(signalValue.substring("DVT_WAVE_OPTIM_END".length())) == 0 ? waveLowY : waveHighY;
        }
        return waveLowY - Integer.valueOf(signalValue) * (waveLowY - waveHighY);
    }

    private RGB computeWaveElementColor(String signalValue, RGB waveColor) {
        if (signalValue.contains("X") || signalValue.contains("x")) {
            return DVTVCDUtils.RED;
        }
        if (signalValue.contains("Z") || signalValue.contains("z")) {
            return DVTVCDUtils.BLUE;
        }
        return waveColor;
    }

    protected DRectangle computeWaveBackground(int waveX, int waveY, int waveMaxLength, int waveHeight, WSignalsTableElement signalsTableElement) {
        DRectangle waveBackground = new DRectangle(waveX, waveY, waveMaxLength, waveHeight);
        RGB waveBackgroundColor = signalsTableElement.getBackgroundColor();
        if (waveBackgroundColor != null) {
            waveBackground.setFillColor(waveBackgroundColor);
        } else {
            waveBackground.setFillColor(DVTVCDUtils.BLACK);
        }
        WaveViewerSignalTableView selectedSignalsView = this.canvas.getSignalsTableView();
        if (selectedSignalsView == null) {
            return waveBackground;
        }
        List<WSignalsTableElement> selectedSignals = selectedSignalsView.getSelectedElements();
        if (selectedSignals != null && !selectedSignals.isEmpty() && selectedSignals.contains(signalsTableElement)) {
            waveBackground.setFillColor(selectedSignalsView.getSelectionColor(waveBackgroundColor == null ? DVTVCDUtils.BLACK : waveBackgroundColor, DVTVCDUtils.BLACK));
        }
        return waveBackground;
    }

    protected DLine computeWaveGridLine(int waveX, int waveY, int waveHeight, int waveMaxLength) {
        int waveGridLineY = waveY + waveHeight;
        int waveGridLineMaxX = waveX + waveMaxLength;
        DLine waveGridLine = new DLine(new int[]{waveX, waveGridLineY, waveGridLineMaxX, waveGridLineY});
        waveGridLine.setLineColor(DVTVCDUtils.GRAY);
        return waveGridLine;
    }

    private List<WDMarker> computeMarkers() {
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return Collections.emptyList();
        }
        ArrayList<WDMarker> markers = new ArrayList<WDMarker>();
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        long highestVisibleTime = viewport.getHighestVisibleTime();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        int timesTextXOffset = viewport.getTimesTextXOffset();
        Rectangle canvasSize = viewport.getCanvasSize();
        List<WMarker> wMarkers = viewport.getMarkers();
        for (WMarker wMarker : wMarkers) {
            long markerTime = wMarker.getTime();
            if (markerTime < lowestVisibleTime || markerTime > highestVisibleTime) continue;
            int x = this.computeTimeRelativeX(markerTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffset);
            markers.add(new WDMarker(wMarker.getLabel(), x, canvasSize.y + canvasSize.height, wMarker.getLabelOutlineWidth()));
        }
        return markers;
    }

    private List<WDCursor> computeCursors() {
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return Collections.emptyList();
        }
        ArrayList<WDCursor> cursors = new ArrayList<WDCursor>();
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        long highestVisibleTime = viewport.getHighestVisibleTime();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        int timesTextXOffest = viewport.getTimesTextXOffset();
        Rectangle canvasSize = viewport.getCanvasSize();
        WCursor primaryCursor = viewport.getPrimaryCursor();
        WCursor secondaryCursor = viewport.getSecondaryCursor();
        WDCursor bottomCursor = null;
        WDCursor topCursor = null;
        if (viewport.getCursorOnTop() == DVTVCDUtilsCommon.Cursors.PRIMARY) {
            bottomCursor = this.computeCursor(secondaryCursor, lowestVisibleTime, highestVisibleTime, timeUnitSizeOnScreen, timesTextXOffest, canvasSize);
            topCursor = this.computeCursor(primaryCursor, lowestVisibleTime, highestVisibleTime, timeUnitSizeOnScreen, timesTextXOffest, canvasSize);
        } else {
            bottomCursor = this.computeCursor(primaryCursor, lowestVisibleTime, highestVisibleTime, timeUnitSizeOnScreen, timesTextXOffest, canvasSize);
            topCursor = this.computeCursor(secondaryCursor, lowestVisibleTime, highestVisibleTime, timeUnitSizeOnScreen, timesTextXOffest, canvasSize);
        }
        if (bottomCursor != null) {
            cursors.add(bottomCursor);
        }
        if (topCursor != null) {
            cursors.add(topCursor);
        }
        return cursors;
    }

    private WDCursor computeCursor(WCursor cursor, long lowestVisibleTime, long highestVisibleTime, double timeUnitSizeOnScreen, int timesTextXOffest, Rectangle canvasSize) {
        long cursorTime = cursor.getTime();
        if (cursorTime < lowestVisibleTime || cursorTime > highestVisibleTime) {
            return null;
        }
        int x = this.computeTimeRelativeX(cursorTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffest);
        if (canvasSize.width - x < cursor.getLabelOutlineWidth()) {
            cursor.setFlipped(true);
        } else {
            cursor.setFlipped(false);
        }
        return new WDCursor(cursor.getLabel(), x, canvasSize.y + canvasSize.height, cursor.getLabelOutlineWidth(), cursor.isFlipped());
    }

    private WDCursorsDeltaTime computeCursorsDeltaTime() {
        int timesTextXOffset;
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return null;
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        WCursor secondaryCursor = viewport.getSecondaryCursor();
        long primaryCursorTime = primaryCursor.getTime();
        long secondaryCursorTime = secondaryCursor.getTime();
        if (primaryCursorTime < 0L || secondaryCursorTime < 0L) {
            return null;
        }
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        if (primaryCursorTime < lowestVisibleTime && secondaryCursorTime < lowestVisibleTime) {
            return null;
        }
        long highestVisibleTime = viewport.getHighestVisibleTime();
        if (primaryCursorTime > highestVisibleTime && secondaryCursorTime > highestVisibleTime) {
            return null;
        }
        long lowerCursorTime = primaryCursorTime < secondaryCursorTime ? primaryCursorTime : secondaryCursorTime;
        long higherCursorTime = primaryCursorTime < secondaryCursorTime ? secondaryCursorTime : primaryCursorTime;
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        int lowerTimeX = timesTextXOffset = viewport.getTimesTextXOffset();
        if (lowerCursorTime > lowestVisibleTime) {
            lowerTimeX = this.computeTimeRelativeX(lowerCursorTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffset);
        }
        Rectangle canvasSize = viewport.getCanvasSize();
        int higherTimeX = canvasSize.x + canvasSize.width;
        if (higherCursorTime <= highestVisibleTime) {
            higherTimeX = this.computeTimeRelativeX(higherCursorTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffset);
        }
        String lowerCursorName = lowerCursorTime == primaryCursorTime ? primaryCursor.getName() : secondaryCursor.getName();
        String higherCursorName = higherCursorTime == primaryCursorTime ? primaryCursor.getName() : secondaryCursor.getName();
        int deltaTimeY = this.canvas.getSignalsTableSearchBarHeight() + this.canvas.getSelectedSignalsTableHeight() - this.canvas.getHorizontalSliderHeight();
        long deltaTime = higherCursorTime - lowerCursorTime;
        String deltaTimeString = String.valueOf(String.valueOf(deltaTime)) + viewport.getTimescale().getName();
        return new WDCursorsDeltaTime(lowerTimeX, higherTimeX, deltaTimeY, timesTextXOffset, canvasSize.x + canvasSize.width, lowerCursorName, higherCursorName, deltaTimeString);
    }

    public DRectangle computeZoomSelectionHighlight() {
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return null;
        }
        WaveViewerSignalTableView selectedSignalsView = this.canvas.getSignalsTableView();
        if (selectedSignalsView == null) {
            return null;
        }
        long mouseDownTime = this.canvas.getZoomMouseDownTime();
        long mouseCurrentTime = this.canvas.getZoomMouseCurrentTime();
        if (mouseDownTime == -1L || mouseCurrentTime == -1L || mouseDownTime == mouseCurrentTime) {
            return null;
        }
        long lowerTime = mouseDownTime < mouseCurrentTime ? mouseDownTime : mouseCurrentTime;
        long higherTime = mouseDownTime < mouseCurrentTime ? mouseCurrentTime : mouseDownTime;
        int timesTextXOffset = viewport.getTimesTextXOffset();
        double timeUnitSizeOnScreen = viewport.getTimeUnitSizeOnScreen();
        long lowestVisibleTime = viewport.getLowestVisibleTime();
        int lowerX = this.computeTimeRelativeX(lowerTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffset);
        int higherX = this.computeTimeRelativeX(higherTime, lowestVisibleTime, timeUnitSizeOnScreen, timesTextXOffset);
        DRectangle zoomSelectionHighlight = new DRectangle(lowerX, 0, higherX - lowerX, this.canvas.getSize().y);
        zoomSelectionHighlight.setFillColor(selectedSignalsView.getSelectionColor(DVTVCDUtils.BLACK, DVTVCDUtils.BLACK));
        return zoomSelectionHighlight;
    }

    @Override
    public void paint(DContext dc) {
        this.paintCanvasBackground(dc);
        this.paintWavesBackgrounds(dc);
        this.paintZoomSelectionHighlight(dc);
        this.paintTimeAxis(dc);
        this.paintWaves(dc);
        this.paintMarkers(dc);
        this.paintCursors(dc);
        this.paintCursorsDeltaTime(dc);
    }

    private void paintCanvasBackground(DContext dc) {
        this.canvasBackground.paint(dc);
    }

    private void paintWavesBackgrounds(DContext dc) {
        for (WDWave wave : this.waves) {
            wave.paintBackground(dc);
        }
    }

    private void paintZoomSelectionHighlight(DContext dc) {
        if (this.zoomSelectionHighlight == null) {
            return;
        }
        this.zoomSelectionHighlight.paint(dc);
    }

    private void paintTimeAxis(DContext dc) {
        this.timeAxis.paint(dc);
    }

    private void paintWaves(DContext dc) {
        for (WDWave wave : this.waves) {
            if (!(wave instanceof WDSignalWave)) continue;
            ((WDSignalWave)wave).paintWave(dc);
        }
    }

    private void paintMarkers(DContext dc) {
        for (WDMarker marker : this.markers) {
            marker.paint(dc);
        }
    }

    private void paintCursors(DContext dc) {
        for (WDCursor cursor : this.cursors) {
            cursor.paint(dc);
        }
    }

    private void paintCursorsDeltaTime(DContext dc) {
        if (this.cursorsDeltaTime != null) {
            this.cursorsDeltaTime.paint(dc);
        }
    }

    @Override
    public DRectangle getCanvasBackground() {
        return this.canvasBackground;
    }
}

