/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDSignalWave;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public abstract class WDMultiBitWaveCommon
extends WDSignalWave {
    protected List<DText> waveValues;
    protected List<DLine> upperWaveLines = new ArrayList<DLine>();
    protected List<DRectangle> optimizedWaveElements;
    protected RGB lastRectangleColor;

    protected WDMultiBitWaveCommon(String name, DLine gridLine, DRectangle background) {
        super(name, gridLine, background);
        this.waveValues = new ArrayList<DText>();
        this.optimizedWaveElements = new ArrayList<DRectangle>();
    }

    public void addUpperWaveLine(int x1, int y1, int x2, int y2, RGB color) {
        DLine line = new DLine(new int[]{x1, y1, x2, y2});
        line.setLineColor(color);
        this.upperWaveLines.add(line);
    }

    public void addWaveValue(String value, int x, int y, RGB color) {
        DText text = new DText(value, x, y, DVTVCDUtils.getFontData());
        text.setTextColor(color);
        this.waveValues.add(text);
    }

    public void addOptimizedElement(int x, int y, int width, int height, RGB color) {
        if (width < 3) {
            width = 3;
        }
        DRectangle rectangle = new DRectangle(x, y, width, height);
        rectangle.setFillColor(color);
        rectangle.setLineColor(color);
        if (!this.optimizedWaveElements.isEmpty()) {
            DRectangle lastElement = this.optimizedWaveElements.get(this.optimizedWaveElements.size() - 1);
            if (this.lastRectangleColor == color && rectangle.getBounds().x - lastElement.getBounds().x - lastElement.getBounds().width + 2 < 3) {
                rectangle = new DRectangle(lastElement.getBounds().x + 1, lastElement.getBounds().y + 1, width + lastElement.getBounds().width - 2, height);
                rectangle.setFillColor(color);
                rectangle.setLineColor(color);
                this.optimizedWaveElements.remove(this.optimizedWaveElements.size() - 1);
            }
        }
        this.lastRectangleColor = color;
        this.optimizedWaveElements.add(rectangle);
    }
}

