/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.obj;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.diagrams.wave.draw.obj.WDTimeAxisLabel;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;

public class WDTimeAxis {
    private DLine timeAxisLine;
    private List<WDTimeAxisLabel> timeAxisLabels;
    private List<DLine> timeAxisMarkings;

    public WDTimeAxis(int x1, int y1, int x2, int y2) {
        this.timeAxisLine = new DLine(new int[]{x1, y1, x2, y2});
        this.timeAxisLine.setLineColor(DVTVCDUtils.GRAY);
        this.timeAxisLabels = new ArrayList<WDTimeAxisLabel>();
        this.timeAxisMarkings = new ArrayList<DLine>();
    }

    public WDTimeAxisLabel addTimeAxisLabel(int x, int y, int verticalLineHeight, long time, DVTVCDUtilsCommon.TimeScales timescale) {
        WDTimeAxisLabel timeAxisLabel = new WDTimeAxisLabel(x, y, verticalLineHeight, time, timescale);
        this.timeAxisLabels.add(timeAxisLabel);
        return timeAxisLabel;
    }

    public void addTimeAxisMarking(int x, int y, int verticalLineHeight) {
        DLine timeAxisMarking = new DLine(new int[]{x, y, x, y + verticalLineHeight});
        timeAxisMarking.setLineColor(DVTVCDUtils.GRAY);
        this.timeAxisMarkings.add(timeAxisMarking);
    }

    public WDTimeAxisLabel addEndTimeAxisLabel(int maxX, int y, long highestVisibleTime, DVTVCDUtilsCommon.TimeScales timescale) {
        int x = maxX - DVTVCDUtils.getLabelWidth(highestVisibleTime, timescale) - 2;
        WDTimeAxisLabel timeAxisLabel = new WDTimeAxisLabel(x, y, 0, highestVisibleTime, timescale);
        this.timeAxisLabels.add(timeAxisLabel);
        return timeAxisLabel;
    }

    public void paint(DContext dc) {
        this.timeAxisLine.paint(dc);
        for (WDTimeAxisLabel timeAxisLabel : this.timeAxisLabels) {
            timeAxisLabel.paint(dc);
        }
        for (DLine timeAxisMarking : this.timeAxisMarkings) {
            timeAxisMarking.paint(dc);
        }
    }
}

