/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.render.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.utils.DVTStringBuilder;

final class WDebugShell {
    private final ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            ArrayList<Node> children;
            if (inputElement != null && inputElement instanceof Node && (children = ((Node)inputElement).children) != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Node> children;
            if (parentElement != null && parentElement instanceof Node && (children = ((Node)parentElement).children) != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element != null && element instanceof Node) {
                return ((Node)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            ArrayList<Node> children;
            if (element != null && element instanceof Node && (children = ((Node)element).children) != null) {
                return !children.isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    };
    private final ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof Node) {
                if (columnIndex == 0) {
                    return ((Node)element).key;
                }
                String value = ((Node)element).value;
                if (value == null) {
                    return null;
                }
                int endIndex = value.indexOf(10);
                return value.substring(0, endIndex < 0 ? value.length() : endIndex);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }
    };
    private DisposeListener disposeListener;
    private final ISelectionChangedListener selectionListener;
    private volatile boolean isEnabled;
    private volatile boolean isUpdated;
    private final Shell shell;
    private final TreeViewer viewer;
    private final Text details;
    private final Map<String, String> debugData;

    public WDebugShell(WCanvas canvas, Map<String, String> debugData) {
        this.debugData = debugData;
        Shell parent = canvas.getShell();
        int parentHeight = parent.getSize().y;
        Point parentLocation = parent.getLocation();
        int shellXPos = Math.max(0, parentLocation.x - 405);
        int shellYPos = parentLocation.y;
        this.shell = new Shell(parent, 2160);
        this.disposeListener = e -> this.close();
        this.shell.addDisposeListener(this.disposeListener);
        this.shell.setSize(400, parentHeight);
        this.shell.setLocation(shellXPos, shellYPos);
        this.shell.setText("DCanvas Debug (" + System.identityHashCode((Object)canvas) + ")");
        this.shell.setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm((Composite)this.shell, 512);
        this.viewer = new TreeViewer((Composite)sash);
        this.details = new Text((Composite)sash, 778);
        this.details.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeViewerColumn keyColumn = new TreeViewerColumn(this.viewer, 0);
        keyColumn.getColumn().setWidth(200);
        keyColumn.getColumn().setResizable(true);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.viewer, 0);
        valueColumn.getColumn().setWidth(190);
        valueColumn.getColumn().setResizable(true);
        this.selectionListener = event -> {
            StringBuilder detailsText = new StringBuilder();
            ISelection selection = this.viewer.getSelection();
            if (selection != null && selection instanceof IStructuredSelection) {
                List elements = ((IStructuredSelection)selection).toList();
                for (Object element : elements) {
                    if (!(element instanceof Node)) continue;
                    DVTStringBuilder elementText = new DVTStringBuilder();
                    Node node = (Node)element;
                    elementText.append(node.key).append("]\n----------------\n").append(node.value == null ? "" : node.value.trim()).append("\n================\n\n");
                    while ((node = node.parent) != null && node.key != null) {
                        elementText.prepend('/').prepend(node.key);
                    }
                    elementText.prepend('[');
                    detailsText.append(elementText);
                }
            }
            this.details.setText(detailsText.toString());
        };
        this.viewer.addSelectionChangedListener(this.selectionListener);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)new Node(null, null));
        sash.setWeights(new int[]{4, 1});
        this.shell.open();
        this.isEnabled = true;
        this.isUpdated = true;
        new Thread(() -> {
            while (this.isEnabled) {
                try {
                    this.refresh();
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }).start();
    }

    public void close() {
        this.isUpdated = false;
        this.isEnabled = false;
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    public void update() {
        this.isUpdated = true;
    }

    private void refresh() {
        if (!this.isUpdated || !this.isEnabled) {
            return;
        }
        this.isUpdated = false;
        Node newInput = new Node(null, null);
        for (Map.Entry<String, String> entry : this.debugData.entrySet()) {
            newInput.add(entry.getKey(), entry.getValue());
        }
        Display.getDefault().syncExec(() -> {
            if (!this.viewer.getTree().isDisposed()) {
                Node oldInput = (Node)this.viewer.getInput();
                HashSet<Node> newElements = new HashSet<Node>(Node.getAllNodes(newInput));
                HashSet<Node> oldElements = new HashSet<Node>(Node.getAllNodes(oldInput));
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(this.viewer.getExpandedElements()));
                newElements.removeAll(oldElements);
                expandedElements.addAll(newElements);
                if (oldInput != null && newInput != null) {
                    oldInput.children = node.children;
                }
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.setExpandedElements(expandedElements.toArray());
                this.viewer.getControl().setRedraw(true);
            }
        });
    }

    private static class Node {
        public final String key;
        public String value;
        public final Node parent;
        public ArrayList<Node> children;

        public Node(Node parent, String key) {
            this.parent = parent;
            this.key = key;
        }

        public void add(String key, String value) {
            if (key == null) {
                this.value = value;
                return;
            }
            String[] path = key.split("/", 2);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            Node child = null;
            for (Node c : this.children) {
                if (!c.key.equals(path[0])) continue;
                child = c;
                break;
            }
            if (child == null) {
                child = new Node(this, path[0]);
                this.children.add(child);
            }
            child.add(path.length == 2 ? path[1] : null, value);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        public String toString() {
            return this.key;
        }

        public static Set<Node> getAllNodes(Node node) {
            if (node == null) {
                return Collections.emptySet();
            }
            HashSet<Node> children = new HashSet<Node>();
            children.add(node);
            if (node.children != null) {
                for (Node child : node.children) {
                    children.addAll(Node.getAllNodes(child));
                }
            }
            return children;
        }
    }
}

