/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.render.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.handlers.WClickListener;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WDebugShell;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.draw.debug.DNullDebug;

public class WSWTDebug
implements DDebug {
    private final TreeMap<String, String> debugData;
    private final HashMap<String, Long> timerData;
    private final WCanvas canvas;
    private WDebugShell debugShell;
    private final MouseMoveListener mouseMoveListener;
    private final WClickListener wClickListener;
    private DisposeListener disposeListener;

    public static DDebug getInstance(WCanvas canvas) {
        if (DConstants.DEBUG) {
            return new WSWTDebug(canvas);
        }
        return new DNullDebug();
    }

    private WSWTDebug(WCanvas canvas) {
        this.canvas = canvas;
        this.mouseMoveListener = e -> {
            this.log("mouse/position/image/x", e.x);
            this.log("mouse/position/image/y", e.y);
            this.log("mouse/position/canvas/x", e.x);
            this.log("mouse/position/canvas/y", e.y);
        };
        this.wClickListener = e -> {
            Point clickPoint = e.getPoint();
            this.log("mouse/click/image/x", clickPoint.x);
            this.log("mouse/click/image/y", clickPoint.y);
            this.log("mouse/click/image/button", e.getButton());
            this.log("mouse/click/image/mask", e.getStateMask());
        };
        this.disposeListener = e -> {
            this.debugShell.close();
            this.canvas.removeMouseMoveListener(this.mouseMoveListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.canvas.addDisposeListener(this.disposeListener);
        this.debugData = new TreeMap();
        this.timerData = new HashMap();
        this.debugShell = new WDebugShell(canvas, this.debugData);
        for (Map.Entry<String, String> entry : DConstants.getAll().entrySet()) {
            this.log("constants/" + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void log(String key, String value) {
        this.debugData.put(key, value);
        this.debugShell.update();
    }

    @Override
    public void log(String key, double value) {
        this.log(key, Double.toString(value));
    }

    @Override
    public void log(String key, long value) {
        this.log(key, Long.toString(value));
    }

    @Override
    public void startTimer(String key) {
        this.timerData.put(key, System.nanoTime());
    }

    @Override
    public void endTimer(String key) {
        long endTime = System.nanoTime();
        Long startTime = this.timerData.remove(key);
        if (startTime != null) {
            this.log(key, (endTime - startTime) / 1000000L);
        }
    }

    @Override
    public void clear(String key) {
        NavigableMap<String, String> clearMap = this.debugData.subMap(key, false, String.valueOf(key) + '\uffff', true);
        clearMap.clear();
    }
}

