/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave.draw.render.swt;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModel;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModelFactory;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.LatestTaskOnlyScheduler;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DRenderer;
import ro.amiq.dvt.draw.render.swt.DSWTGraphics;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;

public class WSWTRenderer
implements DRenderer,
Runnable {
    private long debugTotalFrames;
    private long debugRenderedFrames;
    private final WCanvas canvas;
    private final ThreadPoolExecutor renderExecutor;
    private Image image;
    private final PaintListener paintListener;
    private DisposeListener disposeListener;
    private LatestTaskOnlyScheduler latestOnlyScheduler = new LatestTaskOnlyScheduler();
    private Set<String> visibleSignals = new HashSet<String>();

    public WSWTRenderer(WCanvas canvas) {
        this.canvas = canvas;
        this.renderExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardPolicy());
        this.paintListener = e -> {
            if (this.image != null && e.gc != null && !this.image.isDisposed() && !e.gc.isDisposed()) {
                e.gc.drawImage(this.image, 0, 0);
            }
        };
        this.disposeListener = e -> {
            this.renderExecutor.shutdownNow();
            this.disposeImage();
            this.canvas.removePaintListener(this.paintListener);
            this.canvas.removeDisposeListener(this.disposeListener);
        };
        this.canvas.addPaintListener(this.paintListener);
        this.canvas.addDisposeListener(this.disposeListener);
    }

    private void disposeImage() {
        if (this.image == null) {
            return;
        }
        if (!this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
    }

    public void render() {
        if (DConstants.DEBUG) {
            this.canvas.getDebug().log("render/frame/nof/total", ++this.debugTotalFrames);
        }
        if (this.renderExecutor.isShutdown()) {
            return;
        }
        this.renderExecutor.execute(this);
    }

    public void renderOnFstRead() {
        this.render();
    }

    @Override
    public void run() {
        if (this.canvas.isDisposed()) {
            ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_DIAGRAM_DRAWN);
            return;
        }
        this.canvas.getDisplay().syncExec(() -> {
            try {
                DVTVCDParser provider;
                if (this.canvas.isDisposed()) {
                    return;
                }
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().log("render/frame/nof/rendered", ++this.debugRenderedFrames);
                    this.canvas.getDebug().startTimer("render/frame/time/total");
                }
                if ((provider = this.canvas.getProvider()) == null) {
                    return;
                }
                DContext dc = null;
                GC gc = null;
                try {
                    this.disposeImage();
                    this.image = new Image((Device)this.canvas.getDisplay(), this.canvas.getViewport().getCanvasSize());
                    gc = new GC((Drawable)this.image);
                    float[] transformMatrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
                    Rectangle transformedBounds = new Rectangle(-1, -1, this.canvas.getSize().x, this.canvas.getSize().y);
                    double expScale = 1.0;
                    dc = new DContext(new DSWTGraphics(this.image, gc, transformMatrix, transformedBounds, false), expScale);
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().startTimer("render/frame/time/paint");
                    }
                    this.paint(provider, dc);
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().endTimer("render/frame/time/paint");
                    }
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().log("render/gc/quality", dc.getQuality().toString());
                        this.canvas.getDebug().log("render/gc/draw", dc.debugGCDraws);
                        this.canvas.getDebug().log("render/gc/sets", dc.debugGCSets);
                    }
                }
                finally {
                    if (gc != null) {
                        gc.dispose();
                    }
                    if (dc != null) {
                        dc.dispose();
                    }
                }
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().startTimer("render/frame/time/buffer");
                }
                this.canvas.redraw();
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().endTimer("render/frame/time/buffer");
                }
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().endTimer("render/frame/time/total");
                }
            }
            finally {
                ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_DIAGRAM_DRAWN);
            }
        });
    }

    private void paint(DVTVCDParser provider, DContext dc) {
        dc.openContext();
        if (this.canvas == null) {
            return;
        }
        WViewport viewport = this.canvas.getViewport();
        if (viewport == null) {
            return;
        }
        if (provider == null) {
            return;
        }
        DVTVCDModel vcdModel = provider.getVcdModel();
        if (vcdModel == null) {
            return;
        }
        IWDModel drawModel = IWDModelFactory.INSTANCE.getModel(this.canvas, this.visibleSignals, this.latestOnlyScheduler);
        drawModel.paint(dc);
        this.visibleSignals = drawModel.getVisibleSignals();
    }
}

