/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wavedrom;

import java.util.Objects;
import ro.amiq.dvt.diagrams.tables.ITableRowData;

public class BitField
implements Comparable<BitField>,
ITableRowData {
    private String name;
    private String parentName;
    private String type;
    private String access;
    private String reset;
    private int position;
    private int bits;
    private Color color;
    private int hasReset;
    private int isVolatile;
    private int isRandomized;
    private int isAccessible;
    private boolean isUnused;

    private BitField(BitfieldBuilder builder) {
        this.name = builder.name;
        this.position = builder.position;
        this.bits = builder.bits;
        this.color = builder.color;
        this.type = builder.type;
        this.access = "";
        this.parentName = builder.parent;
        this.isUnused = builder.isUnused;
    }

    public BitField() {
    }

    public void setName(String fName) {
        this.name = fName;
    }

    public void setParentName(String fName) {
        this.parentName = fName;
    }

    public String getType() {
        return this.type;
    }

    public int getSize() {
        return this.bits;
    }

    public int getPosition() {
        return this.position;
    }

    public void setAccess(String fAccess) {
        this.access = fAccess;
    }

    public void setPosition(int fPosition) {
        this.position = fPosition;
    }

    public void setSize(int fSize) {
        this.bits = fSize;
    }

    public void setHasReset(int fHasReset) {
        this.hasReset = fHasReset;
    }

    public void setAccessible(int fAccessible) {
        this.isAccessible = fAccessible;
    }

    public void setVolatile(int fVolatile) {
        this.isVolatile = fVolatile;
    }

    public void setRandomized(int fRandomized) {
        this.isRandomized = fRandomized;
    }

    public int getHasReset() {
        return this.hasReset;
    }

    public int getAccessible() {
        return this.isAccessible;
    }

    public int getVolatile() {
        return this.isVolatile;
    }

    public int getRandomized() {
        return this.isRandomized;
    }

    public int getColor() {
        return this.color.getIndex();
    }

    public void setResetValue(String fResetValue) {
        this.reset = fResetValue;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public String getAccess() {
        return this.access;
    }

    public String getResetValue() {
        return this.reset;
    }

    public boolean isUnused() {
        return this.isUnused;
    }

    public void setUnused(boolean isUnused) {
        this.isUnused = isUnused;
    }

    @Override
    public int compareTo(BitField other) {
        return this.position - other.position;
    }

    public int hashCode() {
        return Objects.hash(this.bits, this.position);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitField other = (BitField)obj;
        return this.bits == other.bits && this.position == other.position;
    }

    public String getParentNameRaw() {
        if (this.parentName == null) {
            return "";
        }
        return this.parentName;
    }

    public String getParentName() {
        if (this.parentName == null || this.parentName.isEmpty()) {
            return "";
        }
        return "<span style='color: gray;'>" + this.parentName + "." + "</span>";
    }

    @Override
    public boolean shouldFilterRow() {
        return this.getName().isEmpty();
    }

    public static class BitfieldBuilder {
        private final int bits;
        private final Color color;
        private String name;
        private String parent;
        private String type;
        private int position;
        private boolean isUnused;

        public static BitfieldBuilder of(int bits, Color color) {
            return new BitfieldBuilder(bits, color);
        }

        public static BitField createUnused(int bits, int position) {
            return BitfieldBuilder.of(bits, Color.BLACK).name("").position(position).unused(true).build();
        }

        public BitfieldBuilder(int bits, Color color) {
            this.bits = bits;
            this.color = color;
            this.isUnused = false;
        }

        public BitfieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BitfieldBuilder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public BitfieldBuilder position(int position) {
            this.position = position;
            return this;
        }

        public BitfieldBuilder type(String type) {
            this.type = type;
            return this;
        }

        public BitfieldBuilder unused(boolean isUnused) {
            this.isUnused = isUnused;
            return this;
        }

        public BitField build() {
            return new BitField(this);
        }
    }

    public static enum Color {
        PADDING(0),
        BLACK(1),
        RED(2),
        GREEN(3),
        BLUE(4),
        ORANGE(5),
        DARK_GREEN(6),
        PURPLE(7);

        private int index;

        private Color(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Color next() {
            return Color.values()[this.ordinal() + 1];
        }
    }
}

