/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wavedrom;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum BitFieldFactory {
    INSTANCE;

    private static final int BITFIELD_SIZE_LIMIT;

    static {
        BITFIELD_SIZE_LIMIT = System.getenv("DVT_BITFIELD_SIZE_LIMIT") != null ? Integer.parseInt(System.getenv("DVT_BITFIELD_SIZE_LIMIT")) : 4096;
    }

    public static BitFieldModel getModel(IRfNamedElement candidate, ElementPath path) {
        int size;
        IBitFieldRegister register = BitFieldUtils.getBitFieldRegisterElement(candidate);
        if (register == null) {
            return null;
        }
        if (path == null) {
            path = ElementPath.EMPTY_PATH;
        }
        if ((size = register.getBitFieldDiagramSize(path)) < 1) {
            DVTLogger.INSTANCE.logDebug("[BitField Diagram Generator]: " + candidate.getName() + "(" + size + ") invalid size!");
            return null;
        }
        if (size > BITFIELD_SIZE_LIMIT) {
            DVTLogger.INSTANCE.logDebug("[BitField Diagram Generator]: " + candidate.getName() + "(" + size + ") exceeds the size limit of " + BITFIELD_SIZE_LIMIT + " bits!");
            return null;
        }
        Map<Integer, List<BitField>> bitfields = register.getBitFields(path, size);
        if (bitfields.isEmpty()) {
            DVTLogger.INSTANCE.logDebug("[BitField Diagram Generator]: " + candidate.getName() + " no bitfields found!");
            return null;
        }
        return new BitFieldModel(register, candidate, size, bitfields);
    }
}

