/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wavedrom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.BitfieldViewMode;
import ro.amiq.dvt.diagrams.tables.ITableRowData;
import ro.amiq.dvt.diagrams.tables.ITableWrapper;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class BitFieldModel
implements ITableWrapper {
    public static final String EMPTY_REGISTER_WAVE_JSON = "{reg: [{}], config:{bits:32}}";
    private static final int MAX_BITS_PADDING = 3;
    private static final String VLOG_LEGEND = "legend: {struct: 4, union: 7, enum: 5, field: 3}";
    private static final String VHDL_LEGEND = "legend: {record: 4, array: 6, enum: 5, scalar: 3}";
    public BitfieldViewMode view;
    private Map<Integer, List<BitField>> lanes = new HashMap<Integer, List<BitField>>();
    private IBitFieldRegister register;
    private String name;
    private String elementPath;
    private int elementStartOffset;
    private int size;
    private int drawSize;

    public BitFieldModel(IBitFieldRegister register, IRfNamedElement alias, int size, Map<Integer, List<BitField>> lanes) {
        this.register = register;
        this.size = size;
        this.lanes = lanes;
        this.view = PrefConst.getBitfieldViewMode();
        if (alias instanceof IRfTypeAliasElement) {
            this.name = alias.getName();
            this.elementStartOffset = alias.getDeclaration().getStartOffset();
            this.elementPath = alias.getDeclaration().getParserPath().path;
        } else {
            this.name = ((IRfNamedElement)((Object)register)).getName();
            this.elementStartOffset = ((IRfNamedElement)((Object)register)).getDeclaration().getStartOffset();
            this.elementPath = ((IRfNamedElement)((Object)register)).getDeclaration().getParserPath().path;
        }
    }

    public BitFieldModel copy(BitFieldModel model, BitfieldViewMode view) {
        BitFieldModel registerModel = new BitFieldModel();
        registerModel.register = model.register;
        registerModel.size = model.size;
        registerModel.lanes = model.lanes;
        registerModel.name = model.name;
        registerModel.elementStartOffset = model.elementStartOffset;
        registerModel.elementPath = model.elementPath;
        registerModel.view = view;
        return registerModel;
    }

    private BitFieldModel() {
    }

    public boolean isUvmRegister() {
        return this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.VLOG_UVM_REG || this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.ELANG_VR_AD;
    }

    private List<String> bitfieldsToWaveJSON() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int generatedLanes = 0;
        int padding = 0;
        int elaboratedSize = this.size;
        if (this.view == BitfieldViewMode.SPLIT && elaboratedSize > 32 && elaboratedSize % 32 != 0) {
            int nextMultiple = (elaboratedSize / 32 + 1) * 32;
            padding = nextMultiple - elaboratedSize;
            elaboratedSize = nextMultiple;
        }
        int start = this.view == BitfieldViewMode.SPLIT ? Math.max(0, elaboratedSize - 32) : 0;
        int end = elaboratedSize;
        while (end > 0) {
            int hspace;
            ArrayList<String> labels = new ArrayList<String>();
            int reducedBitsByTrimming = 0;
            sb.append("{reg: [\n");
            boolean previousEmptyLane = false;
            block1: for (Map.Entry<Integer, List<BitField>> entry : this.lanes.entrySet()) {
                int localStart = start;
                int localEnd = end;
                for (BitField bitfield : entry.getValue()) {
                    if (localStart == localEnd) break;
                    if (bitfield.getPosition() - localStart > 0) {
                        sb.append("{bits:" + (bitfield.getPosition() - localStart) + ", type: 1},\n");
                        localStart = bitfield.getPosition();
                    }
                    if (bitfield.getPosition() + bitfield.getSize() <= localStart) continue;
                    if (bitfield.getPosition() >= localEnd) break;
                    int bitsToDisplay = bitfield.getSize();
                    if (bitfield.getPosition() < localStart) {
                        bitsToDisplay -= localStart - bitfield.getPosition();
                    }
                    if (bitfield.getPosition() + bitfield.getSize() > localEnd) {
                        bitsToDisplay -= bitfield.getPosition() + bitfield.getSize() - localEnd;
                    }
                    if (bitfield.getName().isEmpty() && !this.isUvmRegister()) {
                        if (previousEmptyLane && bitsToDisplay == end - start - padding) continue block1;
                        sb.append("{bits:").append(bitsToDisplay).append("}").append(",\n");
                        if (bitsToDisplay == end - start - padding) {
                            previousEmptyLane = true;
                        }
                    } else {
                        sb.append("{bits:").append(this.needsTrimming(bitfield) ? 3 : bitsToDisplay).append(',').append("name:'").append(this.needsTrimming(bitfield) ? "..." : bitfield.getName()).append('\'').append(',').append("type:").append(bitfield.getColor()).append(',');
                        if (this.isUvmRegister()) {
                            sb.append("attr:'").append(bitfield.getAccess()).append('\'');
                            if (this.needsTrimming(bitfield)) {
                                reducedBitsByTrimming += bitsToDisplay - 3;
                            }
                        } else {
                            sb.append("rect: {parent:'").append(bitfield.getParentNameRaw()).append('\'').append('}');
                        }
                        sb.append("},\n");
                        previousEmptyLane = false;
                    }
                    localStart += bitsToDisplay;
                }
                if (padding > 0) {
                    sb.append("{bits:").append(padding).append("}").append(",\n");
                }
                if (generatedLanes == 0) {
                    labels.add("'\u21aa'");
                } else {
                    labels.add("' '");
                }
                ++generatedLanes;
            }
            sb.append("]\n");
            this.drawSize = (end - start - reducedBitsByTrimming) * generatedLanes;
            int n = hspace = !this.isUvmRegister() && this.view == BitfieldViewMode.LINKED ? Math.max(this.size * 25, 900) : 900;
            String legend = !this.isUvmRegister() && result.isEmpty() ? (((IRfNamedElement)((Object)this.register)).getLanguageKind() == LanguageKind.VHDL ? VHDL_LEGEND : VLOG_LEGEND) : "";
            sb.append(',').append("config:{bits:").append(this.drawSize).append(',').append(this.size > 32 && this.view == BitfieldViewMode.SPLIT ? "margin: {left: 20}," : "").append("lanes: ").append(generatedLanes).append(',').append("hspace: ").append(hspace).append(',').append("offset: ").append(start).append(',').append(this.size > 32 && this.view == BitfieldViewMode.SPLIT ? "label: {left: [" : "").append(this.size > 32 && this.view == BitfieldViewMode.SPLIT ? String.valueOf(labels.stream().collect(Collectors.joining(","))) + "]}," : "").append("sparse: true, compact: true").append(',').append("hflip: true").append(',').append(this.size > 999 ? "fontsize: 10" : "fontsize: 12").append(',').append("trim: 7").append(',').append(legend).append('}').append('}').append('\n');
            result.add(sb.toString());
            padding = 0;
            sb.setLength(0);
            generatedLanes = 0;
            end = start;
            start = Math.max(0, start - 32);
        }
        return result;
    }

    public String getTable(boolean isDarkTheme) {
        return this.isUvmRegister() ? (this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.VLOG_UVM_REG ? this.getUvmRegTable(isDarkTheme) : this.getVrAdRegTable(isDarkTheme)) : this.getRTLTable(isDarkTheme);
    }

    private String getVrAdRegTable(boolean isDarkTheme) {
        StringBuilder sb = new StringBuilder();
        int height = (int)((this.lanes.get(0).stream().filter(b -> !b.isUnused()).count() + 1L) * 20L);
        sb.append("<foreignObject xmlns=\"http://www.w3.org/2000/svg\" x=\"0\" y=\"0\" width=\"900\" height=\"" + height + "\">").append("<div " + (isDarkTheme ? "class=\"dark-mode\"" : "") + " xmlns=\"http://www.w3.org/1999/xhtml\">").append("<table style=\"text-align: start;\" width=\"900px\" >").append("<thead>").append("<tr>").append("<th style= \"width: 25%;\">Field</th>").append("<th style= \"width: 15%;\">Type</th>").append("<th style= \"width: 15%;\">Position</th>").append("<th style= \"width: 15%;\">Size</th>").append("<th style= \"width: 15%;\">Access</th>").append("<th style= \"width: 15%;\">Reset</th>").append("</thead>").append("<tbody>");
        for (Map.Entry<Integer, List<BitField>> entry : this.lanes.entrySet()) {
            entry.getValue().stream().filter(bitfield -> !bitfield.isUnused()).forEach(bitfield -> {
                StringBuilder stringBuilder2 = sb.append("<tr>").append("<td title=\"" + bitfield.getName() + "\">" + bitfield.getName() + "</td>").append("<td>" + bitfield.getType() + "</td>").append("<td>" + bitfield.getPosition() + "</td>").append("<td>" + bitfield.getSize() + "</td>").append("<td>" + bitfield.getAccess() + "</td>").append("<td>" + bitfield.getResetValue() + "</td>").append("</tr>");
            });
        }
        sb.append("</tbody>").append("</table>").append("</div>").append("</foreignObject>");
        return sb.toString();
    }

    public List<BitField> getBitFields() {
        List<BitField> bitFields = this.lanes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (!this.isUvmRegister()) {
            bitFields.sort((o1, o2) -> o1.getPosition() - o2.getPosition());
        }
        return bitFields;
    }

    public String getRTLTable(boolean isDarkTheme) {
        StringBuilder sb = new StringBuilder();
        List<BitField> bitfields = this.getBitFields();
        int nofFields = (int)bitfields.stream().filter(bitfield -> !bitfield.getName().isEmpty()).count();
        sb.append("<foreignObject xmlns=\"http://www.w3.org/2000/svg\" x=\"0\" y=\"0\" width=\"900\" height=\"" + (nofFields + 1) * 20 + "\">").append("<div " + (isDarkTheme ? "class=\"dark-mode\"" : "") + "xmlns=\"http://www.w3.org/1999/xhtml\">").append("<table style=\"margin: auto; text-align: start;\" width=\"900px\" >").append("<thead>").append("<tr>").append("<th style=\"width: 40%\">Name</th>").append("<th style=\"width: 40%\">Type</th>").append("<th style=\"width: 10%\">Position</th>").append("<th style=\"width: 10%\">Size</th>").append("</thead>").append("<tbody>");
        for (BitField bitfield2 : bitfields) {
            if (bitfield2.getName().isEmpty()) continue;
            sb.append("<tr>").append("<td title=\"" + bitfield2.getName() + "\">" + bitfield2.getParentName() + bitfield2.getName() + "</td>").append("<td title=\"" + bitfield2.getType() + "\">" + bitfield2.getType() + "</td>").append("<td>" + bitfield2.getPosition() + "</td>").append("<td>" + bitfield2.getSize() + "</td>").append("</tr>");
        }
        sb.append("</tbody>").append("</table>").append("</div>").append("</foreignObject>");
        return sb.toString();
    }

    public String getUvmRegTable(boolean isDarkTheme) {
        StringBuilder sb = new StringBuilder();
        int height = (int)((this.lanes.get(0).stream().filter(b -> !b.isUnused()).count() + 1L) * 20L);
        sb.append("<foreignObject xmlns=\"http://www.w3.org/2000/svg\" x=\"0\" y=\"0\" width=\"900\" height=\"" + height + "\">").append("<div " + (isDarkTheme ? "class=\"dark-mode\"" : "") + " xmlns=\"http://www.w3.org/1999/xhtml\">").append("<table style=\"text-align: start;\" width=\"900px\" >").append("<thead>").append("<tr>").append("<th style= \"width: 20%;\">Field</th>").append("<th style= \"width: 5%;\">Size</th>").append("<th>Position</th>").append("<th style= \"width: 7%;\">Access</th>").append("<th>Volatility</th>").append("<th style= \"width: 7%;\">Reset</th>").append("<th style= \"width: 12%;\">Has Reset</th>").append("<th style= \"width: 15%;\">Randomized</th>").append("<th>Accessible</th>").append("</thead>").append("<tbody>");
        for (Map.Entry<Integer, List<BitField>> entry : this.lanes.entrySet()) {
            entry.getValue().stream().filter(bitfield -> !bitfield.isUnused()).forEach(bitfield -> {
                StringBuilder stringBuilder2 = sb.append("<tr>").append("<td title=\"" + bitfield.getName() + "\">" + bitfield.getName() + "</td>").append("<td>" + bitfield.getSize() + "</td>").append("<td>" + bitfield.getPosition() + "</td>").append("<td>" + bitfield.getAccess() + "</td>").append("<td>" + bitfield.getVolatile() + "</td>").append("<td>" + bitfield.getResetValue() + "</td>").append("<td>" + bitfield.getHasReset() + "</td>").append("<td>" + bitfield.getRandomized() + "</td>").append("<td>" + bitfield.getAccessible() + "</td>").append("</tr>");
            });
        }
        sb.append("</tbody>").append("</table>").append("</div>").append("</foreignObject>");
        return sb.toString();
    }

    @Override
    public List<String> getTableHeaders() {
        return this.register.getBitFieldKind().getTableHeaders();
    }

    public List<BitField> getTableRows() {
        return this.getBitFields();
    }

    @Override
    public String getTableColumnValue(ITableRowData row, int columnIndex) {
        if (!(row instanceof BitField)) {
            return "";
        }
        BitField bitField = (BitField)row;
        switch (columnIndex) {
            case 0: {
                return bitField.getParentNameRaw().isEmpty() ? bitField.getName() : String.valueOf(bitField.getParentNameRaw()) + "." + bitField.getName();
            }
            case 1: {
                return this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.VLOG_UVM_REG ? String.valueOf(bitField.getSize()) : bitField.getType();
            }
            case 2: {
                return String.valueOf(bitField.getPosition());
            }
            case 3: {
                return this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.VLOG_UVM_REG ? bitField.getAccess() : String.valueOf(bitField.getSize());
            }
            case 4: {
                return this.register.getBitFieldKind() == IBitFieldRegister.BitFieldKind.ELANG_VR_AD ? bitField.getAccess() : String.valueOf(bitField.getVolatile());
            }
            case 5: {
                return String.valueOf(bitField.getResetValue());
            }
            case 6: {
                return String.valueOf(bitField.getHasReset());
            }
            case 7: {
                return String.valueOf(bitField.getRandomized());
            }
            case 8: {
                return String.valueOf(bitField.getAccessible());
            }
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTableName() {
        return "Bit Fields table of " + this.name;
    }

    public String getParserPath() {
        return this.elementPath;
    }

    public int getDeclarationStartOffset() {
        return this.elementStartOffset;
    }

    public int getSize() {
        return this.size;
    }

    public String getUpdatedIndicesForUVMRegisters() {
        if (!this.isUvmRegister()) {
            return null;
        }
        if (this.view == BitfieldViewMode.SPLIT) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray oldIndicesArray = new JSONArray();
        JSONArray newIndicesArray = new JSONArray();
        try {
            int reducedBitsByTrimming = 0;
            for (BitField bitField : this.lanes.get(0)) {
                int size = bitField.getSize();
                int displayedSize = this.needsTrimming(bitField) ? 3 : size;
                oldIndicesArray.put(bitField.getPosition() - reducedBitsByTrimming);
                newIndicesArray.put(bitField.getPosition());
                oldIndicesArray.put(bitField.getPosition() - reducedBitsByTrimming + displayedSize - 1);
                newIndicesArray.put(bitField.getPosition() + size - 1);
                if (!this.needsTrimming(bitField)) continue;
                reducedBitsByTrimming += size - 3;
            }
            jsonObject.put("oldIndices", oldIndicesArray);
            jsonObject.put("newIndices", newIndicesArray);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return jsonObject.toString();
    }

    public boolean isEmpty() {
        return this.lanes.isEmpty();
    }

    public List<String> toWaveJSON() {
        return this.bitfieldsToWaveJSON();
    }

    public String getHeader() {
        return this.register.getBitFieldDiagramHeader();
    }

    private boolean needsTrimming(BitField bitfield) {
        return this.view == BitfieldViewMode.LINKED && this.isUvmRegister() && bitfield.isUnused() && bitfield.getSize() > 3;
    }

    public int hashCode() {
        return Objects.hash(this.elementStartOffset, this.lanes, this.name, this.size, this.view.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitFieldModel other = (BitFieldModel)obj;
        return Objects.equals(this.elementPath, other.elementPath) && this.elementStartOffset == other.elementStartOffset && Objects.equals(this.lanes, other.lanes) && Objects.equals(this.name, other.name) && this.size == other.size && this.view.equals((Object)other.view);
    }
}

