/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wavedrom;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;

public abstract class WaveDromManagerCommon {
    public static final String WAVE_DROM_DESCRIPTION_EXCEEDS = "WaveDrom description exceeds";
    public static final String WAVE_DROM_FILE_NOT_FOUND = "WaveDrom description file not found!";
    public static final String WAVE_DROM_FILE_WRONG_EXT = "WaveDrom description file does not have a valid extension!";
    private static final String WAVE_JSON_ELEMENT_TAG = "wave:";
    private static final String BITS_JSON_ELEMENT_TAG = "bits:";
    private static final Pattern WAVEDROM_FILE_PATTERN = Pattern.compile("@WAVEDROM_FILE\\s+([^\\s]+)");
    private static final String SL_SLASH_COMMENT = "(?m)^\\s*[/]{2,}";
    private static final String SL_DASH_COMMENT = "(?m)^\\s*[-]{2,}";
    private static final String ML_COMMENT = "(?m)^\\s*[*]*";

    private String getCurrentPartition(IDocument document, String editorPartition, int offset) {
        String result = "";
        try {
            result = ((IDocumentExtension3)document).getContentType(editorPartition, offset, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public String getWaveform(IDocument document, IFile file, int offset, String editorPartition, String waveformPartition) {
        char currentCharacter;
        if (!DVTPlugin.getDefault().collect().c()) {
            return "";
        }
        if (file != null && file.exists()) {
            String fileName;
            int filePragmaOffset;
            String pragmaPartition;
            String lineContent;
            int lineOffset;
            try {
                int line = document.getLineOfOffset(offset);
                lineOffset = document.getLineOffset(line);
                lineContent = document.get(lineOffset, document.getLineLength(line));
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
            Matcher matcher = WAVEDROM_FILE_PATTERN.matcher(lineContent);
            if (matcher.find() && (pragmaPartition = this.getCurrentPartition(document, editorPartition, filePragmaOffset = lineOffset + lineContent.indexOf(fileName = matcher.group(1)))).equals(waveformPartition)) {
                return this.searchWaveformInFileLocations(fileName);
            }
        }
        StringBuilder waveform = new StringBuilder();
        DVTCharacterScanner scanner = new DVTCharacterScanner(100, document, offset, true);
        boolean potentialPragma = false;
        StringBuilder pragmaFinder = new StringBuilder();
        while ((currentCharacter = (char)scanner.read()) != '\uffff') {
            if (scanner.getOffset() >= offset + this.getWaveformMaxLength()) {
                if (waveform.toString().contains(WAVE_JSON_ELEMENT_TAG) || waveform.toString().contains(BITS_JSON_ELEMENT_TAG)) {
                    return this.getWavedromTooLargeErrorMessage();
                }
                return "";
            }
            String currentPartition = this.getCurrentPartition(document, editorPartition, scanner.getOffset() - 1);
            if (!currentPartition.equals(waveformPartition) && (!currentPartition.equals("__dftl_partition_content_type") || !Character.isWhitespace(currentCharacter))) break;
            waveform.append(currentCharacter);
            if (currentCharacter == '@') {
                potentialPragma = true;
                pragmaFinder.setLength(0);
            }
            if (potentialPragma) {
                pragmaFinder.append(currentCharacter);
            }
            if (pragmaFinder.length() == "@WAVEDROM_END".length()) {
                if (!pragmaFinder.toString().equals("@WAVEDROM_END")) continue;
                break;
            }
            if (pragmaFinder.length() != "@WAVEDROM_START".length()) continue;
            if (pragmaFinder.toString().equals("@WAVEDROM_START")) {
                return "";
            }
            pragmaFinder.setLength(0);
            potentialPragma = false;
        }
        if (!waveform.toString().endsWith("@WAVEDROM_END")) {
            return "";
        }
        waveform = waveform.reverse();
        int charactersRead = scanner.getOffset() - offset;
        scanner.setOffset(offset);
        scanner.setBackwardDirection();
        pragmaFinder.setLength(0);
        potentialPragma = false;
        while ((currentCharacter = (char)scanner.read()) != '\uffff') {
            if (scanner.getOffset() <= offset - (this.getWaveformMaxLength() - charactersRead)) {
                if (waveform.toString().contains(new StringBuilder(WAVE_JSON_ELEMENT_TAG).reverse().toString()) || waveform.toString().contains(new StringBuilder(BITS_JSON_ELEMENT_TAG).reverse().toString())) {
                    return this.getWavedromTooLargeErrorMessage();
                }
                return "";
            }
            String currentPartition = this.getCurrentPartition(document, editorPartition, scanner.getOffset());
            if (!currentPartition.equals(waveformPartition) && (!currentPartition.equals("__dftl_partition_content_type") || !Character.isWhitespace(currentCharacter))) break;
            waveform.append(currentCharacter);
            if (currentCharacter == '@' && waveform.toString().endsWith(new StringBuilder("@WAVEDROM_START").reverse().toString())) break;
        }
        if (!(waveform = waveform.reverse()).toString().startsWith("@WAVEDROM_START")) {
            return "";
        }
        return this.formatWaveform(waveform.toString(), waveformPartition, editorPartition);
    }

    private String searchWaveformInFileLocations(String wavedromFilePath) {
        File wavedromFile;
        block11: {
            block10: {
                String waveform;
                block9: {
                    waveform = "";
                    if (BuildConfigManager.getWavedromFileExtensions(RfMixedLangManager.getInstance().getProject()).stream().filter(ext -> wavedromFilePath.endsWith(String.valueOf('.') + ext)).findAny().isPresent()) break block9;
                    return WAVE_DROM_FILE_WRONG_EXT;
                }
                try {
                    Path path = Paths.get(wavedromFilePath, new String[0]);
                    if (path != null && path.isAbsolute()) {
                        return new String(Files.readAllBytes(path));
                    }
                    for (String location : BuildConfigManager.getWavedromFilesLocations(RfMixedLangManager.getInstance().getProject())) {
                        File wavedromFile2 = new File(String.valueOf(location) + File.separator + wavedromFilePath);
                        if (!wavedromFile2.exists()) continue;
                        try {
                            waveform = new String(Files.readAllBytes(Paths.get(wavedromFile2.getCanonicalPath(), new String[0])));
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            continue;
                        }
                        return waveform;
                    }
                    if (RfMixedLangManager.getInstance().getProject().getLocation() != null) break block10;
                    return WAVE_DROM_FILE_NOT_FOUND;
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return "";
                }
            }
            wavedromFile = new File(String.valueOf(RfMixedLangManager.getInstance().getProject().getLocation().toOSString()) + File.separator + wavedromFilePath);
            if (wavedromFile.exists()) break block11;
            return WAVE_DROM_FILE_NOT_FOUND;
        }
        return new String(Files.readAllBytes(wavedromFile.toPath()));
    }

    public String getCommentWithExtractedWaveformFile(String comment) {
        Matcher matcher = WAVEDROM_FILE_PATTERN.matcher(comment);
        while (matcher.find()) {
            String fileName = matcher.group(1);
            String waveform = this.searchWaveformInFileLocations(fileName);
            if (!waveform.isEmpty() && !waveform.equals(WAVE_DROM_FILE_NOT_FOUND)) {
                waveform = "@WAVEDROM_START\n" + waveform + "@WAVEDROM_END";
                comment = comment.replace(matcher.group(0), waveform);
                continue;
            }
            comment = comment.replace(matcher.group(0), "");
        }
        return comment;
    }

    private String formatWaveform(String waveform, String waveformPartiton, String editorPartition) {
        if (waveform == null || waveform.isEmpty()) {
            return "";
        }
        waveform = waveform.replace("@WAVEDROM_START", "").replace("@WAVEDROM_END", "");
        if ("__vlog_partitioning".equals(editorPartition) || "__pss_partitioning".equals(editorPartition)) {
            if (DVTEditor.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_SLASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        if ("__vhdl_partitioning".equals(editorPartition)) {
            if (DVTEditor.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_DASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        if ("__e_partitioning".equals(editorPartition)) {
            if (DVTEditor.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_DASH_COMMENT, "").replaceAll(SL_SLASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        return "";
    }

    public String getWavedromTooLargeErrorMessage() {
        return "WaveDrom description exceeds the " + this.getWaveformMaxLength() + " characters threshold.<br>" + "You can change the threshold value from <a href=\"" + "ro.amiq.dvt.EditorsPreferencePage" + "?openPreferenceDialog" + "\">Editors Preference Page</a>.";
    }

    protected abstract int getWaveformMaxLength();
}

