/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wavedrom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;

public abstract class WavedromCommon {
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER;
    protected static final Invocable JS;
    private static final String JS_SCRIPT;
    public static final String DARK_MODE_CSS_CLASS_NAME = "dark-mode";
    private static final ThreadLocal<ScriptEngine> SPECADOR_LOCAL_ENGINES;

    static {
        block15: {
            String script;
            Invocable js;
            block13: {
                SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
                js = null;
                script = null;
                try {
                    try {
                        ScriptEngine scriptEngine = SCRIPT_ENGINE_MANAGER.getEngineByName("rhino");
                        if (scriptEngine == null) break block13;
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (InputStream stream = JarUtils.getFileStream("/resources/wavedrom/wavedrom.dvt.rhino.js", Wavedrom.class);){
                            script = DVTStringUtil.streamToString(stream);
                            scriptEngine.eval(script);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        js = (Invocable)((Object)scriptEngine);
                    }
                    catch (Exception exception) {
                        DVTLogger.INSTANCE.logError("Error initializing WaveDrom JavaScript engine!");
                        js = null;
                        script = null;
                        JS = js;
                        JS_SCRIPT = script;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    JS = js;
                    JS_SCRIPT = script;
                    throw throwable;
                }
            }
            JS = js;
            JS_SCRIPT = script;
        }
        SPECADOR_LOCAL_ENGINES = ThreadLocal.withInitial(() -> {
            ScriptEngine engine = SCRIPT_ENGINE_MANAGER.getEngineByName("rhino");
            try {
                engine.eval(JS_SCRIPT);
            }
            catch (ScriptException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return engine;
        });
    }

    protected void checkJS() {
        if (JS == null) {
            throw new IllegalStateException("Wavedrom Engine has encountered an error during initialization!");
        }
    }

    public String generateSVG(File file) throws IOException, NoSuchMethodException, ScriptException {
        this.checkJS();
        return this.generateSVG(new String(Files.readAllBytes(file.toPath())));
    }

    public synchronized String generateSVG(String json) throws NoSuchMethodException, ScriptException {
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return "";
        }
        return this.generateSVG(json, this.isDarkTheme());
    }

    public synchronized String generateSVG(String json, boolean isDarkTheme) throws NoSuchMethodException, ScriptException {
        this.checkJS();
        if (json == null || json.isEmpty()) {
            return "";
        }
        return (String)JS.invokeMethod(((ScriptEngine)((Object)JS)).get("dvt"), "generateSVG", json, "", this.isVSCode(), isDarkTheme);
    }

    public synchronized String generateSVGForSpecador(String json) throws NoSuchMethodException, ScriptException {
        this.checkJS();
        if (json == null || json.isEmpty()) {
            return "";
        }
        return (String)JS.invokeMethod(((ScriptEngine)((Object)JS)).get("dvt"), "generateSVG", json, "", false, false);
    }

    public synchronized String generateBitfieldSVG(BitFieldModel registerModel) throws NoSuchMethodException, ScriptException {
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return "";
        }
        return this.generateBitfieldSVG(registerModel, this.isDarkTheme());
    }

    public synchronized String generateBitfieldSVG(BitFieldModel registerModel, boolean isDarkTheme) throws NoSuchMethodException, ScriptException {
        this.checkJS();
        if (registerModel == null) {
            return "";
        }
        return (String)JS.invokeMethod(((ScriptEngine)((Object)JS)).get("dvt"), "generateSVG", registerModel.toWaveJSON(), registerModel.getTable(isDarkTheme), this.isVSCode(), isDarkTheme, registerModel.getUpdatedIndicesForUVMRegisters());
    }

    public String generateSpecadorBitfieldSVG(BitFieldModel registerModel) {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    ScriptEngine scriptEngine = SPECADOR_LOCAL_ENGINES.get();
                    return (String)((Invocable)((Object)scriptEngine)).invokeMethod(scriptEngine.get("dvt"), "generateSVG", registerModel.toWaveJSON(), "", false, false, registerModel.getUpdatedIndicesForUVMRegisters());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return "";
                }
            }).get();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public abstract boolean isVSCode();

    protected abstract boolean isDarkTheme();

    public abstract String generateHTMLBitfieldTitle(BitFieldModel var1) throws NoSuchMethodException, ScriptException;
}

