/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw;

import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.draw.DCanvasCommon;
import ro.amiq.dvt.draw.DMagnifier;
import ro.amiq.dvt.draw.DViewport;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.draw.handlers.DClickHandler;
import ro.amiq.dvt.draw.handlers.DPanHandler;
import ro.amiq.dvt.draw.handlers.DResizeHandler;
import ro.amiq.dvt.draw.handlers.DZoomHandler;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.render.swt.DSWTDebug;
import ro.amiq.dvt.draw.render.swt.DSWTRenderer;

public class DCanvas
extends DCanvasCommon {
    private final DDebug debug;
    private final DViewport viewport = new DViewport(this);
    private final DMagnifier magnifier = new DMagnifier(this);
    private final DSWTRenderer renderer = new DSWTRenderer(this);
    private final DPanHandler panHandler = new DPanHandler(this);
    private final DZoomHandler zoomHandler = new DZoomHandler(this);
    private final DResizeHandler resizeHandler = new DResizeHandler(this);

    public DCanvas(Composite parent) {
        super(parent, 0x140000);
        this.clickHandler = new DClickHandler(this);
        this.debug = DSWTDebug.getInstance(this);
    }

    public DDebug getDebug() {
        return this.debug;
    }

    public DViewport getViewport() {
        return this.viewport;
    }

    public DMagnifier getMagnifier() {
        return this.magnifier;
    }

    public DSWTRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    protected void setContentBeforeRender(DObject root) {
        this.content = root;
        this.viewport.setContentSize(this.content.getBounds());
        this.magnifier.setContentSize(this.content.getBounds());
    }

    @Override
    public void setContent(DObject root) {
        this.setContentBeforeRender(root);
        this.viewport.zoomToFitCanvas();
    }

    @Override
    public void setContent(DObject root, DObject[] focused, double lastScale) {
        this.setContentBeforeRender(root);
        this.viewport.zoomToNewContentObject(focused, lastScale);
    }
}

