/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw;

import java.io.File;
import java.io.IOException;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.draw.debug.DDebugExporter;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.render.svg.DSVGExporter;
import ro.amiq.dvt.draw.render.swt.DSWTExporter;

public enum DExporter {
    BMP(DSWTExporter.INSTANCE_BMP, true),
    JPEG(DSWTExporter.INSTANCE_JPEG, true),
    PNG(DSWTExporter.INSTANCE_PNG, true),
    KGX(DDebugExporter.INSTANCE, false),
    SVG(DSVGExporter.INSTANCE, false);

    private final DExporterImplementation implementation;
    private final boolean isBitmap;

    private DExporter(DExporterImplementation exporter, boolean isBitmap) {
        this.implementation = exporter;
        this.isBitmap = isBitmap;
    }

    public boolean isBitmap() {
        return this.isBitmap;
    }

    public String getFormat() {
        return this.name().toLowerCase();
    }

    public String getExtension() {
        return "." + this.getFormat();
    }

    public void export(File file, DObject content, double expScale, DProperties properties) throws IOException {
        if (file == null || content == null) {
            throw new IllegalArgumentException();
        }
        File directory = file.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Can't create directory " + directory.getAbsolutePath());
        }
        this.implementation.export(file, content, expScale, properties == null ? DProperties.EMPTY : properties);
    }

    public String export(DObject content, double expScale, DProperties properties) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return this.implementation.export(content, expScale, properties == null ? DProperties.EMPTY : properties);
    }

    public static DExporter[] getAvailableExporters() {
        if (DConstants.DEBUG) {
            return new DExporter[]{BMP, JPEG, PNG, SVG, KGX};
        }
        return new DExporter[]{BMP, JPEG, PNG, SVG};
    }

    public static interface DExporterImplementation {
        public void export(File var1, DObject var2, double var3, DProperties var5) throws IOException;

        public String export(DObject var1, double var2, DProperties var4);
    }
}

