/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.DViewport;
import ro.amiq.dvt.draw.handlers.DMagnifierHandler;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class DMagnifier
extends DViewport {
    public static final int BORDER_WIDTH = 2;
    public static final RGB BORDER_COLOR = ColorFactory.getInstance().getRGB(144, 144, 144);
    private static final int DEFAULT_MAGNIFIER_ZOOM = 5;
    private static final double SIZE_RATIO_UPDATE_STEP = 0.03;
    private static final double MIN_MAGNIFIER_SIZE_RATIO = 0.08;
    private static final double MAX_MAGNIFIER_SIZE_RATIO = 0.5;
    private static final double DEFAULT_MAGNIFIER_SIZE_RATIO = 0.2;
    private final DMagnifierHandler magnifierHandler;
    private final int screenHeight;
    private int borderX;
    private int borderY;
    private int initBorderX;
    private int initBorderY;
    private int contentX;
    private int contentY;
    private int zoom;
    private int diameter;
    private double sizeRatio;

    public DMagnifier(DCanvas canvas) {
        super(canvas);
        this.magnifierHandler = new DMagnifierHandler(canvas);
        this.screenHeight = this.getDisplayHeight();
        this.zoom = DVTPlugin.getDefault().getPreferences().getInt("daigram.magnifier.zoom", 5);
        if (this.zoom == 0) {
            this.zoom = 5;
            DVTPlugin.getDefault().getPreferences().putInt("daigram.magnifier.zoom", this.zoom);
        }
        this.sizeRatio = DVTPlugin.getDefault().getPreferences().getDouble("daigram.magnifier.size_ratio", 0.2);
        if (this.sizeRatio == 0.0) {
            this.sizeRatio = 0.2;
            DVTPlugin.getDefault().getPreferences().putDouble("daigram.magnifier.size_ratio", this.sizeRatio);
        }
        this.diameter = (int)((double)this.screenHeight * this.sizeRatio);
    }

    private int getDisplayHeight() {
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        if (shell == null) {
            return 768;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return 768;
        }
        Rectangle bounds = display.getBounds();
        if (bounds == null) {
            return 768;
        }
        return bounds.height;
    }

    public void matchTransformToParentViewport(DViewport parent) {
        this.panX = parent.getPanX();
        this.panY = parent.getPanY();
        this.scaleCenterX = parent.getScaleCenterX();
        this.scaleCenterY = parent.getScaleCenterY();
        this.setScale(parent.getScale());
        this.updateTransform();
    }

    public void setContentX(int x) {
        this.contentX = x;
    }

    public void setContentY(int y) {
        this.contentY = y;
    }

    public void setBorderX(int x) {
        this.borderX = x;
        this.initBorderX = x;
    }

    public void setBorderY(int y) {
        this.borderY = y;
        this.initBorderY = y;
    }

    public int getContentX() {
        return this.contentX;
    }

    public int getContentY() {
        return this.contentY;
    }

    public int getBorderX() {
        return this.borderX;
    }

    public int getBorderY() {
        return this.borderY;
    }

    public int getRadius() {
        return this.diameter / 2;
    }

    @Override
    public void setCanvasSize(Rectangle editorArea) {
        Rectangle canvasSize;
        int width = editorArea.width;
        int height = editorArea.height;
        int actualDiameter = (int)((double)this.screenHeight * DVTPlugin.getDefault().getPreferences().getDouble("daigram.magnifier.size_ratio", 0.2));
        if (actualDiameter > width || actualDiameter > height) {
            int minDiameter = Math.min(width, height);
            int deltaDiameter = minDiameter - this.diameter;
            this.borderX -= deltaDiameter;
            this.borderY -= deltaDiameter;
            this.diameter = minDiameter;
            this.sizeRatio = this.getSizeRatioFromDiameter();
        }
        if ((canvasSize = this.getCanvasSize()) == null) {
            return;
        }
        this.borderX = this.borderX < 0 || this.borderX == 0 && this.initBorderX == 0 ? 0 : (this.borderX -= canvasSize.width - width);
        this.borderY = this.borderY < 0 || this.borderY == 0 && this.initBorderY == 0 ? 0 : (this.borderY -= canvasSize.height - height);
        super.setCanvasSize(editorArea);
    }

    @Override
    public void setContentSize(Rectangle size) {
        super.setContentSize(size);
        this.magnifierHandler.setIsEnabled(false);
        this.magnifierHandler.setIsVisible(false);
    }

    public void updateSizeRatio(int amount) {
        double newSizeRatio = this.sizeRatio + 0.03 * (double)amount;
        double minDiameter = 0.08 * (double)this.screenHeight;
        int newDiameter = (int)(newSizeRatio * (double)this.screenHeight);
        double maxDiameter = 0.5 * (double)this.screenHeight;
        this.diameter = (double)newDiameter > maxDiameter ? (int)maxDiameter : ((double)newDiameter < minDiameter ? (int)minDiameter : newDiameter);
        this.sizeRatio = newSizeRatio;
        DVTPlugin.getDefault().getPreferences().putDouble("daigram.magnifier.size_ratio", this.sizeRatio);
    }

    public void setSizeRatio(int diameter) {
        this.diameter = diameter;
        this.sizeRatio = this.getSizeRatioFromDiameter();
        DVTPlugin.getDefault().getPreferences().putDouble("daigram.magnifier.size_ratio", this.sizeRatio);
    }

    public void resetSizeRatio() {
        this.sizeRatio = 0.2;
        this.diameter = (int)((double)this.screenHeight * this.sizeRatio);
        DVTPlugin.getDefault().getPreferences().putDouble("daigram.magnifier.size_ratio", this.sizeRatio);
    }

    public int getDiameter() {
        return this.diameter;
    }

    private double getSizeRatioFromDiameter() {
        return (double)this.diameter / (double)this.screenHeight;
    }

    public void updateZoom(int amount) {
        this.zoom += amount;
        DVTPlugin.getDefault().getPreferences().putInt("daigram.magnifier.zoom", this.zoom);
    }

    public void resetZoom() {
        this.zoom = 5;
        DVTPlugin.getDefault().getPreferences().putInt("daigram.magnifier.zoom", this.zoom);
    }

    public int getZoom() {
        return this.zoom;
    }

    public DMagnifierHandler getHandler() {
        return this.magnifierHandler;
    }
}

